/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.bandits;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterRanged;
import ydmsama.hundred_years_war.main.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.main.entity.goals.HywWaterAvoidingRandomStrollGoal;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentLevelData;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentOption;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

public class BanditRaiderEntity
extends BaseCombatEntity
implements LightUnit,
CounterRanged {
    private static final float ATTACK_REACH = 2.5f;
    private static final float MOVEMENT_SPEED = 0.34f;
    private static final UUID DAMAGE_SCALE_MODIFIER = UUID.fromString("f9f2c1c7-1027-49ba-87a5-06bb3d92a3fd");
    private int offhandAttackDelay = -1;
    private LivingEntity offhandAttackTarget;
    private int chargeCooldown = 0;
    private int chargeTicks = 0;
    private boolean performingCharge = false;

    public BanditRaiderEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
    }

    public static AttributeSupplier.Builder createBanditRaiderAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, (double)0.34f).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22276_, 32.0).m_22268_(Attributes.f_22278_, 0.4).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 2.5);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.tickOffhandStrike();
            this.tickCharge();
        }
    }

    @Override
    protected void setDefaultEquipment() {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42383_));
    }

    @Override
    protected void setEquipmentFromLevelData(EquipmentLevelData levelData) {
        EquipmentOption option;
        ItemStack stack;
        super.setEquipmentFromLevelData(levelData);
        List<EquipmentOption> options = levelData.getOffHandWeapon();
        if (options != null && !options.isEmpty() && !(stack = this.createItemStack(option = this.selectRandomItem(options))).m_41619_()) {
            this.m_8061_(EquipmentSlot.OFFHAND, stack);
        }
    }

    private void tickOffhandStrike() {
        if (this.offhandAttackDelay > 0) {
            --this.offhandAttackDelay;
            if (this.offhandAttackDelay == 0 && this.offhandAttackTarget != null && this.offhandAttackTarget.m_6084_()) {
                this.m_21011_(InteractionHand.OFF_HAND, true);
                this.clearImmunity(this.offhandAttackTarget);
                this.performScaledAttack(this.offhandAttackTarget, 0.8f);
            }
            if (this.offhandAttackDelay == 0) {
                this.offhandAttackDelay = -1;
                this.offhandAttackTarget = null;
            }
        } else if (this.offhandAttackTarget != null && !this.offhandAttackTarget.m_6084_()) {
            this.offhandAttackTarget = null;
            this.offhandAttackDelay = -1;
        }
    }

    private void tickCharge() {
        if (this.chargeCooldown > 0) {
            --this.chargeCooldown;
        }
        if (this.performingCharge) {
            if (this.chargeTicks > 0) {
                --this.chargeTicks;
                if (this.chargeTicks % 3 == 0) {
                    this.dealChargeDamage();
                }
                if (this.m_20096_() && this.chargeTicks < 5) {
                    this.performingCharge = false;
                }
            } else {
                this.performingCharge = false;
            }
        } else if (this.chargeCooldown <= 0) {
            this.tryStartCharge();
        }
    }

    private void tryStartCharge() {
        LivingEntity target = this.getHywTarget();
        if (target == null || !target.m_6084_() || this.m_20159_()) {
            return;
        }
        double distanceSq = this.m_20280_((Entity)target);
        if (distanceSq < 9.0 || distanceSq > 144.0) {
            return;
        }
        if (!this.m_20096_()) {
            return;
        }
        Vec3 dir = new Vec3(target.m_20185_() - this.m_20185_(), 0.0, target.m_20189_() - this.m_20189_());
        if (dir.m_82556_() < 1.0E-4) {
            return;
        }
        Vec3 motion = dir.m_82541_().m_82490_(1.35);
        this.m_20334_(motion.f_82479_, 0.35, motion.f_82481_);
        this.f_19812_ = true;
        this.chargeTicks = 15;
        this.performingCharge = true;
        this.chargeCooldown = 80;
        this.m_21573_().m_26573_();
        this.spawnChargeParticles();
    }

    private void spawnChargeParticles() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_() + 0.2, this.m_20189_(), 8, 0.2, 0.0, 0.2, 0.0);
        }
    }

    private void dealChargeDamage() {
        AABB box = this.m_20191_().m_82400_(1.5);
        List targets = this.m_9236_().m_6443_(LivingEntity.class, box, this::isEnemyTarget);
        for (LivingEntity living : targets) {
            this.clearImmunity(living);
            living.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)(this.m_21133_(Attributes.f_22281_) * (double)0.9f));
            living.m_147240_((double)0.4f, this.m_20185_() - living.m_20185_(), this.m_20189_() - living.m_20189_());
        }
    }

    private boolean isEnemyTarget(LivingEntity living) {
        if (living == this) {
            return false;
        }
        return ServerRelationHelper.isEnemyRelation((Entity)this, (Entity)living);
    }

    private void scheduleOffhandStrike(LivingEntity target) {
        this.offhandAttackTarget = target;
        this.offhandAttackDelay = Math.max(1, this.getSwingDurationTicks() + 1);
    }

    private void clearImmunity(LivingEntity target) {
        target.f_19802_ = 0;
        target.f_20916_ = 0;
    }

    private boolean performScaledAttack(LivingEntity target, float multiplier) {
        AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22281_);
        AttributeModifier modifier = null;
        if (attributeInstance != null) {
            modifier = new AttributeModifier(DAMAGE_SCALE_MODIFIER, "BanditRaiderScale", (double)multiplier - 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
            attributeInstance.m_22118_(modifier);
        }
        boolean success = super.m_7327_((Entity)target);
        if (attributeInstance != null && modifier != null) {
            attributeInstance.m_22130_(modifier);
        }
        return success;
    }

    public boolean m_7327_(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            this.clearImmunity(living);
            boolean success = this.performScaledAttack(living, 0.8f);
            this.clearImmunity(living);
            if (living.m_6084_()) {
                this.scheduleOffhandStrike(living);
            }
            return success;
        }
        return super.m_7327_(entity);
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 8;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 4;
    }

    @Override
    public int getAttackCoolDownDuration() {
        return 6;
    }

    @Override
    protected boolean allowBetterCombatAttack() {
        return false;
    }

    @Override
    protected boolean allowEquipmentReplacement() {
        return false;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new HywWaterAvoidingRandomStrollGoal(this, 0.85));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        super.m_8099_();
    }

    @Override
    public Item getScrollType() {
        return (Item)HywItemRegistry.SCROLL_BANDIT_RAIDER.get();
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("ChargeCooldown", this.chargeCooldown);
        tag.m_128379_("PerformingCharge", this.performingCharge);
        tag.m_128405_("ChargeTicks", this.chargeTicks);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.chargeCooldown = tag.m_128451_("ChargeCooldown");
        this.performingCharge = tag.m_128471_("PerformingCharge");
        this.chargeTicks = tag.m_128451_("ChargeTicks");
    }

    public boolean isCharging() {
        return this.performingCharge;
    }

    @Override
    public double getRangedDamageModifier() {
        return 1.3;
    }

    @Override
    public int getSkinCounts() {
        return 3;
    }

    private int getSwingDurationTicks() {
        if (MobEffectUtil.m_19584_((LivingEntity)this)) {
            return 6 - (1 + MobEffectUtil.m_19586_((LivingEntity)this));
        }
        if (this.m_21023_(MobEffects.f_19599_)) {
            return 6 + (1 + this.m_21124_(MobEffects.f_19599_).m_19564_()) * 2;
        }
        return 6;
    }
}

