/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.projectile;

import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.utils.ProjectileHitUtils;

public class RocketEntity
extends AbstractArrow {
    private static final float BURN_TIME_FACTOR = 3.0f;
    private static final float ACCELERATION_FACTOR = 0.01f;
    private static final float AW2_GRAVITY_FACTOR = 0.024525002f;
    private int rocketBurnTime = 0;
    private boolean hasFuel = false;
    private float accelerationX;
    private float accelerationY;
    private float accelerationZ;

    public RocketEntity(EntityType<? extends RocketEntity> entityType, LivingEntity livingEntity, Level level) {
        super(entityType, livingEntity, level);
        this.m_20242_(true);
    }

    public RocketEntity(EntityType<RocketEntity> rocketEntityType, Level level) {
        super(rocketEntityType, level);
        this.m_20242_(true);
    }

    public void setRocketParams(float velocityX, float velocityY, float velocityZ) {
        float motionX = velocityX * 0.05f;
        float motionY = velocityY * 0.05f;
        float motionZ = velocityZ * 0.05f;
        float motionMagnitude = Mth.m_14116_((float)(motionX * motionX + motionY * motionY + motionZ * motionZ));
        float burnTimeVariation = 0.95f + this.f_19796_.m_188501_() * 0.1f;
        this.rocketBurnTime = (int)(motionMagnitude * 20.0f * 3.0f * burnTimeVariation);
        boolean bl = this.hasFuel = this.rocketBurnTime > 0;
        if (motionMagnitude > 0.0f) {
            this.accelerationX = motionX / motionMagnitude * 0.01f;
            this.accelerationY = motionY / motionMagnitude * 0.01f;
            this.accelerationZ = motionZ / motionMagnitude * 0.01f;
            this.m_20334_(this.accelerationX, this.accelerationY, this.accelerationZ);
        }
    }

    public void setRocketParamsFromCalculator(float velocityX, float velocityY, float velocityZ, float calculatedVelocity) {
        float motionX = velocityX * 0.05f;
        float motionY = velocityY * 0.05f;
        float motionZ = velocityZ * 0.05f;
        float motionMagnitude = Mth.m_14116_((float)(motionX * motionX + motionY * motionY + motionZ * motionZ));
        float burnTimeVariation = 0.95f + this.f_19796_.m_188501_() * 0.1f;
        this.rocketBurnTime = (int)(motionMagnitude * 20.0f * 3.0f * burnTimeVariation);
        boolean bl = this.hasFuel = this.rocketBurnTime > 0;
        if (motionMagnitude > 0.0f) {
            this.accelerationX = motionX / motionMagnitude * 0.01f;
            this.accelerationY = motionY / motionMagnitude * 0.01f;
            this.accelerationZ = motionZ / motionMagnitude * 0.01f;
            this.m_20334_(this.accelerationX, this.accelerationY, this.accelerationZ);
        }
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            if (this.hasFuel && this.rocketBurnTime > 0) {
                this.rocketBurnPhase();
            } else {
                this.gravityPhase();
            }
        }
        this.m_20242_(true);
        super.m_8119_();
        if (this.f_19797_ > 6000) {
            this.m_146870_();
        }
    }

    private void rocketBurnPhase() {
        Vec3 currentMotion = this.m_20184_();
        this.m_20334_(currentMotion.f_82479_ + (double)this.accelerationX, currentMotion.f_82480_ + (double)this.accelerationY, currentMotion.f_82481_ + (double)this.accelerationZ);
        --this.rocketBurnTime;
        if (this.rocketBurnTime <= 0) {
            this.hasFuel = false;
        }
        if (this.m_9236_() instanceof ServerLevel && this.f_19797_ % 3 == 0) {
            this.sendParticlesToAllNearby((ServerLevel)this.m_9236_(), ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.2);
            this.sendParticlesToAllNearby((ServerLevel)this.m_9236_(), ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.02);
        }
    }

    private void gravityPhase() {
        Vec3 currentMotion = this.m_20184_();
        this.m_20334_(currentMotion.f_82479_, currentMotion.f_82480_ - 0.024525001645088196, currentMotion.f_82481_);
        if (this.m_9236_() instanceof ServerLevel && this.f_19797_ % 3 == 0) {
            this.sendParticlesToAllNearby((ServerLevel)this.m_9236_(), ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.02);
        }
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        if (hitResult.m_6662_() != HitResult.Type.MISS) {
            if (this.m_9236_() instanceof ServerLevel) {
                Vec3 hitPos = ProjectileHitUtils.getPreciseHitLocation(hitResult, (Projectile)this);
                this.applyRocketAreaDamage(hitPos);
                this.sendParticlesToAllNearby((ServerLevel)this.m_9236_(), ParticleTypes.f_123813_, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 1, 0.5, 0.5, 0.5, 0.1);
                this.m_9236_().m_6263_(null, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, SoundEvents.f_11913_, this.m_5720_(), 3.5f, 1.0f + (this.f_19796_.m_188501_() - 0.5f) * 0.2f);
            }
            this.m_146870_();
        }
    }

    private void applyRocketAreaDamage(Vec3 hitPos) {
        double damageRadius = 5.0;
        float damageAmount = (float)this.m_36789_() * 0.6f;
        AABB damageArea = new AABB(hitPos.f_82479_ - damageRadius, hitPos.f_82480_ - damageRadius, hitPos.f_82481_ - damageRadius, hitPos.f_82479_ + damageRadius, hitPos.f_82480_ + damageRadius, hitPos.f_82481_ + damageRadius);
        Holder.Reference explosionDamageType = this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268565_);
        DamageSource damageSource = new DamageSource((Holder)explosionDamageType, this.m_19749_(), (Entity)this);
        for (Entity entity : this.m_9236_().m_45933_((Entity)this, damageArea)) {
            float finalDamage;
            float distanceFactor;
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity == this.m_19749_()) continue;
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof BaseCombatEntity) {
                BaseCombatEntity combatEntity = (BaseCombatEntity)entity2;
                if (!combatEntity.isValidTarget(livingEntity)) continue;
                double distance = livingEntity.m_20182_().m_82554_(hitPos);
                distanceFactor = Math.max(0.3f, 1.0f - (float)(distance / damageRadius));
                finalDamage = damageAmount * distanceFactor;
                entity.m_6469_(damageSource, finalDamage);
                continue;
            }
            double distance = livingEntity.m_20182_().m_82554_(hitPos);
            distanceFactor = Math.max(0.3f, 1.0f - (float)(distance / damageRadius));
            finalDamage = damageAmount * distanceFactor;
            entity.m_6469_(damageSource, finalDamage);
        }
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_11913_;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("RocketBurnTime", this.rocketBurnTime);
        compound.m_128379_("HasFuel", this.hasFuel);
        compound.m_128350_("AccelerationX", this.accelerationX);
        compound.m_128350_("AccelerationY", this.accelerationY);
        compound.m_128350_("AccelerationZ", this.accelerationZ);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.rocketBurnTime = compound.m_128451_("RocketBurnTime");
        this.hasFuel = compound.m_128471_("HasFuel");
        this.accelerationX = compound.m_128457_("AccelerationX");
        this.accelerationY = compound.m_128457_("AccelerationY");
        this.accelerationZ = compound.m_128457_("AccelerationZ");
    }

    public boolean isInPropulsionPhase() {
        return this.hasFuel && this.rocketBurnTime > 0;
    }

    public int getRemainingBurnTime() {
        return this.rocketBurnTime;
    }

    public <T extends ParticleOptions> int sendParticlesToAllNearby(ServerLevel serverLevel, T particleOptions, double x, double y, double z, int count, double xOffset, double yOffset, double zOffset, double speed) {
        ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket(particleOptions, true, x, y, z, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, count);
        int sentCount = 0;
        for (ServerPlayer serverPlayer : serverLevel.m_6907_()) {
            if (!this.sendParticlesToPlayer(serverLevel, serverPlayer, x, y, z, (Packet<?>)packet)) continue;
            ++sentCount;
        }
        return sentCount;
    }

    private boolean sendParticlesToPlayer(ServerLevel serverLevel, ServerPlayer serverPlayer, double x, double y, double z, Packet<?> packet) {
        if (serverPlayer.m_9236_() != serverLevel) {
            return false;
        }
        double distanceSquared = serverPlayer.m_20182_().m_82557_(new Vec3(x, y, z));
        if (distanceSquared < 65536.0) {
            serverPlayer.f_8906_.m_9829_(packet);
            return true;
        }
        return false;
    }
}

