/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.siege;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.entity.action.PositionAttackAction;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.puppets.IPuppet;
import ydmsama.hundred_years_war.main.entity.entities.siege.PositionAttackable;
import ydmsama.hundred_years_war.main.entity.entities.siege.UnloadPassengerable;
import ydmsama.hundred_years_war.main.entity.entities.tags.SiegeUnit;
import ydmsama.hundred_years_war.main.entity.goals.BaseCombatEntityAttackGoal;
import ydmsama.hundred_years_war.main.entity.goals.FollowEntityGoal;
import ydmsama.hundred_years_war.main.entity.goals.PatrolGoal;
import ydmsama.hundred_years_war.main.entity.goals.ReturnToHomeGoal;
import ydmsama.hundred_years_war.main.entity.utils.MultiSeatVehicle;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class BatteringRamEntity
extends BaseCombatEntity
implements SiegeUnit,
RangedAttackMob,
PositionAttackable,
MultiSeatVehicle,
UnloadPassengerable {
    private static final float MOVEMENT_SPEED = 0.18f;
    private static final float ATTACK_REACH = 6.0f;
    private static final float MAX_DESTROYABLE_HARDNESS = 50.0f;
    private static final double DESTRUCTION_VALUE_PER_ATTACK = 30.0;
    private static final int MANDATORY_MARGIN = 1;
    private static final int INFLUENCE_MARGIN = 3;
    private static final int EXTRA_HEIGHT_TOP = 2;
    private static final EntityDataAccessor<BlockPos> TARGET_POS = SynchedEntityData.m_135353_(BatteringRamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> HAS_POSITION_TARGET = SynchedEntityData.m_135353_(BatteringRamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private Vec3 positionTarget;
    private PositionAttackAction positionAttackAction;
    private final List<MultiSeatVehicle.Seat> seats = new ArrayList<MultiSeatVehicle.Seat>();
    private final Map<Entity, MultiSeatVehicle.Seat> entitySeatMap = new HashMap<Entity, MultiSeatVehicle.Seat>();
    private static final int MAX_PASSENGERS = 8;
    private Vec3 unloadTarget;
    private static final double MAX_UNLOAD_DISTANCE = 4.0;
    private static final double UNLOAD_HEIGHT_RANGE = 10.0;
    private int unloadInitDelay = 0;
    private int unloadInterval = 0;
    private static final int UNLOAD_INIT_DELAY = 20;
    private static final int UNLOAD_INTERVAL = 15;

    public BatteringRamEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
        this.f_19804_.m_135372_(TARGET_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(HAS_POSITION_TARGET, (Object)false);
        this.positionAttackAction = new PositionAttackAction();
        this.positionTarget = null;
        this.initializeSeats();
    }

    private void initializeSeats() {
        this.seats.clear();
        this.seats.add(new MultiSeatVehicle.Seat(MultiSeatVehicle.SeatType.PLAYER, new Vec3(0.0, 0.5, 0.0), false, MultiSeatVehicle.SeatPose.SITTING));
        this.seats.add(new MultiSeatVehicle.Seat(MultiSeatVehicle.SeatType.INTERNAL, new Vec3(0.0, 0.5, 0.0), true, MultiSeatVehicle.SeatPose.SITTING));
    }

    @Override
    public List<MultiSeatVehicle.Seat> getAllSeats() {
        return new ArrayList<MultiSeatVehicle.Seat>(this.seats);
    }

    @Override
    public int getMaxPassengers() {
        return 8;
    }

    @Override
    public Optional<MultiSeatVehicle.Seat> assignSeat(Entity entity) {
        MultiSeatVehicle.SeatType[] preferredTypes;
        if (this.entitySeatMap.containsKey(entity)) {
            MultiSeatVehicle.Seat currentSeat = this.entitySeatMap.get(entity);
            if (currentSeat.getType() == MultiSeatVehicle.SeatType.INTERNAL && entity instanceof LivingEntity && this.isRangedUnit((LivingEntity)entity)) {
                for (MultiSeatVehicle.Seat seat : this.seats) {
                    if (seat.getType() != MultiSeatVehicle.SeatType.RANGED || !seat.canAccept(entity)) continue;
                    if (!currentSeat.isAllowMultiple()) {
                        currentSeat.setOccupant(null);
                    }
                    if (!seat.isAllowMultiple()) {
                        seat.setOccupant(entity);
                    }
                    this.entitySeatMap.put(entity, seat);
                    return Optional.of(seat);
                }
            }
            return Optional.of(currentSeat);
        }
        for (MultiSeatVehicle.SeatType type : preferredTypes = this.getPreferredSeatTypes(entity)) {
            for (MultiSeatVehicle.Seat seat : this.seats) {
                if (seat.getType() != type || !seat.canAccept(entity)) continue;
                if (!seat.isAllowMultiple()) {
                    seat.setOccupant(entity);
                }
                this.entitySeatMap.put(entity, seat);
                return Optional.of(seat);
            }
        }
        return Optional.empty();
    }

    @Override
    public void releaseSeat(Entity entity) {
        MultiSeatVehicle.Seat seat = this.entitySeatMap.remove(entity);
        if (seat != null && !seat.isAllowMultiple()) {
            seat.setOccupant(null);
        }
    }

    @Override
    public Optional<MultiSeatVehicle.Seat> getSeatForEntity(Entity entity) {
        return Optional.ofNullable(this.entitySeatMap.get(entity));
    }

    @Override
    public int getPassengerCount() {
        return this.m_20197_().size();
    }

    @Override
    public MultiSeatVehicle.SeatType[] getPreferredSeatTypes(Entity entity) {
        if (entity instanceof Player || entity instanceof IPuppet) {
            return new MultiSeatVehicle.SeatType[]{MultiSeatVehicle.SeatType.PLAYER, MultiSeatVehicle.SeatType.INTERNAL};
        }
        if (entity instanceof LivingEntity && this.isRangedUnit((LivingEntity)entity)) {
            return new MultiSeatVehicle.SeatType[]{MultiSeatVehicle.SeatType.RANGED, MultiSeatVehicle.SeatType.INTERNAL};
        }
        return new MultiSeatVehicle.SeatType[]{MultiSeatVehicle.SeatType.INTERNAL};
    }

    public static AttributeSupplier.Builder createBatteringRamAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, (double)0.18f).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22276_, 120.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 6.0);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.hasPositionTarget() && this.getPositionTarget() != null) {
                BlockPos targetBlockPos = new BlockPos((int)this.getPositionTarget().f_82479_, (int)this.getPositionTarget().f_82480_, (int)this.getPositionTarget().f_82481_);
                this.setTargetPosition(targetBlockPos);
                if (this.shouldClearBombardTarget(targetBlockPos)) {
                    this.setPositionTarget(null);
                }
            } else if (this.getHywTarget() != null) {
                this.setTargetPosition(this.getHywTarget().m_20183_());
            } else {
                this.setTargetPosition(BlockPos.f_121853_);
            }
            this.handleUnloadLogic();
        }
    }

    private boolean shouldClearBombardTarget(BlockPos targetPos) {
        int maxY;
        if (targetPos == null || targetPos.equals((Object)BlockPos.f_121853_)) {
            return false;
        }
        double centerX = (double)targetPos.m_123341_() + 0.5;
        double centerZ = (double)targetPos.m_123343_() + 0.5;
        double entityBottomY = this.m_20191_().f_82289_;
        double halfWidth = (double)this.m_20205_() / 2.0 + 1.0;
        int minX = Mth.m_14107_((double)(centerX - halfWidth));
        int maxX = Mth.m_14107_((double)(centerX + halfWidth));
        int minZ = Mth.m_14107_((double)(centerZ - halfWidth));
        int maxZ = Mth.m_14107_((double)(centerZ + halfWidth));
        int minY = Mth.m_14107_((double)entityBottomY);
        return !this.hasDestructibleInBounds(minX, maxX, minY, maxY = Mth.m_14107_((double)(entityBottomY + (double)this.m_20206_() + 2.0)), minZ, maxZ);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FollowEntityGoal(this, 1.0, 5.0, 20.0, 25.0, 50.0));
        this.f_21345_.m_25352_(2, (Goal)new BaseCombatEntityAttackGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new PatrolGoal(this, 1.0, 40));
        this.f_21345_.m_25352_(3, (Goal)new FollowEntityGoal(this, 1.0, 5.0, 5.0, Double.MAX_VALUE, 0.0));
        this.f_21345_.m_25352_(4, (Goal)new ReturnToHomeGoal(this, 1.0));
        super.addTargetSelector();
    }

    @Override
    public boolean isValidTarget(LivingEntity potentialTarget) {
        return false;
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 25;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 22;
    }

    @Override
    public int getAttackCoolDownDuration() {
        return 50;
    }

    @Override
    public float getRotationLimit() {
        return 1.5f;
    }

    @Override
    protected void increaseStatsOnLevelUp() {
    }

    @Override
    public double getDesiredDistance() {
        return 3.0;
    }

    @Override
    public double getArrivalThreshold() {
        return 2.0;
    }

    public void m_6504_(LivingEntity target, float pullProgress) {
        this.PerformRangedAttackBoth(null, target);
    }

    @Override
    public void performPositionAttack(Vec3 targetPosition, float pullProgress) {
        this.PerformRangedAttackBoth(targetPosition, null);
    }

    @Override
    public boolean canFireAtPosition(Vec3 targetPosition) {
        return targetPosition != null;
    }

    @Override
    public boolean hasPositionTarget() {
        return (Boolean)this.f_19804_.m_135370_(HAS_POSITION_TARGET);
    }

    @Override
    public Vec3 getPositionTarget() {
        return this.positionTarget;
    }

    @Override
    public void setPositionTarget(Vec3 targetPosition) {
        this.positionTarget = targetPosition;
        this.f_19804_.m_135381_(HAS_POSITION_TARGET, (Object)(targetPosition != null ? 1 : 0));
        if (targetPosition != null) {
            if (this.unloadTarget != null) {
                this.unloadTarget = null;
                this.resetUnloadState();
            }
            this.setTargetPosition(BlockPos.m_274446_((Position)targetPosition));
        } else {
            this.setTargetPosition(BlockPos.f_121853_);
        }
    }

    @Override
    public void PerformRangedAttackBoth(Vec3 targetPosition, LivingEntity target) {
        if (targetPosition == null && target != null) {
            targetPosition = new Vec3(target.m_20185_(), target.m_20186_(), target.m_20189_());
        }
        if (targetPosition == null) {
            return;
        }
        if (!this.canFireAtPosition(targetPosition)) {
            return;
        }
        this.performBlockDestructionAttack(targetPosition);
    }

    public void setTargetPosition(BlockPos pos) {
        this.f_19804_.m_135381_(TARGET_POS, (Object)pos);
    }

    private void performBlockDestructionAttack(Vec3 targetPosition) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        double centerX = targetPosition.f_82479_;
        double centerZ = targetPosition.f_82481_;
        double entityBottomY = this.m_20191_().f_82289_;
        double halfWidth = (double)this.m_20205_() / 2.0 + 1.0;
        int minX = Mth.m_14107_((double)(centerX - halfWidth));
        int maxX = Mth.m_14107_((double)(centerX + halfWidth));
        int minZ = Mth.m_14107_((double)(centerZ - halfWidth));
        int maxZ = Mth.m_14107_((double)(centerZ + halfWidth));
        int minY = Mth.m_14107_((double)entityBottomY);
        int maxY = Mth.m_14107_((double)(entityBottomY + (double)this.m_20206_() + 2.0));
        double influenceHalfWidth = halfWidth + 3.0;
        int influenceMinX = Mth.m_14107_((double)(centerX - influenceHalfWidth));
        int influenceMaxX = Mth.m_14107_((double)(centerX + influenceHalfWidth));
        int influenceMinZ = Mth.m_14107_((double)(centerZ - influenceHalfWidth));
        int influenceMaxZ = Mth.m_14107_((double)(centerZ + influenceHalfWidth));
        int influenceMaxY = maxY + 3;
        List<BlockPos> mandatoryBlocks = this.collectDestructibleBlocks(minX, maxX, minY, maxY, minZ, maxZ);
        if (mandatoryBlocks.isEmpty()) {
            this.setPositionTarget(null);
            return;
        }
        HashSet<BlockPos> mandatorySet = new HashSet<BlockPos>(mandatoryBlocks);
        HashSet<BlockPos> influenceBlocks = new HashSet<BlockPos>(this.collectDestructibleBlocks(influenceMinX, influenceMaxX, minY, influenceMaxY, influenceMinZ, influenceMaxZ));
        influenceBlocks.removeIf(pos -> this.isWithinBounds((BlockPos)pos, minX, maxX, minY, maxY, minZ, maxZ));
        Set<BlockPos> connectedInfluence = this.getConnectedInfluenceBlocks(mandatorySet, influenceBlocks, influenceMinX, influenceMaxX, minY, influenceMaxY, influenceMinZ, influenceMaxZ);
        RandomSource random = this.m_217043_();
        List<BlockPos> toBreakMandatory = this.selectBlocksByBudget(mandatoryBlocks, 30.0, random);
        this.destroyBlocks(toBreakMandatory);
        if (!connectedInfluence.isEmpty()) {
            List<BlockPos> toBreakInfluence = this.selectBlocksByBudget(new ArrayList<BlockPos>(connectedInfluence), 15.0, random);
            this.destroyBlocks(toBreakInfluence);
        }
        if (!this.hasDestructibleInBounds(minX, maxX, minY, maxY, minZ, maxZ)) {
            this.setPositionTarget(null);
        }
    }

    private List<BlockPos> collectDestructibleBlocks(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!this.isDestructible(pos)) continue;
                    result.add(pos);
                }
            }
        }
        return result;
    }

    private boolean isDestructible(BlockPos pos) {
        BlockState state = this.m_9236_().m_8055_(pos);
        if (state.m_60795_()) {
            return false;
        }
        float hardness = state.m_60800_((BlockGetter)this.m_9236_(), pos);
        return hardness >= 0.0f && hardness <= 50.0f;
    }

    private boolean isWithinBounds(BlockPos pos, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        return pos.m_123341_() >= minX && pos.m_123341_() <= maxX && pos.m_123342_() >= minY && pos.m_123342_() <= maxY && pos.m_123343_() >= minZ && pos.m_123343_() <= maxZ;
    }

    private Set<BlockPos> getConnectedInfluenceBlocks(Set<BlockPos> mandatoryBlocks, Set<BlockPos> influenceBlocks, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        HashSet<BlockPos> connected = new HashSet<BlockPos>(mandatoryBlocks);
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>(mandatoryBlocks);
        while (!queue.isEmpty()) {
            BlockPos current = queue.poll();
            for (Direction direction : Direction.values()) {
                BlockPos next = current.m_121945_(direction);
                if (!this.isWithinBounds(next, minX, maxX, minY, maxY, minZ, maxZ) || !influenceBlocks.contains(next) || connected.contains(next)) continue;
                connected.add(next);
                queue.add(next);
            }
        }
        connected.removeAll(mandatoryBlocks);
        return connected;
    }

    private double getBlockDestructionCost(BlockPos pos) {
        BlockState state = this.m_9236_().m_8055_(pos);
        float hardness = state.m_60800_((BlockGetter)this.m_9236_(), pos);
        if (hardness < 0.0f || hardness > 50.0f) {
            return Double.MAX_VALUE;
        }
        double coefficient = 1.0;
        if (state.m_204336_(BlockTags.f_144282_)) {
            coefficient = 3.0;
        } else if (state.m_204336_(BlockTags.f_144283_)) {
            coefficient = 0.5;
        } else if (state.m_204336_(BlockTags.f_144280_)) {
            coefficient = 1.5;
        }
        return (double)hardness * coefficient;
    }

    private List<BlockPos> selectBlocksByBudget(List<BlockPos> candidates, double budget, RandomSource random) {
        BlockPos pos;
        double cost;
        ArrayList<BlockPos> shuffled = new ArrayList<BlockPos>(candidates);
        Collections.shuffle(shuffled, new Random(random.m_188505_()));
        ArrayList<BlockPos> selected = new ArrayList<BlockPos>();
        double remaining = budget;
        Iterator iterator = shuffled.iterator();
        while (iterator.hasNext() && !((cost = this.getBlockDestructionCost(pos = (BlockPos)iterator.next())) > remaining)) {
            selected.add(pos);
            if (!((remaining -= cost) <= 0.0)) continue;
            break;
        }
        return selected;
    }

    private void destroyBlocks(Collection<BlockPos> positions) {
        for (BlockPos pos : positions) {
            this.m_9236_().m_46961_(pos, true);
        }
    }

    private boolean hasDestructibleInBounds(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!this.isDestructible(new BlockPos(x, y, z))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void handleUnloadLogic() {
        if (!this.hasUnloadTarget()) {
            this.resetUnloadState();
            return;
        }
        Vec3 target = this.getUnloadTarget();
        if (!this.canUnloadAtPosition(target)) {
            this.resetUnloadState();
            return;
        }
        if (this.unloadInitDelay > 0) {
            --this.unloadInitDelay;
            return;
        }
        if (this.unloadInterval > 0) {
            --this.unloadInterval;
            return;
        }
        this.unloadInterval = !this.executeUnload(target) ? 15 : 15;
    }

    private void resetUnloadState() {
        this.unloadInitDelay = 0;
        this.unloadInterval = 0;
    }

    private boolean executeUnload(Vec3 target) {
        ArrayList passengers = new ArrayList(this.m_20197_());
        if (passengers.isEmpty()) {
            return true;
        }
        passengers.sort((e1, e2) -> Integer.compare(this.getUnloadPriority((Entity)e1), this.getUnloadPriority((Entity)e2)));
        Entity passenger = (Entity)passengers.get(0);
        Vec3 unloadPos = this.findAvailableUnloadPosition(target);
        if (unloadPos == null) {
            return false;
        }
        passenger.m_8127_();
        double offsetX = (this.m_217043_().m_188500_() - 0.5) * 0.8;
        double offsetZ = (this.m_217043_().m_188500_() - 0.5) * 0.8;
        double finalX = unloadPos.f_82479_ + offsetX;
        double finalZ = unloadPos.f_82481_ + offsetZ;
        passenger.m_6021_(finalX, unloadPos.f_82480_, finalZ);
        if (passenger instanceof BaseCombatEntity) {
            BaseCombatEntity combatEntity = (BaseCombatEntity)passenger;
            combatEntity.setHomePosition(BlockPos.m_274561_((double)finalX, (double)unloadPos.f_82480_, (double)finalZ));
            combatEntity.setHomeReturnRadius(999.0);
            combatEntity.setShouldRender(false);
        }
        return true;
    }

    private int getUnloadPriority(Entity entity) {
        Optional<MultiSeatVehicle.Seat> seatOpt = this.getSeatForEntity(entity);
        if (seatOpt.isPresent()) {
            switch (seatOpt.get().getType()) {
                case INTERNAL: {
                    return 0;
                }
                case RANGED: {
                    return 1;
                }
                case PLAYER: {
                    return 2;
                }
            }
        }
        return 3;
    }

    private Vec3 findAvailableUnloadPosition(Vec3 targetPos) {
        for (int y = 0; y <= 3; ++y) {
            Vec3 checkPos = new Vec3(targetPos.f_82479_, targetPos.f_82480_ + (double)y + 1.0, targetPos.f_82481_);
            if (!this.isValidUnloadPosition(checkPos)) continue;
            return checkPos;
        }
        return null;
    }

    private boolean isValidUnloadPosition(Vec3 pos) {
        BlockPos blockPos = new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_);
        return this.m_9236_().m_46859_(blockPos) && this.m_9236_().m_46859_(blockPos.m_7494_());
    }

    protected boolean m_7310_(Entity entity) {
        return this.canEntityMount(entity);
    }

    protected void m_20348_(Entity entity) {
        super.m_20348_(entity);
        this.assignSeat(entity);
        if (!this.m_9236_().f_46443_) {
            this.optimizeSeatAssignments();
        }
        if (!this.m_9236_().f_46443_ && entity instanceof BaseCombatEntity) {
            BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
            combatEntity.setFollowTarget(null);
            ServerPacketHandler.sendClearFollowTargetToAll(entity.m_20148_());
            ServerPacketHandler.sendClearSelectionToAll(entity.m_20148_());
        }
    }

    protected void m_20351_(Entity entity) {
        this.unloadPassengerToGround(entity);
        super.m_20351_(entity);
        this.releaseSeat(entity);
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        Optional<MultiSeatVehicle.Seat> seatOpt = this.getSeatForEntity(passenger);
        if (seatOpt.isPresent()) {
            BaseCombatEntity combatEntity;
            MultiSeatVehicle.Seat seat = seatOpt.get();
            Vec3 seatPos = seat.getPosition();
            float yBodyRot = this.getTrueYBodyRot() + 90.0f;
            float yBodyRotRad = (float)Math.toRadians(yBodyRot);
            double forwardX = Math.cos(yBodyRotRad);
            double forwardZ = Math.sin(yBodyRotRad);
            double rightX = Math.cos((double)yBodyRotRad + 1.5707963267948966);
            double rightZ = Math.sin((double)yBodyRotRad + 1.5707963267948966);
            double offsetX = forwardX * seatPos.f_82481_ + rightX * seatPos.f_82479_;
            double offsetZ = forwardZ * seatPos.f_82481_ + rightZ * seatPos.f_82479_;
            moveFunction.m_20372_(passenger, this.m_20185_() + offsetX, this.m_20186_() + seatPos.f_82480_, this.m_20189_() + offsetZ);
            if (passenger instanceof BaseCombatEntity && !(combatEntity = (BaseCombatEntity)passenger).getHasTarget()) {
                passenger.m_5616_(this.getTrueYBodyRot());
            }
        } else {
            super.m_19956_(passenger, moveFunction);
        }
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.m_9236_().f_46443_ && this.canEntityMount((Entity)player)) {
            player.m_20329_((Entity)this);
        }
        return super.m_6071_(player, hand);
    }

    public MultiSeatVehicle.SeatPose getEntitySeatPose(Entity entity) {
        return this.getSeatForEntity(entity).map(MultiSeatVehicle.Seat::getPose).orElse(MultiSeatVehicle.SeatPose.SITTING);
    }

    private void optimizeSeatAssignments() {
        ArrayList passengers = new ArrayList(this.m_20197_());
        ArrayList<Entity> rangedUnits = new ArrayList<Entity>();
        ArrayList<Entity> otherUnits = new ArrayList<Entity>();
        for (Entity passenger : passengers) {
            if (passenger instanceof LivingEntity && this.isRangedUnit((LivingEntity)passenger)) {
                rangedUnits.add(passenger);
                continue;
            }
            otherUnits.add(passenger);
        }
        this.entitySeatMap.clear();
        for (MultiSeatVehicle.Seat seat : this.seats) {
            if (seat.isAllowMultiple()) continue;
            seat.setOccupant(null);
        }
        block2: for (Entity rangedUnit : rangedUnits) {
            boolean assigned = false;
            for (MultiSeatVehicle.Seat seat : this.seats) {
                if (seat.getType() != MultiSeatVehicle.SeatType.RANGED || !seat.canAccept(rangedUnit)) continue;
                if (!seat.isAllowMultiple()) {
                    seat.setOccupant(rangedUnit);
                }
                this.entitySeatMap.put(rangedUnit, seat);
                assigned = true;
                break;
            }
            if (assigned) continue;
            for (MultiSeatVehicle.Seat seat : this.seats) {
                if (seat.getType() != MultiSeatVehicle.SeatType.INTERNAL || !seat.canAccept(rangedUnit)) continue;
                this.entitySeatMap.put(rangedUnit, seat);
                continue block2;
            }
        }
        for (Entity otherUnit : otherUnits) {
            this.assignSeat(otherUnit);
        }
    }

    public LivingEntity m_6688_() {
        return null;
    }

    @Override
    public boolean canUnloadAtPosition(Vec3 targetPosition) {
        if (targetPosition == null) {
            return false;
        }
        double horizontalDistance = Math.sqrt(Math.pow(targetPosition.f_82479_ - this.m_20185_(), 2.0) + Math.pow(targetPosition.f_82481_ - this.m_20189_(), 2.0));
        if (horizontalDistance > this.getMaxUnloadDistance()) {
            return false;
        }
        double heightDiff = targetPosition.f_82480_ - this.m_20186_();
        return heightDiff >= -0.5 * this.getUnloadHeightRange() && heightDiff <= this.getUnloadHeightRange();
    }

    @Override
    public boolean hasUnloadTarget() {
        return this.unloadTarget != null;
    }

    @Override
    public Vec3 getUnloadTarget() {
        return this.unloadTarget;
    }

    @Override
    public void setUnloadTarget(Vec3 targetPosition) {
        this.unloadTarget = targetPosition;
        if (targetPosition != null) {
            if (this.hasPositionTarget()) {
                this.setPositionTarget(null);
            }
            this.resetUnloadState();
            this.unloadInitDelay = 20;
        }
    }

    @Override
    public double getMaxUnloadDistance() {
        return 4.0;
    }

    @Override
    public double getUnloadHeightRange() {
        return 10.0;
    }

    @Override
    public void unloadPassengerToGround(Entity passenger) {
        if (this.m_9236_().f_46443_ || passenger == null) {
            return;
        }
        Random random = new Random();
        double maxDistance = this.getMaxUnloadDistance();
        double angle = random.nextDouble() * 2.0 * Math.PI;
        double distance = random.nextDouble() * maxDistance;
        double offsetX = Math.cos(angle) * distance;
        double offsetZ = Math.sin(angle) * distance;
        double targetX = this.m_20185_() + offsetX;
        double targetZ = this.m_20189_() + offsetZ;
        BlockPos groundPos = new BlockPos((int)targetX, (int)this.m_20186_(), (int)targetZ);
        double groundY = this.findGroundLevel(groundPos);
        passenger.m_8127_();
        passenger.m_6021_(targetX, groundY, targetZ);
        if (passenger instanceof BaseCombatEntity) {
            BaseCombatEntity combatEntity = (BaseCombatEntity)passenger;
            combatEntity.setHomePosition(BlockPos.m_274561_((double)targetX, (double)groundY, (double)targetZ));
            combatEntity.setHomeReturnRadius(999.0);
            combatEntity.setShouldRender(false);
        }
    }

    private double findGroundLevel(BlockPos startPos) {
        for (int y = startPos.m_123342_(); y >= startPos.m_123342_() - 10; --y) {
            BlockPos checkPos = new BlockPos(startPos.m_123341_(), y, startPos.m_123343_());
            if (this.m_9236_().m_46859_(checkPos)) continue;
            BlockPos abovePos = checkPos.m_7494_();
            if (!this.m_9236_().m_46859_(abovePos) || !this.m_9236_().m_46859_(abovePos.m_7494_())) continue;
            return abovePos.m_123342_();
        }
        return startPos.m_123342_();
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("HasPositionTarget", this.hasPositionTarget());
        if (this.hasPositionTarget() && this.positionTarget != null) {
            compound.m_128347_("PositionTargetX", this.positionTarget.f_82479_);
            compound.m_128347_("PositionTargetY", this.positionTarget.f_82480_);
            compound.m_128347_("PositionTargetZ", this.positionTarget.f_82481_);
        }
        compound.m_128379_("HasUnloadTarget", this.hasUnloadTarget());
        if (this.hasUnloadTarget() && this.unloadTarget != null) {
            compound.m_128347_("UnloadTargetX", this.unloadTarget.f_82479_);
            compound.m_128347_("UnloadTargetY", this.unloadTarget.f_82480_);
            compound.m_128347_("UnloadTargetZ", this.unloadTarget.f_82481_);
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        double z;
        double y;
        double x;
        super.m_7378_(compound);
        if (compound.m_128471_("HasPositionTarget")) {
            x = compound.m_128459_("PositionTargetX");
            y = compound.m_128459_("PositionTargetY");
            z = compound.m_128459_("PositionTargetZ");
            this.setPositionTarget(new Vec3(x, y, z));
        } else {
            this.setPositionTarget(null);
        }
        if (compound.m_128471_("HasUnloadTarget")) {
            x = compound.m_128459_("UnloadTargetX");
            y = compound.m_128459_("UnloadTargetY");
            z = compound.m_128459_("UnloadTargetZ");
            this.setUnloadTarget(new Vec3(x, y, z));
        } else {
            this.setUnloadTarget(null);
        }
    }

    @Override
    public Item getScrollType() {
        return (Item)HywItemRegistry.BATTERING_RAM.get();
    }

    @Override
    public void m_6667_(DamageSource damageSource) {
        ArrayList passengers = new ArrayList(this.m_20197_());
        for (Entity passenger : passengers) {
            this.unloadPassengerToGround(passenger);
        }
        super.m_6667_(damageSource);
    }

    @Override
    public boolean canFireAtTarget(LivingEntity target) {
        return false;
    }
}

