/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.siege;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.projectile.BulletEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.SiegeUnit;
import ydmsama.hundred_years_war.main.entity.goals.BaseCombatEntityAttackGoal;
import ydmsama.hundred_years_war.main.entity.goals.FollowEntityGoal;
import ydmsama.hundred_years_war.main.entity.goals.PatrolGoal;
import ydmsama.hundred_years_war.main.entity.goals.ReturnToHomeGoal;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class RibauldequinEntity
extends BaseCombatEntity
implements RangedAttackMob,
SiegeUnit {
    private static final float ATTACK_REACH = 64.0f;
    private static final float MOVEMENT_SPEED = 0.22f;
    private static final float BASE_RANGED_ATTACK_DAMAGE = 15.0f;
    private float leftWheelRotation;
    private float rightWheelRotation;
    private static final EntityDataAccessor<BlockPos> TARGET_POS = SynchedEntityData.m_135353_(RibauldequinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private int currentBarrelIndex = 0;
    private int shotDelay = 0;
    private LivingEntity currentTarget = null;
    private Vec3 lastTargetPos = null;
    private static final int BARREL_COUNT = 5;
    private static final int SHOT_DELAY_TICKS = 3;
    private static final float[] BARREL_ANGLE_OFFSETS = new float[]{-12.5f, -7.5f, 0.0f, 7.5f, 12.5f};
    private boolean inFiringSequence = false;
    private int attackCooldown = 0;

    public RibauldequinEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
        this.f_19804_.m_135372_(TARGET_POS, (Object)BlockPos.f_121853_);
    }

    public static AttributeSupplier.Builder createRibauldequinAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22279_, (double)0.22f).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 64.0).m_22268_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get(), 15.0);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.attackCooldown > 0) {
                --this.attackCooldown;
            }
            if (this.getHywTarget() != null) {
                this.setTargetPosition(this.getHywTarget().m_20183_());
            } else {
                this.setTargetPosition(BlockPos.f_121853_);
            }
            if (this.inFiringSequence && this.shotDelay > 0) {
                --this.shotDelay;
                if (this.shotDelay == 0 && this.currentBarrelIndex < 5) {
                    this.fireSingleBarrel(this.currentBarrelIndex);
                    ++this.currentBarrelIndex;
                    if (this.currentBarrelIndex < 5) {
                        this.shotDelay = 3;
                    } else {
                        this.inFiringSequence = false;
                        this.resetFiringSequence();
                        this.attackCooldown = this.getAttackCoolDownDuration();
                    }
                }
            }
        }
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 15;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 5;
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return 120 + random.nextInt(30);
    }

    @Override
    public float getRotationLimit() {
        return 2.5f;
    }

    @Override
    protected void increaseStatsOnLevelUp() {
    }

    @Override
    public double getDesiredDistance() {
        return 2.5;
    }

    public void m_6504_(LivingEntity target, float pullProgress) {
        if (this.attackCooldown > 0 || this.inFiringSequence) {
            return;
        }
        if (!this.canFireAtTarget(target)) {
            return;
        }
        this.currentTarget = target;
        this.lastTargetPos = target.m_20182_();
        this.currentBarrelIndex = 0;
        this.inFiringSequence = true;
        this.fireSingleBarrel(this.currentBarrelIndex);
        ++this.currentBarrelIndex;
        this.shotDelay = 3;
    }

    private void fireSingleBarrel(int barrelIndex) {
        Vec3 targetPosition;
        BarrelPosition barrelPosition = this.calculateBarrelPosition(barrelIndex);
        BulletEntity bullet = new BulletEntity((EntityType<? extends BulletEntity>)((EntityType)HywEntityRegistry.BULLET.get()), (LivingEntity)this, this.m_9236_());
        bullet.m_36781_(this.m_21133_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get()));
        bullet.m_36767_((byte)1);
        bullet.m_6034_(barrelPosition.position.f_82479_, barrelPosition.position.f_82480_, barrelPosition.position.f_82481_);
        if (this.currentTarget != null && this.currentTarget.m_6084_()) {
            this.lastTargetPos = targetPosition = this.currentTarget.m_20182_();
        } else if (this.lastTargetPos != null) {
            targetPosition = this.lastTargetPos;
        } else {
            float yaw = this.getTrueYBodyRot() + 90.0f;
            float yawRad = (float)Math.toRadians(yaw);
            targetPosition = new Vec3(this.m_20185_() + Math.cos(yawRad) * 30.0, this.m_20186_() + 1.0, this.m_20189_() + Math.sin(yawRad) * 30.0);
        }
        double dx = targetPosition.f_82479_ - bullet.m_20185_();
        double dz = targetPosition.f_82481_ - bullet.m_20189_();
        double dy = targetPosition.f_82480_ + 0.5 - bullet.m_20186_();
        double distance = Math.sqrt(dx * dx + dz * dz + dy * dy);
        if (distance == 0.0) {
            return;
        }
        float speed = 5.0f;
        double gravity = 0.05;
        double angle = Double.NaN;
        float miss = 1.0f;
        double[] angles = this.calculateLaunchAngles(speed, gravity, distance, dy);
        angle = angles[1];
        if (Double.isNaN(angle)) {
            return;
        }
        double randomSpeedOffset = RibauldequinEntity.getRandomInRange(-0.25, 0.75);
        double timeToTarget = distance / (((double)speed - randomSpeedOffset) * Math.cos(angle));
        double targetVelocityX = 0.0;
        double targetVelocityZ = 0.0;
        if (this.currentTarget != null && this.currentTarget.m_6084_()) {
            targetVelocityX = this.currentTarget.m_20184_().m_7096_();
            targetVelocityZ = this.currentTarget.m_20184_().m_7094_();
        }
        double predictedX = targetPosition.f_82479_ + targetVelocityX * timeToTarget;
        double predictedZ = targetPosition.f_82481_ + targetVelocityZ * timeToTarget;
        double predictedDistance = Math.sqrt((predictedX - bullet.m_20185_()) * (predictedX - bullet.m_20185_()) + (predictedZ - bullet.m_20189_()) * (predictedZ - bullet.m_20189_()));
        angles = this.calculateLaunchAngles(speed, gravity, predictedDistance, dy);
        if (Double.isNaN(angles[0]) && Double.isNaN(angles[1])) {
            return;
        }
        angle = angles[1];
        dx = predictedX - bullet.m_20185_();
        double horizontalDistance = Math.sqrt(dx * dx + (dz = predictedZ - bullet.m_20189_()) * dz);
        if (horizontalDistance == 0.0) {
            return;
        }
        double horizontalSpeed = (double)speed * Math.cos(angle);
        double verticalSpeed = (double)speed * Math.sin(angle);
        float angleOffset = BARREL_ANGLE_OFFSETS[barrelIndex];
        float angleOffsetRad = (float)Math.toRadians(angleOffset);
        float velocityX = (float)(dx / horizontalDistance * horizontalSpeed);
        float velocityZ = (float)(dz / horizontalDistance * horizontalSpeed);
        float originalDir = (float)Mth.m_14136_((double)velocityZ, (double)velocityX);
        float newDir = originalDir + angleOffsetRad;
        float newVelocityX = (float)(Math.cos(newDir) * horizontalSpeed);
        float newVelocityZ = (float)(Math.sin(newDir) * horizontalSpeed);
        bullet.m_6686_(newVelocityX, (float)verticalSpeed, newVelocityZ, speed, miss);
        float randomPitch = 1.4f + (float)RibauldequinEntity.getRandomInRange(0.0, 0.4);
        this.m_5496_(SoundEvents.f_11913_, 5.0f, randomPitch);
        this.m_9236_().m_7967_((Entity)bullet);
        this.spawnParticles(this.m_9236_(), bullet.m_20185_(), bullet.m_20186_(), bullet.m_20189_());
    }

    private BarrelPosition calculateBarrelPosition(int barrelIndex) {
        float yBodyRot = this.getTrueYBodyRot() + 90.0f;
        float yBodyRotRad = (float)Math.toRadians(yBodyRot);
        double forwardX = Math.cos(yBodyRotRad);
        double forwardZ = Math.sin(yBodyRotRad);
        double rightX = Math.cos((double)yBodyRotRad + 1.5707963267948966);
        double rightZ = Math.sin((double)yBodyRotRad + 1.5707963267948966);
        double lateralOffset = 0.0;
        double longitudinalOffset = 0.0;
        switch (barrelIndex) {
            case 0: {
                lateralOffset = -1.0;
                longitudinalOffset = -0.2;
                break;
            }
            case 1: {
                lateralOffset = -0.5;
                longitudinalOffset = -0.1;
                break;
            }
            case 2: {
                lateralOffset = 0.0;
                longitudinalOffset = 0.0;
                break;
            }
            case 3: {
                lateralOffset = 0.5;
                longitudinalOffset = -0.1;
                break;
            }
            case 4: {
                lateralOffset = 1.0;
                longitudinalOffset = -0.2;
            }
        }
        double offsetX = forwardX * (2.0 + longitudinalOffset) + rightX * lateralOffset;
        double offsetZ = forwardZ * (2.0 + longitudinalOffset) + rightZ * lateralOffset;
        Vec3 position = new Vec3(this.m_20185_() + offsetX, this.m_20186_() + 1.1, this.m_20189_() + offsetZ);
        return new BarrelPosition(position, BARREL_ANGLE_OFFSETS[barrelIndex]);
    }

    private void resetFiringSequence() {
        this.currentBarrelIndex = 0;
        this.shotDelay = 0;
        this.currentTarget = null;
        this.m_5810_();
    }

    @Override
    public boolean canFireAtTarget(LivingEntity target) {
        if (target == null) {
            return true;
        }
        if (this.isObstructed(target)) {
            return false;
        }
        float allowedRotationDifference = 15.0f;
        double dx = target.m_20185_() - this.m_20185_();
        double dz = target.m_20189_() - this.m_20189_();
        float actualTargetRot = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        float actualRotDifference = Mth.m_14177_((float)(actualTargetRot - this.currentRot));
        float rotationDifference = Mth.m_14177_((float)(this.targetRot - this.currentRot));
        return Math.abs(rotationDifference) <= allowedRotationDifference && Math.abs(actualRotDifference) <= allowedRotationDifference;
    }

    private boolean isPathClear(AbstractArrow arrow, double angle, float speed, double dx, double dy, double dz, double distance, LivingEntity target) {
        Vec3 startPos = this.m_146892_();
        Vec3 direction = new Vec3(dx / distance, Math.tan(angle), dz / distance).m_82541_();
        Vec3 endPos = startPos.m_82549_(direction.m_82490_(5.0));
        BlockHitResult hitResult = this.m_9236_().m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)arrow));
        return hitResult.m_6662_() == HitResult.Type.MISS;
    }

    private double[] calculateLaunchAngles(double speed, double gravity, double distance, double heightDifference) {
        double discriminant = speed * speed * speed * speed - gravity * (gravity * distance * distance + 2.0 * heightDifference * speed * speed);
        if (discriminant < 0.0) {
            return new double[]{Double.NaN, Double.NaN};
        }
        double angle1 = Math.atan2(speed * speed + Math.sqrt(discriminant), gravity * distance);
        double angle2 = Math.atan2(speed * speed - Math.sqrt(discriminant), gravity * distance);
        return new double[]{angle1, angle2};
    }

    public static double getRandomInRange(double min, double max) {
        return min + Math.random() * (max - min);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FollowEntityGoal(this, 1.0, 5.0, 20.0, 25.0, 50.0));
        this.f_21345_.m_25352_(2, (Goal)new BaseCombatEntityAttackGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new PatrolGoal(this, 1.0, 40));
        this.f_21345_.m_25352_(3, (Goal)new FollowEntityGoal(this, 1.0, 5.0, 5.0, Double.MAX_VALUE, 0.0));
        this.f_21345_.m_25352_(4, (Goal)new ReturnToHomeGoal(this, 1.0));
        super.addTargetSelector();
    }

    @Override
    public boolean isValidTarget(LivingEntity potentialTarget) {
        if (this.isObstructed(potentialTarget)) {
            return false;
        }
        double minimumAttackDistance = 5.0;
        double allowedVerticalDistance = 30.0;
        double distanceToTarget = this.m_20275_(potentialTarget.m_20185_(), potentialTarget.m_20186_(), potentialTarget.m_20189_());
        if (distanceToTarget < minimumAttackDistance * minimumAttackDistance) {
            return false;
        }
        double verticalDistance = Math.abs(potentialTarget.m_20186_() - this.m_20186_());
        if (verticalDistance > allowedVerticalDistance) {
            return false;
        }
        return super.isValidTarget(potentialTarget);
    }

    public void setTargetPosition(BlockPos pos) {
        this.f_19804_.m_135381_(TARGET_POS, (Object)pos);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("AttackCooldown", this.attackCooldown);
        compound.m_128379_("InFiringSequence", this.inFiringSequence);
        if (this.lastTargetPos != null) {
            compound.m_128347_("LastTargetPosX", this.lastTargetPos.f_82479_);
            compound.m_128347_("LastTargetPosY", this.lastTargetPos.f_82480_);
            compound.m_128347_("LastTargetPosZ", this.lastTargetPos.f_82481_);
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.attackCooldown = compound.m_128451_("AttackCooldown");
        this.inFiringSequence = compound.m_128471_("InFiringSequence");
        if (compound.m_128441_("LastTargetPosX")) {
            double x = compound.m_128459_("LastTargetPosX");
            double y = compound.m_128459_("LastTargetPosY");
            double z = compound.m_128459_("LastTargetPosZ");
            this.lastTargetPos = new Vec3(x, y, z);
        }
    }

    private void spawnParticles(Level world, double x, double y, double z) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            this.sendParticlesToAllNearby(serverLevel, ParticleTypes.f_123762_, x, y, z, 20, 0.1, 0.1, 0.1, 0.02);
            this.sendParticlesToAllNearby(serverLevel, ParticleTypes.f_123744_, x, y, z, 5, 0.1, 0.1, 0.1, 0.2);
        }
    }

    public <T extends ParticleOptions> int sendParticlesToAllNearby(ServerLevel serverLevel, T particleOptions, double x, double y, double z, int count, double xOffset, double yOffset, double zOffset, double speed) {
        ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket(particleOptions, true, x, y, z, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, count);
        int sentCount = 0;
        for (ServerPlayer serverPlayer : serverLevel.m_6907_()) {
            if (!this.sendParticlesToPlayer(serverLevel, serverPlayer, x, y, z, (Packet<?>)packet)) continue;
            ++sentCount;
        }
        return sentCount;
    }

    private boolean sendParticlesToPlayer(ServerLevel serverLevel, ServerPlayer serverPlayer, double x, double y, double z, Packet<?> packet) {
        if (serverPlayer.m_9236_() != serverLevel) {
            return false;
        }
        double distanceSquared = serverPlayer.m_20182_().m_82557_(new Vec3(x, y, z));
        if (distanceSquared < 262144.0) {
            serverPlayer.f_8906_.m_9829_(packet);
            return true;
        }
        return false;
    }

    public float getLeftWheelRotation() {
        return this.leftWheelRotation;
    }

    public void setLeftWheelRotation(float leftWheelRotation) {
        this.leftWheelRotation = leftWheelRotation;
    }

    public float getRightWheelRotation() {
        return this.rightWheelRotation;
    }

    public void setRightWheelRotation(float rightWheelRotation) {
        this.rightWheelRotation = rightWheelRotation;
    }

    @Override
    public Item getScrollType() {
        return (Item)HywItemRegistry.RIBAULDEQUIN.get();
    }

    @Override
    public double getArrivalThreshold() {
        return 2.0;
    }

    private static class BarrelPosition {
        public final Vec3 position;
        public final float angleOffset;

        public BarrelPosition(Vec3 position, float angleOffset) {
            this.position = position;
            this.angleOffset = angleOffset;
        }
    }
}

