/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.goals;

import java.util.EnumSet;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.bandits.BanditExecutionerEntity;
import ydmsama.hundred_years_war.main.entity.entities.siege.PositionAttackable;
import ydmsama.hundred_years_war.main.entity.goals.MoveGoal;
import ydmsama.hundred_years_war.main.entity.utils.MeleeCapableRangedAttacker;

public class BaseCombatEntityAttackGoal
extends Goal {
    protected final BaseCombatEntity mob;
    private final double speedTowardsTarget;

    public BaseCombatEntityAttackGoal(BaseCombatEntity mob, double speed) {
        this.mob = mob;
        this.speedTowardsTarget = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.hasPositionTarget()) {
            return false;
        }
        this.mob.setHywTarget(this.mob.m_5448_());
        return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
    }

    public boolean m_8045_() {
        return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && !this.hasPositionTarget();
    }

    public void m_8056_() {
        boolean skipRotation = this.mob.shouldSkipBaseRotation();
        if (skipRotation && !this.allowNavigationWhileSkipping()) {
            return;
        }
        if (skipRotation) {
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            }
        } else {
            this.mob.m_21573_().m_26573_();
            this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
        }
    }

    public void m_8041_() {
    }

    public void m_8037_() {
        if (this.hasPositionTarget()) {
            return;
        }
        boolean skipRotation = this.mob.shouldSkipBaseRotation();
        if (skipRotation && !this.allowNavigationWhileSkipping()) {
            this.mob.m_21573_().m_26573_();
            return;
        }
        if (this.mob.getHywTarget() == null && this.mob.m_5448_() != null) {
            this.mob.setHywTarget(this.mob.m_5448_());
        }
        if (this.mob.getHywTarget() != null) {
            double homeToTargetDistanceSq;
            boolean withinAttackRange;
            double distanceSq = this.mob.m_20275_(this.mob.getHywTarget().m_20185_(), this.mob.getHywTarget().m_20186_(), this.mob.getHywTarget().m_20189_());
            boolean bl = withinAttackRange = distanceSq <= (double)(this.mob.getAttackReach() * this.mob.getAttackReach());
            if (!withinAttackRange) {
                if (!this.mob.commandHold() && !this.mob.isHolding()) {
                    this.pursueTarget();
                }
            } else if (this.mob.getHomePosition() != null && (homeToTargetDistanceSq = this.mob.getHomePosition().m_123331_((Vec3i)this.mob.getHywTarget().m_20183_())) <= (double)(this.mob.getAttackReach() * this.mob.getAttackReach()) && (this.mob.getCurrentCommandedGoal() == null || !(this.mob.getCurrentCommandedGoal().goal instanceof MoveGoal))) {
                this.returnToHome();
            }
        }
        if (!this.mob.isValidTarget(this.mob.getHywTarget())) {
            this.mob.setHywTarget(null);
            this.mob.m_6710_(null);
        }
    }

    private void pursueTarget() {
        this.mob.m_21573_().m_5624_((Entity)this.mob.getHywTarget(), this.speedTowardsTarget);
    }

    private void returnToHome() {
        double homeZ;
        double homeY;
        if (this.mob.getHomePosition() == null) {
            return;
        }
        double homeX = (double)this.mob.getHomePosition().m_123341_() + 0.5;
        double distanceToHomeSq = this.mob.m_20275_(homeX, homeY = (double)this.mob.getHomePosition().m_123342_(), homeZ = (double)this.mob.getHomePosition().m_123343_() + 0.5);
        if (distanceToHomeSq > 0.5) {
            MeleeCapableRangedAttacker meleeCapable;
            BaseCombatEntity baseCombatEntity;
            if (this.mob instanceof RangedAttackMob && (!((baseCombatEntity = this.mob) instanceof MeleeCapableRangedAttacker) || (meleeCapable = (MeleeCapableRangedAttacker)((Object)baseCombatEntity)).isUsingRanged())) {
                this.mob.setForceMoveOnly(true);
            } else {
                this.mob.setForceMoveOnly(false);
            }
            this.mob.m_21573_().m_26519_(homeX, homeY, homeZ, this.speedTowardsTarget);
        } else {
            this.mob.setForceMoveOnly(false);
        }
    }

    private boolean allowNavigationWhileSkipping() {
        BanditExecutionerEntity axeman;
        BaseCombatEntity baseCombatEntity = this.mob;
        return baseCombatEntity instanceof BanditExecutionerEntity && (axeman = (BanditExecutionerEntity)baseCombatEntity).isSpinning();
    }

    private boolean hasPositionTarget() {
        PositionAttackable positionAttackable;
        BaseCombatEntity baseCombatEntity = this.mob;
        return baseCombatEntity instanceof PositionAttackable && (positionAttackable = (PositionAttackable)((Object)baseCombatEntity)).hasPositionTarget();
    }
}

