/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.goals;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.entity.entities.ArcherEntity;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.HywHorseEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.SiegeUnit;
import ydmsama.hundred_years_war.main.entity.goals.MoveGoal;
import ydmsama.hundred_years_war.main.entity.utils.HorseRider;
import ydmsama.hundred_years_war.main.entity.utils.Mountable;
import ydmsama.hundred_years_war.main.entity.utils.MultiSeatVehicle;
import ydmsama.hundred_years_war.main.entity.utils.PathingTask;
import ydmsama.hundred_years_war.main.entity.utils.PathingTaskManager;
import ydmsama.hundred_years_war.main.entity.utils.PathingTaskManagerRegistry;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

public class FollowEntityGoal
extends Goal
implements MoveGoal {
    private final BaseCombatEntity mob;
    private final double speed;
    private LivingEntity targetEntity;
    private final double followRange;
    private final double triggerRange;
    private final double teleportRange;
    private final double maxTeleportRange;
    private boolean shouldRemove;
    private boolean tryRiding;
    private Path currentPath;
    private boolean pathGenerated = false;

    public FollowEntityGoal(BaseCombatEntity mob, double speed, double followRange, double triggerRange, double teleportRange, double maxTeleportRange) {
        this.mob = mob;
        this.speed = speed;
        this.followRange = followRange;
        this.triggerRange = triggerRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.shouldRemove = true;
        this.teleportRange = teleportRange;
        this.maxTeleportRange = maxTeleportRange;
    }

    public boolean m_8036_() {
        double distanceToTarget;
        AbstractHorse horse;
        LivingEntity livingEntity;
        this.targetEntity = this.mob.getFollowTarget();
        if (this.targetEntity == null || !this.targetEntity.m_6084_()) {
            return false;
        }
        if (!this.mob.getGoalQueue().isEmpty()) {
            return false;
        }
        if (this.mob instanceof HorseRider && (livingEntity = this.targetEntity) instanceof AbstractHorse && (horse = (AbstractHorse)livingEntity).m_30614_() && horse.m_6254_() || this.mob instanceof Mountable && this.targetEntity instanceof MultiSeatVehicle) {
            this.tryRiding = true;
        }
        return (distanceToTarget = this.mob.m_20280_((Entity)this.targetEntity)) > this.triggerRange * this.triggerRange || !this.shouldRemove || this.tryRiding;
    }

    public boolean m_8045_() {
        double distanceToTarget;
        this.targetEntity = this.mob.getFollowTarget();
        if (this.targetEntity == null || !this.targetEntity.m_6084_()) {
            return false;
        }
        if (this.mob instanceof ArcherEntity && this.targetEntity instanceof HywHorseEntity || this.mob instanceof HorseRider && this.targetEntity instanceof AbstractHorse || this.mob instanceof Mountable && this.targetEntity instanceof MultiSeatVehicle) {
            this.tryRiding = true;
        }
        return (distanceToTarget = this.mob.m_20280_((Entity)this.targetEntity)) > this.triggerRange * this.triggerRange || !this.shouldRemove || this.tryRiding;
    }

    public void m_8056_() {
        this.mob.setHomePosition(null);
        this.targetEntity = this.mob.getFollowTarget();
        if (!this.mob.commandHold()) {
            this.mob.setCommandHold(false);
        }
        this.shouldRemove = false;
        this.updatePath();
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
    }

    private boolean isInRidingRange(LivingEntity rider, LivingEntity vehicle) {
        double deltaX = rider.m_20185_() - vehicle.m_20185_();
        double deltaZ = rider.m_20189_() - vehicle.m_20189_();
        double horizontalDistance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        double heightDiff = rider.m_20186_() - vehicle.m_20186_();
        double vehicleHeight = vehicle.m_20206_();
        double minHeightDiff = -0.5 * vehicleHeight;
        double maxHeightDiff = 1.0 * vehicleHeight;
        double maxHorizontalDistance = Math.max((double)vehicle.m_20205_() * 3.0, 2.0);
        return horizontalDistance <= maxHorizontalDistance && heightDiff >= minHeightDiff && heightDiff <= maxHeightDiff;
    }

    public void m_8037_() {
        LivingEntity livingEntity;
        this.targetEntity = this.mob.getFollowTarget();
        if (this.targetEntity == null) {
            return;
        }
        double distanceToTarget = this.mob.m_20280_((Entity)this.targetEntity);
        if (this.tryRiding) {
            if (this.mob instanceof HorseRider && this.targetEntity instanceof AbstractHorse && !this.mob.m_20159_() && this.targetEntity.m_20197_().isEmpty() && this.isInRidingRange((LivingEntity)this.mob, this.targetEntity)) {
                this.mob.m_7998_((Entity)this.targetEntity, true);
                SelectionSystem.clearEntityFromAllSelections(this.mob);
                this.tryRiding = false;
                return;
            }
            if (this.mob instanceof Mountable && (livingEntity = this.targetEntity) instanceof MultiSeatVehicle) {
                MultiSeatVehicle multiSeatVehicle = (MultiSeatVehicle)livingEntity;
                if (!this.mob.m_20159_() && multiSeatVehicle.canEntityMount((Entity)this.mob) && this.isInRidingRange((LivingEntity)this.mob, this.targetEntity)) {
                    this.mob.m_7998_((Entity)this.targetEntity, true);
                    SelectionSystem.clearEntityFromAllSelections(this.mob);
                    this.tryRiding = false;
                    return;
                }
            }
        }
        if (distanceToTarget > this.followRange * this.followRange) {
            this.mob.m_21573_().m_5624_((Entity)this.targetEntity, this.speed);
        } else {
            this.shouldRemove = true;
        }
        if (distanceToTarget > this.teleportRange * this.teleportRange && distanceToTarget < this.maxTeleportRange * this.maxTeleportRange && (livingEntity = this.targetEntity) instanceof Player) {
            Player player = (Player)livingEntity;
            if (!(this.mob instanceof SiegeUnit) && ServerRelationHelper.hasControlOver(player, (Entity)this.mob)) {
                Vec3 teleportPos = this.findSafeTeleportPosition();
                if (teleportPos != null) {
                    LivingEntity actualEntity = this.getActualEntity();
                    actualEntity.m_6021_(teleportPos.f_82479_, teleportPos.f_82480_, teleportPos.f_82481_);
                    this.currentPath = null;
                }
                this.shouldRemove = true;
            }
        }
    }

    private void updatePath() {
        if (this.pathGenerated) {
            if (this.currentPath == null || this.currentPath.m_77392_() || !this.mob.m_21573_().m_26572_()) {
                this.currentPath = this.mob.m_21573_().m_148218_(this.targetEntity.m_20183_(), 0, 16);
            }
        } else {
            this.createPathingTask(this.mob, this.targetEntity);
        }
    }

    private void createPathingTask(BaseCombatEntity mob, LivingEntity target) {
        Consumer<Path> pathConsumer = path -> {
            this.currentPath = path;
            this.pathGenerated = true;
        };
        PathingTask task = new PathingTask(mob, target.m_20183_(), pathConsumer);
        PathingTaskManagerRegistry registry = PathingTaskManagerRegistry.getInstance();
        PathingTaskManager manager = registry.getTaskManager(mob.m_21805_());
        manager.addTask(task);
    }

    private LivingEntity getActualEntity() {
        Entity entity = this.mob.m_20202_();
        if (entity instanceof HywHorseEntity) {
            HywHorseEntity horse = (HywHorseEntity)entity;
            return horse;
        }
        return this.mob;
    }

    private Vec3 findSafeTeleportPosition() {
        BlockPos targetPos = this.targetEntity.m_20183_();
        LivingEntity actualEntity = this.getActualEntity();
        BlockPos mobPos = actualEntity.m_20183_();
        double distanceToTarget = Math.sqrt(actualEntity.m_20280_((Entity)this.targetEntity));
        int range = 10;
        int heightLimit = 5;
        ArrayList<TeleportCandidate> candidates = new ArrayList<TeleportCandidate>();
        if (this.searchAtHeightDiff(targetPos, mobPos, distanceToTarget, range, 0, candidates)) {
            return this.selectBestCandidate(candidates);
        }
        if (this.searchAtHeightDiff(targetPos, mobPos, distanceToTarget, range, 1, candidates)) {
            return this.selectBestCandidate(candidates);
        }
        if (this.searchAtHeightDiff(targetPos, mobPos, distanceToTarget, range, 2, candidates)) {
            return this.selectBestCandidate(candidates);
        }
        int reducedRange = Math.max(3, range / 2);
        for (int heightDiff = 3; heightDiff <= heightLimit; ++heightDiff) {
            if (!this.searchAtHeightDiff(targetPos, mobPos, distanceToTarget, reducedRange, heightDiff, candidates)) continue;
            return this.selectBestCandidate(candidates);
        }
        return null;
    }

    private boolean searchAtHeightDiff(BlockPos targetPos, BlockPos mobPos, double distanceToTarget, int range, int heightDiff, List<TeleportCandidate> candidates) {
        candidates.clear();
        int maxCandidates = 50;
        List<int[]> searchOrder = this.generateSpiralSearchOrder(range);
        for (int[] offset : searchOrder) {
            int[] yOffsets;
            int[] nArray;
            if (candidates.size() >= maxCandidates) break;
            int newX = targetPos.m_123341_() + offset[0];
            int newZ = targetPos.m_123343_() + offset[1];
            double distanceToNewPos = Math.sqrt(mobPos.m_123331_((Vec3i)new BlockPos(newX, targetPos.m_123342_(), newZ)));
            if (distanceToNewPos > distanceToTarget) continue;
            if (heightDiff == 0) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                int[] nArray3 = new int[2];
                nArray3[0] = heightDiff;
                nArray = nArray3;
                nArray3[1] = -heightDiff;
            }
            for (int yOffset : yOffsets = nArray) {
                Vec3 candidatePos;
                BlockPos pos = new BlockPos(newX, targetPos.m_123342_() + yOffset, newZ);
                if (this.isSafeTeleportLocation(pos, candidatePos = new Vec3((double)newX + 0.5, (double)pos.m_123342_(), (double)newZ + 0.5), false)) {
                    candidates.add(new TeleportCandidate(candidatePos, heightDiff, false));
                    continue;
                }
                if (!this.isSafeTeleportLocation(pos, candidatePos, true)) continue;
                candidates.add(new TeleportCandidate(candidatePos, heightDiff, true));
            }
        }
        return !candidates.isEmpty();
    }

    private List<int[]> generateSpiralSearchOrder(int range) {
        ArrayList<int[]> order = new ArrayList<int[]>();
        order.add(new int[]{0, 0});
        for (int layer = 1; layer <= range; ++layer) {
            int x = -layer;
            while (x <= layer) {
                order.add(new int[]{x++, layer});
            }
            x = layer - 1;
            while (x >= -layer) {
                order.add(new int[]{x--, -layer});
            }
            int z = -layer + 1;
            while (z <= layer - 1) {
                order.add(new int[]{-layer, z++});
            }
            z = layer - 1;
            while (z >= -layer + 1) {
                order.add(new int[]{layer, z--});
            }
        }
        return order;
    }

    private Vec3 selectBestCandidate(List<TeleportCandidate> candidates) {
        if (candidates.isEmpty()) {
            return null;
        }
        candidates.sort(Comparator.comparing(TeleportCandidate::isWater));
        boolean bestIsWater = candidates.get((int)0).isWater;
        ArrayList<TeleportCandidate> bestCandidates = new ArrayList<TeleportCandidate>();
        for (TeleportCandidate candidate : candidates) {
            if (candidate.isWater != bestIsWater) break;
            bestCandidates.add(candidate);
        }
        TeleportCandidate chosen = (TeleportCandidate)bestCandidates.get(this.mob.m_217043_().m_188503_(bestCandidates.size()));
        return chosen.position;
    }

    private boolean isSafeTeleportLocation(BlockPos blockPos, Vec3 targetCenter, boolean allowWater) {
        boolean waterBase;
        LivingEntity actualEntity = this.getActualEntity();
        Level level = actualEntity.m_9236_();
        BlockPos below = blockPos.m_7495_();
        BlockState blockStateBelow = level.m_8055_(below);
        FluidState fluidStateBelow = level.m_6425_(below);
        boolean solidBase = blockStateBelow.m_280296_();
        boolean bl = waterBase = fluidStateBelow.m_205070_(FluidTags.f_13131_) || blockStateBelow.m_60713_(Blocks.f_49990_);
        if (!(solidBase || allowWater && waterBase)) {
            return false;
        }
        Vec3 offset = targetCenter.m_82546_(actualEntity.m_20182_());
        AABB targetBox = actualEntity.m_20191_().m_82383_(offset);
        if (!level.m_45756_((Entity)actualEntity, targetBox)) {
            return false;
        }
        int minX = Mth.m_14107_((double)targetBox.f_82288_);
        int maxX = Mth.m_14107_((double)(targetBox.f_82291_ - 1.0E-4));
        int minY = Mth.m_14107_((double)targetBox.f_82289_);
        int maxY = Mth.m_14107_((double)(targetBox.f_82292_ - 1.0E-4));
        int minZ = Mth.m_14107_((double)targetBox.f_82290_);
        int maxZ = Mth.m_14107_((double)(targetBox.f_82293_ - 1.0E-4));
        for (BlockPos checkPos : BlockPos.m_121976_((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ)) {
            BlockState state = level.m_8055_(checkPos);
            FluidState fluidState = level.m_6425_(checkPos);
            if (!state.m_60812_((BlockGetter)level, checkPos).m_83281_()) {
                return false;
            }
            if (fluidState.m_76178_()) continue;
            if (fluidState.m_205070_(FluidTags.f_13131_)) {
                if (allowWater) continue;
                return false;
            }
            return false;
        }
        return level.m_6249_((Entity)actualEntity, targetBox, entity -> entity.m_6084_() && entity != actualEntity && !entity.m_5833_()).isEmpty();
    }

    private static class TeleportCandidate {
        final Vec3 position;
        final int heightDiff;
        final boolean isWater;

        TeleportCandidate(Vec3 position, int heightDiff, boolean isWater) {
            this.position = position;
            this.heightDiff = heightDiff;
            this.isWater = isWater;
        }

        public int heightDiff() {
            return this.heightDiff;
        }

        public boolean isWater() {
            return this.isWater;
        }
    }
}

