/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.goals;

import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.goals.CommandedGoal;
import ydmsama.hundred_years_war.main.entity.goals.MoveGoal;
import ydmsama.hundred_years_war.main.entity.utils.FormationManager;
import ydmsama.hundred_years_war.main.entity.utils.PathfindingUtil;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;

public class MoveToBlockGoal
extends Goal
implements CommandedGoal,
MoveGoal {
    private boolean init = true;
    private final UUID FormationUUID;
    private boolean shouldRemove = false;
    private BaseCombatEntity mob;
    private final double speed;
    private BlockPos targetPos;
    private boolean pathGenerated = false;

    public MoveToBlockGoal(BaseCombatEntity mob, double speed, UUID formationUUID) {
        this.mob = mob;
        this.speed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.FormationUUID = formationUUID;
    }

    public void setTargetPos(BlockPos targetPos) {
        BlockState blockState = ((EntityAccessor)((Object)this.mob)).getLevel().m_8055_(targetPos);
        this.targetPos = !blockState.m_60804_((BlockGetter)((EntityAccessor)((Object)this.mob)).getLevel(), targetPos) || blockState.m_60795_() ? targetPos : targetPos.m_7494_();
    }

    public boolean m_8036_() {
        if (this.targetPos == null) {
            return false;
        }
        return !this.shouldRemove;
    }

    public boolean m_8045_() {
        return !this.shouldRemove;
    }

    public void m_8056_() {
        if (this.init) {
            this.mob.setHomePosition(this.targetPos);
            this.mob.setFormationUUID(this.FormationUUID);
            this.mob.setCommandHold(false);
            PathfindingUtil.moveTo(this.mob, this.targetPos, this.speed, () -> {
                this.pathGenerated = true;
            });
            this.init = false;
        }
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
    }

    public void m_8037_() {
        if (this.targetPos == null) {
            return;
        }
        BlockPos currentHorizontalPos = new BlockPos((int)Math.floor(this.mob.m_20185_()), this.targetPos.m_123342_(), (int)Math.floor(this.mob.m_20189_()));
        double verticalDistance = Math.abs(this.mob.m_20186_() - (double)this.targetPos.m_123342_());
        BlockState targetBlockState = ((EntityAccessor)((Object)this.mob)).getLevel().m_8055_(this.targetPos.m_7495_());
        boolean isTargetAir = targetBlockState.m_60795_();
        boolean hasArrived = false;
        if (isTargetAir) {
            if (currentHorizontalPos.m_123314_((Vec3i)this.targetPos, this.mob.getArrivalThreshold())) {
                hasArrived = true;
            }
        } else if (currentHorizontalPos.m_123314_((Vec3i)this.targetPos, this.mob.getArrivalThreshold()) && verticalDistance < 1.0) {
            hasArrived = true;
        }
        if (hasArrived) {
            this.shouldRemove = true;
            this.executeNext();
        }
        if (this.pathGenerated) {
            PathfindingUtil.continueVanillaMovement(this.mob, this.targetPos, 1.0);
        }
    }

    @Override
    public void executeNext() {
        this.mob.setShouldExecuteNext(true);
        this.mob.goalFinished();
    }

    @Override
    public void updateEntityReference(BaseCombatEntity newEntity) {
        FormationManager.FormationStatus formationStatus;
        this.mob = newEntity;
        this.mob.setFormationUUID(this.FormationUUID);
        if (this.FormationUUID != null && (formationStatus = FormationManager.getFormationStatus(this.FormationUUID)) != null) {
            formationStatus.getEntities().add(newEntity);
            int currentSize = formationStatus.getEntities().size();
            formationStatus.setFormationSize(currentSize);
        }
    }
}

