/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.navigation;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.entity.entities.tags.SiegeUnit;
import ydmsama.hundred_years_war.main.entity.navigation.LadderAwareNodeEvaluator;

public class BaseCombatNavigation
extends GroundPathNavigation {
    public BaseCombatNavigation(Mob mob, Level level) {
        super(mob, level);
    }

    protected PathFinder m_5532_(int range) {
        this.f_26508_ = new LadderAwareNodeEvaluator();
        this.f_26508_.m_77351_(true);
        return new PathFinder(this.f_26508_, range);
    }

    protected boolean m_7632_() {
        boolean needsLadderLogic = !this.isSiegeOrMountedEntity() && this.isEntityOnClimbableBlock();
        return this.f_26494_.m_20096_() || this.m_26574_() || this.f_26494_.m_20159_() || needsLadderLogic;
    }

    private boolean isSiegeOrMountedEntity() {
        return this.f_26494_ instanceof SiegeUnit || this.f_26494_.m_20202_() != null;
    }

    private boolean isEntityOnClimbableBlock() {
        if (this.isOnSafeGroundForNavigation()) {
            return false;
        }
        if (this.isStandingOnSolidPlatform()) {
            return false;
        }
        return this.hasClimbableBlockNearby();
    }

    private boolean isStandingOnSolidPlatform() {
        BlockPos pos = this.f_26494_.m_20183_();
        BlockPos belowPos = pos.m_7495_();
        boolean isOnSolidGround = this.f_26495_.m_8055_(belowPos).m_60804_((BlockGetter)this.f_26495_, belowPos);
        boolean hasHeadroom = this.f_26495_.m_8055_(pos.m_7494_()).m_60795_();
        Vec3 entityPos = this.f_26494_.m_20182_();
        double floorY = (double)belowPos.m_123342_() + 1.0;
        boolean isNearGround = Math.abs(entityPos.f_82480_ - floorY) < 0.3;
        return isOnSolidGround && hasHeadroom && isNearGround;
    }

    private boolean isAtLadderTopNearPlatform() {
        Direction[] directions;
        boolean noLadderAbove;
        BlockPos pos = this.f_26494_.m_20183_();
        boolean hasLadderBelow = this.f_26495_.m_8055_(pos).m_204336_(BlockTags.f_13082_) || this.f_26495_.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13082_);
        boolean bl = noLadderAbove = !this.f_26495_.m_8055_(pos.m_7494_()).m_204336_(BlockTags.f_13082_);
        if (!hasLadderBelow || !noLadderAbove) {
            return false;
        }
        for (Direction dir : directions = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            BlockPos adjacentPos = pos.m_121945_(dir);
            if (!this.isPlatformAccessible(adjacentPos) && !this.isPlatformAccessible(adjacentPos.m_7494_())) continue;
            return true;
        }
        return false;
    }

    private boolean hasClimbableBlockNearby() {
        BlockPos pos = this.f_26494_.m_20183_();
        return this.f_26495_.m_8055_(pos).m_204336_(BlockTags.f_13082_) || this.f_26495_.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13082_);
    }

    private boolean isPlatformAccessible(BlockPos pos) {
        boolean isSolidBlock = this.f_26495_.m_8055_(pos).m_60804_((BlockGetter)this.f_26495_, pos);
        boolean hasSpace1 = this.f_26495_.m_8055_(pos.m_7494_()).m_60795_();
        boolean hasSpace2 = this.f_26495_.m_8055_(pos.m_6630_(2)).m_60795_();
        return isSolidBlock && hasSpace1 && hasSpace2;
    }

    private boolean isOnSafeGroundForNavigation() {
        Direction[] directions;
        BlockPos currentPos = this.f_26494_.m_20183_();
        BlockPos belowPos = currentPos.m_7495_();
        if (!this.f_26494_.m_20096_()) {
            return false;
        }
        if (!this.f_26495_.m_8055_(belowPos).m_60804_((BlockGetter)this.f_26495_, belowPos)) {
            return false;
        }
        if (this.f_26495_.m_8055_(currentPos).m_204336_(BlockTags.f_13082_) || this.f_26495_.m_8055_(belowPos).m_204336_(BlockTags.f_13082_)) {
            return false;
        }
        for (Direction dir : directions = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            for (int i = 1; i <= 3; ++i) {
                BlockPos checkPos = currentPos.m_5484_(dir, i);
                if (!this.f_26495_.m_8055_(checkPos).m_204336_(BlockTags.f_13082_) && !this.f_26495_.m_8055_(checkPos.m_7495_()).m_204336_(BlockTags.f_13082_) && !this.f_26495_.m_8055_(checkPos.m_7494_()).m_204336_(BlockTags.f_13082_)) continue;
                return false;
            }
        }
        Vec3 entityPos = this.f_26494_.m_20182_();
        double expectedY = (double)belowPos.m_123342_() + 1.0;
        return !(Math.abs(entityPos.f_82480_ - expectedY) > 0.1);
    }
}

