/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;

@Mod.EventBusSubscriber(modid="hundred_years_war")
public class BuildingSyncEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildingSyncEventHandler.class);
    private static final Map<UUID, Set<ChunkPos>> playerSyncedChunks = new HashMap<UUID, Set<ChunkPos>>();
    private static final Map<UUID, ChunkPos> playerLastChunkPos = new HashMap<UUID, ChunkPos>();
    private static final int SYNC_RADIUS = 16;
    private static int tickCounter = 0;
    private static final int CHECK_INTERVAL = 40;

    public static void init() {
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            UUID playerId = player2.m_20148_();
            playerSyncedChunks.remove(playerId);
            playerLastChunkPos.remove(playerId);
            ChunkPos playerChunk = new ChunkPos(player2.m_20183_());
            playerLastChunkPos.put(playerId, playerChunk);
            HashSet<ChunkPos> syncedChunks = new HashSet<ChunkPos>();
            playerSyncedChunks.put(playerId, syncedChunks);
            BuildingSyncEventHandler.syncNearbyChunks(player2, playerChunk, syncedChunks);
            LOGGER.debug("Initialized building sync for player {}", (Object)player2.m_7755_().getString());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            UUID playerId = player2.m_20148_();
            playerSyncedChunks.remove(playerId);
            playerLastChunkPos.remove(playerId);
            LOGGER.debug("Cleaned up building sync for player {}", (Object)player2.m_7755_().getString());
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ++tickCounter >= 40) {
            tickCounter = 0;
            if (event.getServer() != null) {
                for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
                    BuildingSyncEventHandler.checkPlayerChunkChange(player);
                }
            }
        }
    }

    private static void checkPlayerChunkChange(ServerPlayer player) {
        UUID playerId = player.m_20148_();
        ChunkPos currentChunk = new ChunkPos(player.m_20183_());
        ChunkPos lastChunk = playerLastChunkPos.get(playerId);
        if (lastChunk == null) {
            playerLastChunkPos.put(playerId, currentChunk);
            HashSet<ChunkPos> syncedChunks = new HashSet<ChunkPos>();
            playerSyncedChunks.put(playerId, syncedChunks);
            BuildingSyncEventHandler.syncNearbyChunks(player, currentChunk, syncedChunks);
            return;
        }
        if (!currentChunk.equals((Object)lastChunk)) {
            playerLastChunkPos.put(playerId, currentChunk);
            Set<ChunkPos> syncedChunks = playerSyncedChunks.get(playerId);
            if (syncedChunks == null) {
                syncedChunks = new HashSet<ChunkPos>();
                playerSyncedChunks.put(playerId, syncedChunks);
            }
            int beforeSize = syncedChunks.size();
            BuildingSyncEventHandler.syncNearbyChunks(player, currentChunk, syncedChunks);
            int newChunks = syncedChunks.size() - beforeSize;
            if (newChunks > 0) {
                LOGGER.debug("Synced {} new chunks of building data for player {} at chunk ({}, {})", new Object[]{newChunks, player.m_7755_().getString(), currentChunk.f_45578_, currentChunk.f_45579_});
            }
            BuildingSyncEventHandler.cleanupDistantChunks(currentChunk, syncedChunks);
        }
    }

    private static void syncNearbyChunks(ServerPlayer player, ChunkPos centerChunk, Set<ChunkPos> syncedChunks) {
        ArrayList<ChunkPos> chunksToSync = new ArrayList<ChunkPos>();
        for (int dx = -16; dx <= 16; ++dx) {
            for (int dz = -16; dz <= 16; ++dz) {
                ChunkPos chunkPos = new ChunkPos(centerChunk.f_45578_ + dx, centerChunk.f_45579_ + dz);
                if (syncedChunks.contains(chunkPos)) continue;
                chunksToSync.add(chunkPos);
                syncedChunks.add(chunkPos);
            }
        }
        int batchSize = 8;
        for (int i = 0; i < chunksToSync.size(); i += batchSize) {
            int endIndex = Math.min(i + batchSize, chunksToSync.size());
            List batch = chunksToSync.subList(i, endIndex);
            for (ChunkPos chunkPos : batch) {
                ServerPacketHandler.sendChunkBuildings(player, chunkPos);
            }
        }
    }

    private static void cleanupDistantChunks(ChunkPos centerChunk, Set<ChunkPos> syncedChunks) {
        int cleanupRadius = 32;
        syncedChunks.removeIf(chunk -> {
            int dx = Math.abs(chunk.f_45578_ - centerChunk.f_45578_);
            int dz = Math.abs(chunk.f_45579_ - centerChunk.f_45579_);
            return dx > cleanupRadius || dz > cleanupRadius;
        });
    }

    public static void forceResync(ServerPlayer player) {
        UUID playerId = player.m_20148_();
        playerSyncedChunks.remove(playerId);
        playerLastChunkPos.remove(playerId);
        ChunkPos playerChunk = new ChunkPos(player.m_20183_());
        playerLastChunkPos.put(playerId, playerChunk);
        HashSet<ChunkPos> syncedChunks = new HashSet<ChunkPos>();
        playerSyncedChunks.put(playerId, syncedChunks);
        BuildingSyncEventHandler.syncNearbyChunks(player, playerChunk, syncedChunks);
        LOGGER.info("Force resynced buildings for player {}", (Object)player.m_7755_().getString());
    }
}

