/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.generation;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ydmsama.hundred_years_war.main.chunk.HywChunkManager;
import ydmsama.hundred_years_war.main.generation.InstGenManager;
import ydmsama.hundred_years_war.main.generation.StructureLocationGenerator;
import ydmsama.hundred_years_war.main.generation.StructurePlacementHelper;
import ydmsama.hundred_years_war.main.generation.StructurePosition;
import ydmsama.hundred_years_war.main.generation.StructurePositionResolver;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.template.BuildTemplateService;
import ydmsama.hundred_years_war.main.template.BuildingTaskManager;
import ydmsama.hundred_years_war.main.template.HywStructureTemplate;
import ydmsama.hundred_years_war.main.template.PlacedBuilding;
import ydmsama.hundred_years_war.main.template.PlacedBuildingRegistry;
import ydmsama.hundred_years_war.main.template.TemplateManager;
import ydmsama.hundred_years_war.main.template.TemplateMetadata;

public class PregenManager
extends SavedData {
    private static final Logger LOGGER = LoggerFactory.getLogger(PregenManager.class);
    private static final String DATA_NAME = "hundred_years_war_pregen";
    private static final int DEFAULT_BATCH_SIZE = 99999;
    private static final int MAX_GRID_SEARCH_RADIUS = 12;
    private static final int MIN_DISTANCE_TO_PLAYER = 0;
    private static final int MAX_CANDIDATE_ATTEMPTS = 8;
    private static final long CANDIDATE_SELECTION_WARN_THRESHOLD_MS = 50L;
    private static final long GLOBAL_TICK_WARN_THRESHOLD_MS = 50L;
    private static volatile boolean LOG_ENABLED = false;
    private static volatile boolean DEBUG_LOGGING = false;
    private static volatile int MAX_CONCURRENT_TASKS = 1;
    private static volatile double BLOCKS_PER_SECOND = 10000.0;
    private final LongSet knownEmptyGrids = new LongOpenHashSet();
    private boolean pregenEnabled = true;
    private transient ServerLevel cachedLevel;
    private transient HywChunkManager chunkManager;
    private transient StructurePositionResolver positionResolver;
    private final Long2ObjectOpenHashMap<PregenTask> activeTasks = new Long2ObjectOpenHashMap();
    private final LongOpenHashSet sessionFailureGrids = new LongOpenHashSet();
    private long lastTickGameTime = -1L;

    public PregenManager() {
    }

    public PregenManager(CompoundTag tag) {
        if (tag.m_128441_("enabled")) {
            this.pregenEnabled = tag.m_128471_("enabled");
        }
        if (tag.m_128425_("empty", 9)) {
            ListTag list = tag.m_128437_("empty", 4);
            for (int i = 0; i < list.size(); ++i) {
                this.knownEmptyGrids.add(((LongTag)list.get(i)).m_7046_());
            }
        }
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128379_("enabled", this.pregenEnabled);
        if (!this.knownEmptyGrids.isEmpty()) {
            ListTag list = new ListTag();
            LongIterator longIterator = this.knownEmptyGrids.iterator();
            while (longIterator.hasNext()) {
                long key = (Long)longIterator.next();
                list.add((Object)LongTag.m_128882_((long)key));
            }
            tag.m_128365_("empty", (Tag)list);
        } else {
            tag.m_128473_("empty");
        }
        return tag;
    }

    public static PregenManager get(ServerLevel level) {
        DimensionDataStorage storage = level.m_8895_();
        return (PregenManager)storage.m_164861_(PregenManager::new, PregenManager::new, DATA_NAME);
    }

    public static void setMaxConcurrentTasks(int slots) {
        MAX_CONCURRENT_TASKS = Math.max(1, slots);
        PregenManager.logInfo("Pregen | \u5e76\u53d1\u9884\u8f7d\u69fd\u4f4d\u5df2\u8bbe\u7f6e\u4e3a {}", MAX_CONCURRENT_TASKS);
    }

    public static void setBlocksPerSecond(double rate) {
        BLOCKS_PER_SECOND = Math.max(1.0, rate);
        PregenManager.logInfo("Pregen | \u6bcf\u79d2\u653e\u7f6e\u65b9\u5757\u91cf\u8bbe\u7f6e\u4e3a {}", String.format(Locale.ROOT, "%.2f", BLOCKS_PER_SECOND));
    }

    public static void setLoggingEnabled(boolean enabled) {
        LOG_ENABLED = enabled;
        LOGGER.info("Pregen | \u65e5\u5fd7\u8f93\u51fa {}", (Object)(enabled ? "\u5f00\u542f" : "\u5173\u95ed"));
    }

    public static void setDebugLoggingEnabled(boolean enabled) {
        DEBUG_LOGGING = enabled;
        LOGGER.info("Pregen | Debug\u65e5\u5fd7 {}", (Object)(enabled ? "\u5f00\u542f" : "\u5173\u95ed"));
    }

    public static boolean isDebugLoggingEnabled() {
        return DEBUG_LOGGING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void tick(ServerLevel level) {
        block17: {
            block16: {
                block15: {
                    tickStartNano = System.nanoTime();
                    if (level != null && !level.m_6907_().isEmpty()) break block15;
                    elapsedMs = (System.nanoTime() - tickStartNano) / 1000000L;
                    if (elapsedMs > 50L) {
                        playerCount = level != null ? level.m_6907_().size() : 0;
                        PregenManager.logWarn("Pregen | Tick \u8017\u65f6\u5f02\u5e38 | \u8017\u65f6:{}ms | \u6d3b\u52a8\u4efb\u52a1:{} | \u73a9\u5bb6\u6570:{}", new Object[]{elapsedMs, this.activeTasks.size(), playerCount});
                    }
                    return;
                }
                this.ensureRuntime(level);
                registry = PlacedBuildingRegistry.get(level);
                registry.ensureLegacySweep(level);
                gameTime = level.m_46467_();
                if (gameTime != this.lastTickGameTime) break block16;
                elapsedMs = (System.nanoTime() - tickStartNano) / 1000000L;
                if (elapsedMs > 50L) {
                    playerCount = level != null ? level.m_6907_().size() : 0;
                    PregenManager.logWarn("Pregen | Tick \u8017\u65f6\u5f02\u5e38 | \u8017\u65f6:{}ms | \u6d3b\u52a8\u4efb\u52a1:{} | \u73a9\u5bb6\u6570:{}", new Object[]{elapsedMs, this.activeTasks.size(), playerCount});
                }
                return;
            }
            this.lastTickGameTime = gameTime;
            if (this.pregenEnabled) break block17;
            elapsedMs = (System.nanoTime() - tickStartNano) / 1000000L;
            if (elapsedMs > 50L) {
                playerCount = level != null ? level.m_6907_().size() : 0;
                PregenManager.logWarn("Pregen | Tick \u8017\u65f6\u5f02\u5e38 | \u8017\u65f6:{}ms | \u6d3b\u52a8\u4efb\u52a1:{} | \u73a9\u5bb6\u6570:{}", new Object[]{elapsedMs, this.activeTasks.size(), playerCount});
            }
            return;
        }
        try {
            finishedKeys = new ArrayList<Long>();
            for (Long2ObjectMap.Entry entry : this.activeTasks.long2ObjectEntrySet()) {
                task = (PregenTask)entry.getValue();
                task.tick(level);
                if (!task.isFinished()) continue;
                finishedKeys.add(entry.getLongKey());
                if (task.wasSuccessful() || task.isCancelled()) continue;
                this.sessionFailureGrids.add(entry.getLongKey());
            }
            var8_17 = finishedKeys.iterator();
            while (var8_17.hasNext()) {
                key = (Long)var8_17.next();
                this.activeTasks.remove(key);
            }
            attempts = 0;
            while (this.activeTasks.size() < PregenManager.MAX_CONCURRENT_TASKS && attempts < 8) {
                ++attempts;
                selectionStart = System.nanoTime();
                candidate = this.findNextCandidate(level, registry);
                selectionDurationMs = (System.nanoTime() - selectionStart) / 1000000L;
                if (candidate == null) ** break;
                if (selectionDurationMs > 50L) {
                    PregenManager.logWarn("Pregen | \u5019\u9009\u9009\u62e9\u8017\u65f6\u8fc7\u957f | \u6a21\u677f:{} | \u7f51\u683c:({}, {}) | \u8017\u65f6:{}ms", new Object[]{candidate.position().getTemplateId(), candidate.gridX(), candidate.gridZ(), selectionDurationMs});
                }
                PregenManager.debug("\u5019\u9009\u9009\u62e9 | \u6a21\u677f:{} | \u7f51\u683c:({}, {}) | \u8ddd\u79bb:{} | \u5ef6\u8fdf:{}ms", new Object[]{candidate.position().getTemplateId(), candidate.gridX(), candidate.gridZ(), String.format(Locale.ROOT, "%.1f", new Object[]{Math.sqrt(candidate.distanceSqr())}), Math.max(0L, selectionDurationMs)});
                gridKey = candidate.gridKey();
                if (this.activeTasks.containsKey(gridKey) || this.sessionFailureGrids.contains(gridKey)) continue;
                task = this.createTaskForCandidate(level, candidate);
                if (task == null) {
                    this.sessionFailureGrids.add(gridKey);
                    continue;
                }
                this.activeTasks.put(gridKey, (Object)task);
                PregenManager.logInfo("Pregen | \u8ba1\u5212\u4efb\u52a1 | \u6a21\u677f:{} | \u7f51\u683c:({}, {}) | \u6700\u8fd1\u73a9\u5bb6\u8ddd\u79bb:{}", new Object[]{task.templateId, candidate.gridX(), candidate.gridZ(), String.format(Locale.ROOT, "%.1f", new Object[]{Math.sqrt(candidate.distanceSqr())})});
            }
        }
        catch (Throwable var17_24) {
            elapsedMs = (System.nanoTime() - tickStartNano) / 1000000L;
            if (elapsedMs > 50L) {
                playerCount = level != null ? level.m_6907_().size() : 0;
                PregenManager.logWarn("Pregen | Tick \u8017\u65f6\u5f02\u5e38 | \u8017\u65f6:{}ms | \u6d3b\u52a8\u4efb\u52a1:{} | \u73a9\u5bb6\u6570:{}", new Object[]{elapsedMs, this.activeTasks.size(), playerCount});
            }
            throw var17_24;
        }
        if ((elapsedMs = (System.nanoTime() - tickStartNano) / 1000000L) > 50L) {
            playerCount = level != null ? level.m_6907_().size() : 0;
            PregenManager.logWarn("Pregen | Tick \u8017\u65f6\u5f02\u5e38 | \u8017\u65f6:{}ms | \u6d3b\u52a8\u4efb\u52a1:{} | \u73a9\u5bb6\u6570:{}", new Object[]{elapsedMs, this.activeTasks.size(), playerCount});
        }
    }

    public void cancelTask(long gridKey, String reason, boolean cancelOutstanding) {
        PregenTask task;
        if (this.chunkManager == null && this.cachedLevel != null) {
            this.ensureRuntime(this.cachedLevel);
        }
        if ((task = (PregenTask)this.activeTasks.remove(gridKey)) != null) {
            String actualReason = reason == null ? "\u88ab\u5373\u65f6\u751f\u6210\u63a5\u7ba1" : reason;
            task.cancel(actualReason, cancelOutstanding);
            PregenManager.logInfo("Pregen | \u4efb\u52a1\u4e2d\u6b62 | \u6a21\u677f:{} | \u539f\u56e0:{}", task.templateId, actualReason);
        }
    }

    public void cancelTaskForPosition(BlockPos pos, String reason, boolean cancelOutstanding) {
        if (pos == null) {
            return;
        }
        int gridX = Math.floorDiv(pos.m_123341_(), StructureLocationGenerator.getGridSize());
        int gridZ = Math.floorDiv(pos.m_123343_(), StructureLocationGenerator.getGridSize());
        this.cancelTask(ChunkPos.m_45589_((int)gridX, (int)gridZ), reason, cancelOutstanding);
    }

    private void ensureRuntime(ServerLevel level) {
        if (this.cachedLevel == level && this.chunkManager != null && this.positionResolver != null) {
            return;
        }
        this.cachedLevel = level;
        this.chunkManager = HywChunkManager.get(level);
        this.positionResolver = new StructurePositionResolver(level);
        PregenManager.logInfo("Pregen | \u521d\u59cb\u5316\u8fd0\u884c\u65f6 | \u4e16\u754c:{}", level.m_46472_().m_135782_());
    }

    private Candidate findNextCandidate(ServerLevel level, PlacedBuildingRegistry registry) {
        double bestDistance = Double.MAX_VALUE;
        Candidate best = null;
        List players = level.m_6907_();
        if (players.isEmpty()) {
            return null;
        }
        InstGenManager instGenManager = InstGenManager.get(level);
        for (ServerPlayer player : players) {
            Candidate candidate = this.findCandidateAroundPlayer(level, player, instGenManager, registry);
            if (candidate == null || !(candidate.distanceSqr() < bestDistance)) continue;
            bestDistance = candidate.distanceSqr();
            best = candidate;
        }
        return best;
    }

    private Candidate findCandidateAroundPlayer(ServerLevel level, ServerPlayer player, InstGenManager instGenManager, PlacedBuildingRegistry registry) {
        int gridSize = StructureLocationGenerator.getGridSize();
        int baseGridX = Math.floorDiv(player.m_146903_(), gridSize);
        int baseGridZ = Math.floorDiv(player.m_146907_(), gridSize);
        BlockPos playerPos = player.m_20183_();
        Candidate bestCandidate = null;
        double bestDistance = Double.MAX_VALUE;
        for (int radius = 0; radius <= 12; ++radius) {
            boolean foundThisRing = false;
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    int gridZ;
                    int gridX;
                    Candidate candidate;
                    if (radius != 0 && Math.abs(dx) != radius && Math.abs(dz) != radius || (candidate = this.evaluateGridCandidate(level, gridX = baseGridX + dx, gridZ = baseGridZ + dz, playerPos, bestDistance, instGenManager, registry)) == null || !(candidate.distanceSqr() < bestDistance)) continue;
                    bestDistance = candidate.distanceSqr();
                    bestCandidate = candidate;
                    foundThisRing = true;
                }
            }
            if (foundThisRing) break;
        }
        return bestCandidate;
    }

    private Candidate evaluateGridCandidate(ServerLevel level, int gridX, int gridZ, BlockPos playerPos, double currentBestDistance, InstGenManager instGenManager, PlacedBuildingRegistry registry) {
        long key = ChunkPos.m_45589_((int)gridX, (int)gridZ);
        if (this.knownEmptyGrids.contains(key) || this.sessionFailureGrids.contains(key) || this.activeTasks.containsKey(key)) {
            return null;
        }
        if (registry != null && registry.isLegacyGridBlocked(key)) {
            return null;
        }
        if (instGenManager != null && instGenManager.isGridClaimed(key)) {
            return null;
        }
        StructurePosition position = this.positionResolver.getStructureAt(gridX, gridZ);
        if (position == null) {
            this.knownEmptyGrids.add(key);
            return null;
        }
        TemplateMetadata metadata = TemplateManager.getInstance().getMetadata(position.getTemplateId());
        if (metadata == null || !metadata.requiresPregen()) {
            this.knownEmptyGrids.add(key);
            return null;
        }
        double distanceSqr = position.getPosition().m_123331_((Vec3i)playerPos);
        if (distanceSqr < (double)Mth.m_144944_((int)0)) {
            return null;
        }
        if (distanceSqr >= currentBestDistance) {
            return null;
        }
        return new Candidate(key, gridX, gridZ, position, distanceSqr);
    }

    private PregenTask createTaskForCandidate(ServerLevel level, Candidate candidate) {
        PregenTask task = new PregenTask(candidate);
        if (!task.start(level)) {
            task.fail("\u521d\u59cb\u5316\u5931\u8d25");
            return null;
        }
        return task;
    }

    private static void logInfo(String message, Object ... args) {
        if (LOG_ENABLED) {
            LOGGER.info(message, args);
        }
    }

    private static void logWarn(String message, Object ... args) {
        if (LOG_ENABLED) {
            LOGGER.warn(message, args);
        }
    }

    private static void debug(String message, Object ... args) {
        if (!DEBUG_LOGGING) {
            return;
        }
        LOGGER.info("[PregenDebug] " + message, args);
    }

    private static void debugStep(String step, long startNano, String detail) {
        if (!DEBUG_LOGGING) {
            return;
        }
        long elapsedMs = Math.max(0L, (System.nanoTime() - startNano) / 1000000L);
        if (detail != null && !detail.isEmpty()) {
            PregenManager.debug("\u6b65\u9aa4:{} | \u8017\u65f6:{}ms | {}", step, elapsedMs, detail);
        } else {
            PregenManager.debug("\u6b65\u9aa4:{} | \u8017\u65f6:{}ms", step, elapsedMs);
        }
    }

    private static String formatPos(BlockPos pos) {
        if (pos == null) {
            return "(?, ?, ?)";
        }
        String y = pos.m_123342_() == Integer.MIN_VALUE ? "?" : Integer.toString(pos.m_123342_());
        return "(" + pos.m_123341_() + "," + y + "," + pos.m_123343_() + ")";
    }

    private static String formatChunks(List<ChunkPos> chunks) {
        if (chunks == null || chunks.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder("[");
        for (int i = 0; i < chunks.size(); ++i) {
            ChunkPos pos = chunks.get(i);
            builder.append(pos.f_45578_).append(",").append(pos.f_45579_);
            if (i >= chunks.size() - 1) continue;
            builder.append(" | ");
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean isEnabled() {
        return this.pregenEnabled;
    }

    public void setEnabled(ServerLevel level, boolean enabled) {
        if (this.pregenEnabled == enabled) {
            return;
        }
        if (level != null) {
            this.ensureRuntime(level);
        }
        this.pregenEnabled = enabled;
        this.m_77762_();
        if (!enabled) {
            this.cancelAllTasks("\u7cfb\u7edf\u7981\u7528", true);
            PregenManager.logInfo("Pregen | \u7cfb\u7edf\u5df2\u7981\u7528\uff0c\u5f53\u524d\u4efb\u52a1\u5168\u90e8\u4e2d\u6b62", new Object[0]);
        } else {
            PregenManager.logInfo("Pregen | \u7cfb\u7edf\u5df2\u542f\u7528", new Object[0]);
        }
    }

    public void cancelAllTasks(String reason, boolean cancelOutstanding) {
        ArrayList keys = new ArrayList(this.activeTasks.keySet());
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            long key = (Long)iterator.next();
            this.cancelTask(key, reason, cancelOutstanding);
        }
        this.activeTasks.clear();
    }

    public List<String> getActiveTaskSummaries() {
        ArrayList<String> summaries = new ArrayList<String>(this.activeTasks.size());
        for (Long2ObjectMap.Entry entry : this.activeTasks.long2ObjectEntrySet()) {
            summaries.add(((PregenTask)entry.getValue()).getSummary());
        }
        return summaries;
    }

    public String getStats() {
        return String.format(Locale.ROOT, "\u9884\u8f7d\u542f\u7528:%s | \u6d3b\u52a8\u4efb\u52a1:%d | \u5df2\u77e5\u7a7a\u7f51\u683c:%d | \u5931\u8d25\u7f51\u683c:%d | \u5e76\u53d1\u69fd\u4f4d:%d | Debug:%s", this.pregenEnabled ? "\u662f" : "\u5426", this.activeTasks.size(), this.knownEmptyGrids.size(), this.sessionFailureGrids.size(), MAX_CONCURRENT_TASKS, DEBUG_LOGGING ? "\u662f" : "\u5426");
    }

    private final class PregenTask {
        private static final int BUILDING_STATUS_MISSING_FAIL_TICKS = 200;
        private final Candidate candidate;
        private final String templateId;
        private TemplateMetadata metadata;
        private HywStructureTemplate template;
        private BlockPos placement;
        private List<List<ChunkPos>> batches = List.of();
        private int currentBatchIndex = 0;
        private long currentBatchStartNano = 0L;
        private CompletableFuture<Void> currentBatchFuture;
        private Throwable currentBatchError;
        private final LongSet outstandingChunks = new LongOpenHashSet();
        private ChunkPos anchorChunk;
        private long startNano = 0L;
        private long preheatStartNano = -1L;
        private long preheatDurationMs = 0L;
        private long totalBlocks = 0L;
        private long expectedBuildSeconds = 0L;
        private UUID buildingTaskId;
        private UUID registeredBuildingId;
        private long buildingWaitStartNano = -1L;
        private boolean waitingForBuildingCompletion = false;
        private int missingStatusTicks = 0;
        private float lastKnownProgress = 0.0f;
        private int lastLoggedProgressPercent = -1;
        private boolean finished = false;
        private boolean success = false;
        private boolean cancelled = false;
        private String outcomeReason = "";
        private boolean preheatCompleted = false;
        private boolean anchorTicketHeld = false;
        private boolean anchorChunkReady = false;

        PregenTask(Candidate candidate) {
            this.candidate = candidate;
            this.templateId = candidate.position().getTemplateId();
        }

        boolean start(ServerLevel level) {
            this.startNano = System.nanoTime();
            long stepStart = System.nanoTime();
            this.metadata = TemplateManager.getInstance().getMetadata(this.templateId);
            PregenManager.debugStep("load_metadata", stepStart, "template=" + this.templateId);
            if (this.metadata == null) {
                this.outcomeReason = "\u6a21\u677f\u5143\u6570\u636e\u7f3a\u5931";
                return false;
            }
            stepStart = System.nanoTime();
            this.template = TemplateManager.getInstance().loadTemplate(this.templateId);
            PregenManager.debugStep("load_template", stepStart, "template=" + this.templateId);
            if (this.template == null) {
                this.outcomeReason = "\u6a21\u677f\u6570\u636e\u7f3a\u5931";
                return false;
            }
            BlockPos basePos = this.candidate.position().getPosition();
            this.placement = new BlockPos(basePos.m_123341_(), Integer.MIN_VALUE, basePos.m_123343_());
            this.anchorChunk = new ChunkPos(basePos);
            stepStart = System.nanoTime();
            List<ChunkPos> coverage = StructurePlacementHelper.computeChunkCoverage(basePos.m_123341_(), basePos.m_123343_(), this.candidate.position().getRotation(), this.metadata, this.template);
            PregenManager.debugStep("compute_chunk_coverage", stepStart, "chunks=" + coverage.size());
            LinkedHashSet<Long> unique = new LinkedHashSet<Long>();
            unique.add(new ChunkPos(basePos).m_45588_());
            for (ChunkPos chunkPos : coverage) {
                unique.add(chunkPos.m_45588_());
            }
            stepStart = System.nanoTime();
            if (!unique.isEmpty()) {
                ArrayList<ChunkPos> chunkList = new ArrayList<ChunkPos>(unique.size());
                Iterator iterator = unique.iterator();
                while (iterator.hasNext()) {
                    long key = (Long)iterator.next();
                    chunkList.add(new ChunkPos(key));
                }
                ArrayList<List<ChunkPos>> arrayList = new ArrayList<List<ChunkPos>>();
                ArrayList<ChunkPos> current = new ArrayList<ChunkPos>(99999);
                for (ChunkPos chunkPos2 : chunkList) {
                    current.add(chunkPos2);
                    if (current.size() < 99999) continue;
                    arrayList.add(List.copyOf(current));
                    current.clear();
                }
                if (!current.isEmpty()) {
                    arrayList.add(List.copyOf(current));
                }
                this.batches = arrayList;
            } else {
                this.batches = List.of();
            }
            PregenManager.debugStep("prepare_batches", stepStart, "batchCount=" + this.batches.size() + ", chunkCount=" + unique.size());
            this.totalBlocks = Math.max(1L, (long)this.metadata.getTotalBlocks());
            PregenManager.debug("\u6a21\u677f:{} | \u603b\u65b9\u5757:{} | \u9884\u671f\u6784\u5efa\u65f6\u957f:{}s", this.templateId, this.totalBlocks, Math.max(1L, (long)Math.ceil((double)this.totalBlocks / BLOCKS_PER_SECOND)));
            PregenManager.logInfo("Pregen | \u5f00\u59cb\u4efb\u52a1 | \u6a21\u677f:{} | \u653e\u7f6e\u70b9:{} | \u6279\u6b21\u6570:{} | \u533a\u5757\u6570:{}", this.templateId, PregenManager.formatPos(this.placement), this.batches.size(), unique.size());
            return true;
        }

        void tick(ServerLevel level) {
            if (this.finished || this.cancelled) {
                return;
            }
            if (this.waitingForBuildingCompletion) {
                this.monitorBuildingTask(level);
                return;
            }
            if (!this.drivePreheat(level)) {
                return;
            }
            if (!this.ensureAnchorChunkReady(level)) {
                return;
            }
            if (!this.ensurePlacementComputed(level)) {
                return;
            }
            this.createBuildingTask(level);
        }

        void cancel(String reason, boolean cancelOutstanding) {
            if (this.finished) {
                return;
            }
            this.cancelled = true;
            this.outcomeReason = reason;
            if (this.waitingForBuildingCompletion && this.buildingTaskId != null && cancelOutstanding && PregenManager.this.cachedLevel != null) {
                BuildingTaskManager.get(PregenManager.this.cachedLevel).cancelTask(PregenManager.this.cachedLevel, this.buildingTaskId);
            }
            this.waitingForBuildingCompletion = false;
            this.missingStatusTicks = 0;
            if (cancelOutstanding) {
                this.cancelOutstandingChunks(reason, true);
            }
            this.releaseAnchorChunkTicket();
            this.finished = true;
            long totalDurationMs = (System.nanoTime() - this.startNano) / 1000000L;
            PregenManager.logInfo("Pregen | \u4efb\u52a1\u53d6\u6d88 | \u6a21\u677f:{} | \u4f4d\u7f6e:{} | \u8017\u65f6:{}ms | \u539f\u56e0:{}", this.templateId, PregenManager.formatPos(this.placement), totalDurationMs, reason);
            this.cleanupRegisteredBuilding();
        }

        boolean isFinished() {
            return this.finished;
        }

        boolean wasSuccessful() {
            return this.success;
        }

        boolean isCancelled() {
            return this.cancelled;
        }

        private void startNextBatch(ServerLevel level) {
            if (this.preheatStartNano < 0L) {
                this.preheatStartNano = System.nanoTime();
            }
            List<ChunkPos> batch = this.batches.get(this.currentBatchIndex);
            this.currentBatchStartNano = System.nanoTime();
            PregenManager.debug("\u6279\u6b21\u9884\u70ed\u5f00\u59cb | \u6a21\u677f:{} | \u6279\u6b21:{}/{} | \u533a\u5757:{}", this.templateId, this.currentBatchIndex + 1, this.batches.size(), PregenManager.formatChunks(batch));
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(batch.size());
            for (ChunkPos pos : batch) {
                this.outstandingChunks.add(pos.m_45588_());
                PregenManager.this.chunkManager.requestChunkWarmLikePlayer(pos.f_45578_, pos.f_45579_);
                futures.add(PregenManager.this.chunkManager.whenWarm(pos.f_45578_, pos.f_45579_));
            }
            this.currentBatchFuture = CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
            this.currentBatchError = null;
            this.currentBatchFuture.whenComplete((ignored, throwable) -> {
                if (throwable != null) {
                    this.currentBatchError = throwable;
                } else {
                    for (ChunkPos pos : batch) {
                        this.outstandingChunks.remove(pos.m_45588_());
                    }
                }
            });
        }

        private boolean drivePreheat(ServerLevel level) {
            long batchElapsedMs;
            if (this.preheatCompleted) {
                return true;
            }
            if (this.currentBatchFuture == null && this.currentBatchIndex == 0 && this.batches.isEmpty()) {
                PregenManager.debug("\u4efb\u52a1\u65e0\u533a\u5757\u9884\u70ed\uff0c\u76f4\u63a5\u8fdb\u5165\u5efa\u9020\u4efb\u52a1 | \u6a21\u677f:{} | \u4f4d\u7f6e:{}", this.templateId, PregenManager.formatPos(this.placement));
                this.preheatDurationMs = 0L;
                this.preheatCompleted = true;
                return true;
            }
            if (this.currentBatchFuture == null && this.currentBatchIndex < this.batches.size()) {
                this.startNextBatch(level);
                return false;
            }
            if (this.currentBatchFuture == null || !this.currentBatchFuture.isDone()) {
                return false;
            }
            long l = batchElapsedMs = this.currentBatchStartNano > 0L ? Math.max(0L, (System.nanoTime() - this.currentBatchStartNano) / 1000000L) : -1L;
            if (this.currentBatchFuture.isCompletedExceptionally()) {
                Throwable error = this.currentBatchError;
                if (error == null) {
                    try {
                        this.currentBatchFuture.join();
                    }
                    catch (CompletionException ex) {
                        error = ex.getCause() != null ? ex.getCause() : ex;
                    }
                }
                this.fail("\u533a\u5757\u9884\u70ed\u5931\u8d25: " + (error != null ? error.getMessage() : "\u672a\u77e5\u539f\u56e0"));
                this.cancelOutstandingChunks("\u9884\u70ed\u5931\u8d25", true);
                return false;
            }
            PregenManager.debug("\u6279\u6b21\u9884\u70ed\u5b8c\u6210 | \u6a21\u677f:{} | \u6279\u6b21:{}/{} | \u8017\u65f6:{}ms", this.templateId, this.currentBatchIndex + 1, this.batches.size(), batchElapsedMs >= 0L ? batchElapsedMs : -1L);
            this.currentBatchFuture = null;
            this.currentBatchError = null;
            this.currentBatchStartNano = 0L;
            ++this.currentBatchIndex;
            if (this.currentBatchIndex >= this.batches.size()) {
                long end = System.nanoTime();
                if (this.preheatStartNano > 0L) {
                    this.preheatDurationMs = (end - this.preheatStartNano) / 1000000L;
                }
                this.preheatCompleted = true;
                return true;
            }
            return false;
        }

        private boolean ensureAnchorChunkReady(ServerLevel level) {
            if (this.anchorChunkReady) {
                return true;
            }
            if (this.anchorChunk == null) {
                return false;
            }
            if (!this.anchorTicketHeld) {
                PregenManager.this.chunkManager.requestPersistentChunk(this.anchorChunk.f_45578_, this.anchorChunk.f_45579_);
                this.anchorTicketHeld = true;
                PregenManager.logInfo("Pregen | \u6240\u6709\u9884\u70ed\u6279\u6b21\u52a0\u8f7d\u5b8c\u6210\uff0c\u7ed9\u951a\u70b9({},{})\u6dfb\u52a0\u6301\u4e45\u7968\u636e", this.anchorChunk.f_45578_, this.anchorChunk.f_45579_);
            }
            if (level.m_7726_().m_7131_(this.anchorChunk.f_45578_, this.anchorChunk.f_45579_) == null) {
                return false;
            }
            this.anchorChunkReady = true;
            PregenManager.logInfo("Pregen | \u951a\u70b9\u533a\u5757\u5df2\u52a0\u8f7d | \u533a\u5757:({},{})", this.anchorChunk.f_45578_, this.anchorChunk.f_45579_);
            return true;
        }

        private void releaseAnchorChunkTicket() {
            if (!this.anchorTicketHeld || this.anchorChunk == null || PregenManager.this.chunkManager == null) {
                return;
            }
            PregenManager.this.chunkManager.releasePersistentChunk(this.anchorChunk.f_45578_, this.anchorChunk.f_45579_);
            this.anchorTicketHeld = false;
            this.anchorChunkReady = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean ensurePlacementComputed(ServerLevel level) {
            BlockPos computed;
            if (this.placement == null) {
                this.fail("\u653e\u7f6e\u4f4d\u7f6e\u65e0\u6548");
                this.cancelOutstandingChunks("\u653e\u7f6e\u4f4d\u7f6e\u65e0\u6548", true);
                return false;
            }
            if (this.placement.m_123342_() != Integer.MIN_VALUE) {
                return true;
            }
            long stepStart = System.nanoTime();
            BlockPos basePos = this.candidate.position().getPosition();
            try {
                computed = StructurePlacementHelper.computePlacementPosition(level, basePos, this.metadata, this.candidate.position().getGenerationSeed());
            }
            finally {
                this.releaseAnchorChunkTicket();
            }
            PregenManager.debugStep("compute_placement", stepStart, "result=" + PregenManager.formatPos(computed));
            if (computed == null) {
                this.fail("\u653e\u7f6e\u4f4d\u7f6e\u65e0\u6548");
                this.cancelOutstandingChunks("\u653e\u7f6e\u4f4d\u7f6e\u65e0\u6548", true);
                return false;
            }
            this.placement = computed;
            return true;
        }

        private void createBuildingTask(ServerLevel level) {
            double seconds = (double)this.totalBlocks / BLOCKS_PER_SECOND;
            long buildTimeSeconds = Math.max(1L, (long)Math.ceil(seconds));
            long creationStart = System.nanoTime();
            BuildTemplateService.BuildResult result = BuildTemplateService.createBuildingTaskWithResult(level, this.template, this.templateId, this.placement, this.candidate.position().getRotation(), 0.0f, buildTimeSeconds, "SYSTEM", this.template.getConnectionLayerDepth() > 0, true);
            long creationDurationMs = (System.nanoTime() - creationStart) / 1000000L;
            PregenManager.debug("\u6267\u884c\u5efa\u9020\u4efb\u52a1\u521b\u5efa | \u6a21\u677f:{} | \u8017\u65f6:{}ms | \u76ee\u6807\u65f6\u957f:{}s", this.templateId, creationDurationMs, buildTimeSeconds);
            if (!result.isSuccess()) {
                String details = result.details != null ? result.details : result.failureReason.name();
                this.fail("\u5efa\u9020\u4efb\u52a1\u521b\u5efa\u5931\u8d25: " + details);
                this.cancelOutstandingChunks("\u5efa\u9020\u4efb\u52a1\u5931\u8d25", true);
                return;
            }
            this.buildingTaskId = result.taskId;
            this.registeredBuildingId = result.buildingId;
            this.expectedBuildSeconds = buildTimeSeconds;
            this.waitingForBuildingCompletion = true;
            this.buildingWaitStartNano = System.nanoTime();
            this.missingStatusTicks = 0;
            this.lastKnownProgress = 0.0f;
            this.lastLoggedProgressPercent = -1;
            this.outcomeReason = "\u5efa\u9020\u8fdb\u884c\u4e2d";
            long totalDurationMs = (System.nanoTime() - this.startNano) / 1000000L;
            PregenManager.debug("\u5efa\u9020\u4efb\u52a1\u521b\u5efa\u6210\u529f | \u6a21\u677f:{} | \u603b\u8017\u65f6:{}ms | \u9884\u70ed:{}ms | \u5efa\u9020ID:{} | \u76ee\u6807\u65f6\u957f:{}s", this.templateId, totalDurationMs, this.preheatDurationMs, this.buildingTaskId, this.expectedBuildSeconds);
            PregenManager.logInfo("Pregen | \u5efa\u9020\u4efb\u52a1\u5df2\u521b\u5efa\uff0c\u7b49\u5f85\u5b8c\u6210 | \u6a21\u677f:{} | \u653e\u7f6e\u70b9:{} | \u9884\u70ed:{}ms | \u7d2f\u8ba1\u8017\u65f6:{}ms | \u5efa\u9020ID:{} | \u76ee\u6807\u65f6\u957f:{}s", this.templateId, PregenManager.formatPos(this.placement), this.preheatDurationMs, totalDurationMs, this.buildingTaskId, this.expectedBuildSeconds);
        }

        private void monitorBuildingTask(ServerLevel level) {
            if (this.buildingTaskId == null) {
                this.fail("\u5efa\u9020\u4efb\u52a1ID\u7f3a\u5931");
                return;
            }
            BuildingTaskManager taskManager = BuildingTaskManager.get(level);
            BuildingTaskManager.BuildingTaskStatus status = taskManager.getTaskStatus(this.buildingTaskId);
            if (status == null) {
                ++this.missingStatusTicks;
                if (this.missingStatusTicks > 200) {
                    this.fail("\u5efa\u9020\u4efb\u52a1\u72b6\u6001\u7f3a\u5931");
                } else if (this.missingStatusTicks == 1 || this.missingStatusTicks % 40 == 0) {
                    PregenManager.debug("\u5efa\u9020\u4efb\u52a1\u72b6\u6001\u6682\u4e0d\u53ef\u7528 | \u6a21\u677f:{} | \u5efa\u9020ID:{} | missingTicks:{}", this.templateId, this.buildingTaskId, this.missingStatusTicks);
                }
                return;
            }
            this.missingStatusTicks = 0;
            this.lastKnownProgress = status.progress;
            if (status.failed) {
                String details = status.failureReason != null ? status.failureReason : "\u672a\u77e5\u539f\u56e0";
                this.fail("\u5efa\u9020\u4efb\u52a1\u5931\u8d25: " + details);
                return;
            }
            int progressPercent = Mth.m_14045_((int)Math.round(status.progress * 100.0f), (int)0, (int)100);
            if (progressPercent != this.lastLoggedProgressPercent) {
                this.lastLoggedProgressPercent = progressPercent;
            }
            if (!status.completed) {
                return;
            }
            this.waitingForBuildingCompletion = false;
            this.success = true;
            this.finished = true;
            this.outcomeReason = "\u5efa\u9020\u5b8c\u6210";
            this.registeredBuildingId = null;
            this.persistGridHandled();
            long buildDurationMs = this.buildingWaitStartNano > 0L ? Math.max(0L, (System.nanoTime() - this.buildingWaitStartNano) / 1000000L) : 0L;
            long totalDurationMs = Math.max(0L, (System.nanoTime() - this.startNano) / 1000000L);
            PregenManager.debug("\u5efa\u9020\u4efb\u52a1\u5b8c\u6210 | \u6a21\u677f:{} | \u5efa\u9020\u8017\u65f6:{}ms | \u603b\u8017\u65f6:{}ms | \u5efa\u9020ID:{} | \u6210\u529f:{} | \u5931\u8d25:{}", this.templateId, buildDurationMs, totalDurationMs, this.buildingTaskId, status.placedBlocks, status.failedBlocks);
            PregenManager.logInfo("Pregen | \u4efb\u52a1\u5b8c\u6210\uff08\u5efa\u9020\u5b8c\u6210\uff09| \u6a21\u677f:{} | \u653e\u7f6e\u70b9:{} | \u9884\u70ed:{}ms | \u5efa\u9020\u7b49\u5f85:{}ms | \u603b\u8017\u65f6:{}ms | \u5efa\u9020ID:{} | \u76ee\u6807\u65f6\u957f:{}s", this.templateId, PregenManager.formatPos(this.placement), this.preheatDurationMs, buildDurationMs, totalDurationMs, this.buildingTaskId, this.expectedBuildSeconds);
        }

        private void fail(String reason) {
            if (this.finished) {
                return;
            }
            this.success = false;
            this.finished = true;
            this.waitingForBuildingCompletion = false;
            this.releaseAnchorChunkTicket();
            this.missingStatusTicks = 0;
            this.outcomeReason = reason;
            this.cleanupRegisteredBuilding();
            long totalDurationMs = (System.nanoTime() - this.startNano) / 1000000L;
            PregenManager.debug("\u4efb\u52a1\u6807\u8bb0\u5931\u8d25 | \u6a21\u677f:{} | \u603b\u8017\u65f6:{}ms | \u539f\u56e0:{}", this.templateId, totalDurationMs, reason);
            PregenManager.logWarn("Pregen | \u4efb\u52a1\u5931\u8d25 | \u6a21\u677f:{} | \u4f4d\u7f6e:{} | \u8017\u65f6:{}ms | \u539f\u56e0:{}", this.templateId, PregenManager.formatPos(this.placement), totalDurationMs, reason);
            this.persistGridHandled();
        }

        private void cancelOutstandingChunks(String reason, boolean clearWarmState) {
            if (this.outstandingChunks.isEmpty()) {
                return;
            }
            ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>(this.outstandingChunks.size());
            LongIterator longIterator = this.outstandingChunks.iterator();
            while (longIterator.hasNext()) {
                long key = (Long)longIterator.next();
                chunks.add(new ChunkPos(key));
            }
            this.outstandingChunks.clear();
            if (clearWarmState) {
                PregenManager.this.chunkManager.cancelWarm(chunks, reason);
            }
            PregenManager.debug("\u53d6\u6d88\u9884\u70ed\u533a\u5757 | \u6a21\u677f:{} | \u533a\u5757:{} | \u539f\u56e0:{}", this.templateId, PregenManager.formatChunks(chunks), reason);
        }

        private void persistGridHandled() {
            if (PregenManager.this.knownEmptyGrids.add(this.candidate.gridKey())) {
                PregenManager.this.m_77762_();
            }
        }

        String getSummary() {
            String phase;
            if (this.cancelled) {
                phase = "\u5df2\u53d6\u6d88";
            } else if (this.finished) {
                phase = this.success ? "\u5df2\u5b8c\u6210" : "\u5df2\u5931\u8d25";
            } else if (this.waitingForBuildingCompletion) {
                int percent = Mth.m_14045_((int)Math.round(this.lastKnownProgress * 100.0f), (int)0, (int)100);
                phase = String.format(Locale.ROOT, "\u5efa\u9020\u4e2d %d%%", percent);
            } else {
                phase = this.currentBatchFuture != null ? String.format(Locale.ROOT, "\u9884\u70ed\u4e2d %d/%d", this.currentBatchIndex + 1, this.batches.size()) : (this.currentBatchIndex < this.batches.size() ? String.format(Locale.ROOT, "\u9884\u70ed\u6392\u961f %d/%d", this.currentBatchIndex + 1, this.batches.size()) : "\u5efa\u9020\u4efb\u52a1\u51c6\u5907");
            }
            String placementStr = PregenManager.formatPos(this.placement);
            String taskIdStr = this.buildingTaskId != null ? this.buildingTaskId.toString() : "-";
            return String.format(Locale.ROOT, "\u6a21\u677f:%s | \u7f51\u683c:(%d,%d) | \u9636\u6bb5:%s | \u4f4d\u7f6e:%s | \u5efa\u9020ID:%s", this.templateId, this.candidate.gridX(), this.candidate.gridZ(), phase, placementStr, taskIdStr);
        }

        private void cleanupRegisteredBuilding() {
            if (this.registeredBuildingId == null || PregenManager.this.cachedLevel == null) {
                return;
            }
            PlacedBuildingRegistry registry = PlacedBuildingRegistry.get(PregenManager.this.cachedLevel);
            PlacedBuilding building = registry.getBuilding(this.registeredBuildingId);
            if (building != null && registry.removeBuilding(this.registeredBuildingId)) {
                ServerPacketHandler.broadcastBuildingUpdate(PregenManager.this.cachedLevel, building, true);
            }
            this.registeredBuildingId = null;
        }
    }

    private record Candidate(long gridKey, int gridX, int gridZ, StructurePosition position, double distanceSqr) {
    }
}

