/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.generation;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import ydmsama.hundred_years_war.main.template.HywStructureTemplate;
import ydmsama.hundred_years_war.main.template.TemplateMetadata;

public final class StructurePlacementHelper {
    private static final BlockPos[] SURFACE_SEARCH_OFFSETS = new BlockPos[]{new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, 1), new BlockPos(0, 0, -1), new BlockPos(1, 0, 1)};

    private StructurePlacementHelper() {
    }

    public static BlockPos computePlacementPosition(ServerLevel level, BlockPos basePos, TemplateMetadata metadata, long generationSeed) {
        if (metadata == null) {
            return basePos;
        }
        int x = basePos.m_123341_();
        int z = basePos.m_123343_();
        int minY = metadata.getMinGenerationHeight();
        int maxY = metadata.getMaxGenerationHeight();
        int worldMinY = level.m_141937_();
        int worldMaxY = level.m_151558_() - 1;
        boolean wantsSurface = metadata.isGenerateOnSurface();
        boolean wantsWaterSurface = metadata.isGenerateOnWaterSurface();
        boolean wantsUnderwater = metadata.isGenerateUnderwater();
        if (wantsSurface || wantsWaterSurface || wantsUnderwater) {
            BlockPos solidSurfacePos;
            BlockPos worldSurfacePos = StructurePlacementHelper.getHeightmapPosition(level, Heightmap.Types.WORLD_SURFACE, x, z, worldMinY, worldMaxY);
            BlockState worldSurfaceState = level.m_8055_(worldSurfacePos);
            boolean worldSurfaceIsWater = worldSurfaceState.m_60819_().m_205070_(FluidTags.f_13131_);
            if (worldSurfaceIsWater) {
                BlockPos oceanFloorPos;
                if (wantsWaterSurface && StructurePlacementHelper.isWithinAllowedRange(worldSurfacePos.m_123342_(), minY, maxY, worldMinY, worldMaxY)) {
                    return worldSurfacePos;
                }
                if (wantsUnderwater && StructurePlacementHelper.isWithinAllowedRange((oceanFloorPos = StructurePlacementHelper.getHeightmapPosition(level, Heightmap.Types.OCEAN_FLOOR, x, z, worldMinY, worldMaxY)).m_123342_(), minY, maxY, worldMinY, worldMaxY)) {
                    return oceanFloorPos;
                }
            } else if (wantsSurface && (solidSurfacePos = StructurePlacementHelper.findSurfacePositionAvoidingWood(level, x, z, minY, maxY, worldMinY, worldMaxY)) != null) {
                return solidSurfacePos;
            }
            return null;
        }
        Random random = new Random(generationSeed);
        int restrictedMinY = Math.max(minY, worldMinY);
        int restrictedMaxY = Math.min(maxY, worldMaxY);
        if (restrictedMaxY <= restrictedMinY) {
            return new BlockPos(x, restrictedMinY, z);
        }
        int y = random.nextInt(restrictedMaxY - restrictedMinY + 1) + restrictedMinY;
        return new BlockPos(x, y, z);
    }

    private static BlockPos getHeightmapPosition(ServerLevel level, Heightmap.Types type, int x, int z, int worldMinY, int worldMaxY) {
        int height = level.m_6924_(type, x, z) - 1;
        int clamped = Mth.m_14045_((int)height, (int)worldMinY, (int)worldMaxY);
        return new BlockPos(x, clamped, z);
    }

    private static boolean isWithinAllowedRange(int y, int minY, int maxY, int worldMinY, int worldMaxY) {
        int lowerBound = Math.max(minY, worldMinY);
        int upperBound = Math.min(maxY, worldMaxY);
        return y >= lowerBound && y <= upperBound;
    }

    private static BlockPos findSurfacePositionAvoidingWood(ServerLevel level, int baseX, int baseZ, int minY, int maxY, int worldMinY, int worldMaxY) {
        BlockPos initial = StructurePlacementHelper.getHeightmapPosition(level, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, baseX, baseZ, worldMinY, worldMaxY);
        if (!StructurePlacementHelper.isWithinAllowedRange(initial.m_123342_(), minY, maxY, worldMinY, worldMaxY)) {
            return null;
        }
        if (!StructurePlacementHelper.isWoodSurface(level.m_8055_(initial))) {
            return initial;
        }
        int attempts = 0;
        for (BlockPos offset : SURFACE_SEARCH_OFFSETS) {
            BlockPos solidPos;
            int offsetZ;
            if (attempts >= 5) break;
            ++attempts;
            int offsetX = baseX + offset.m_123341_();
            BlockPos worldSurfacePos = StructurePlacementHelper.getHeightmapPosition(level, Heightmap.Types.WORLD_SURFACE, offsetX, offsetZ = baseZ + offset.m_123343_(), worldMinY, worldMaxY);
            if (level.m_8055_(worldSurfacePos).m_60819_().m_205070_(FluidTags.f_13131_) || !StructurePlacementHelper.isWithinAllowedRange((solidPos = StructurePlacementHelper.getHeightmapPosition(level, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, offsetX, offsetZ, worldMinY, worldMaxY)).m_123342_(), minY, maxY, worldMinY, worldMaxY) || StructurePlacementHelper.isWoodSurface(level.m_8055_(solidPos))) continue;
            return solidPos;
        }
        return null;
    }

    private static boolean isWoodSurface(BlockState state) {
        return state.m_204336_(BlockTags.f_13106_);
    }

    public static List<ChunkPos> computeChunkCoverage(int anchorX, int anchorZ, int rotation, TemplateMetadata metadata, HywStructureTemplate template) {
        if (template != null) {
            return StructurePlacementHelper.computeChunkCoverage(anchorX, anchorZ, rotation, template);
        }
        return StructurePlacementHelper.computeFallbackCoverage(anchorX, anchorZ, metadata);
    }

    public static List<ChunkPos> computeChunkCoverage(int anchorX, int anchorZ, int rotation, HywStructureTemplate template) {
        int totalRotation = StructurePlacementHelper.computeTotalRotation(template, rotation);
        BlockPos size = template.getSize();
        BlockPos entrance = template.getEntrance() != null ? template.getEntrance() : BlockPos.f_121853_;
        BlockPos placement = new BlockPos(anchorX, 0, anchorZ);
        BlockPos transformedEntrance = StructurePlacementHelper.rotatePosition(entrance, size, totalRotation);
        BlockPos offset = placement.m_121996_((Vec3i)transformedEntrance);
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (int xEdge = 0; xEdge <= 1; ++xEdge) {
            for (int zEdge = 0; zEdge <= 1; ++zEdge) {
                BlockPos corner = new BlockPos(xEdge == 0 ? 0 : size.m_123341_() - 1, 0, zEdge == 0 ? 0 : size.m_123343_() - 1);
                BlockPos transformedCorner = StructurePlacementHelper.rotatePosition(corner, size, totalRotation);
                BlockPos worldCorner = offset.m_121955_((Vec3i)transformedCorner);
                minX = Math.min(minX, worldCorner.m_123341_());
                maxX = Math.max(maxX, worldCorner.m_123341_());
                minZ = Math.min(minZ, worldCorner.m_123343_());
                maxZ = Math.max(maxZ, worldCorner.m_123343_());
            }
        }
        int minChunkX = Math.floorDiv(minX, 16);
        int maxChunkX = Math.floorDiv(maxX, 16);
        int minChunkZ = Math.floorDiv(minZ, 16);
        int maxChunkZ = Math.floorDiv(maxZ, 16);
        ArrayList<ChunkPos> result = new ArrayList<ChunkPos>();
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                result.add(new ChunkPos(x, z));
            }
        }
        return result;
    }

    public static List<ChunkPos> computeFallbackCoverage(int anchorX, int anchorZ, TemplateMetadata metadata) {
        if (metadata == null) {
            return List.of();
        }
        int radius = Math.max(metadata.getSize().m_123341_(), metadata.getSize().m_123343_());
        int minX = anchorX - radius;
        int maxX = anchorX + radius;
        int minZ = anchorZ - radius;
        int maxZ = anchorZ + radius;
        int minChunkX = Math.floorDiv(minX, 16);
        int maxChunkX = Math.floorDiv(maxX, 16);
        int minChunkZ = Math.floorDiv(minZ, 16);
        int maxChunkZ = Math.floorDiv(maxZ, 16);
        ArrayList<ChunkPos> result = new ArrayList<ChunkPos>();
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                result.add(new ChunkPos(x, z));
            }
        }
        return result;
    }

    public static int computeTotalRotation(HywStructureTemplate template, int baseRotation) {
        float savedYaw = template.getPlayerYaw();
        float relativeYaw = StructurePlacementHelper.normalizeAngle(savedYaw);
        int relativeRotation = Math.round(relativeYaw / 90.0f) * 90;
        relativeRotation = StructurePlacementHelper.normalizeRotation(relativeRotation);
        return StructurePlacementHelper.normalizeRotation(baseRotation + relativeRotation);
    }

    public static BlockPos rotatePosition(BlockPos pos, BlockPos size, int rotation) {
        int normalized = StructurePlacementHelper.normalizeRotation(rotation);
        int resultX = pos.m_123341_();
        int resultZ = pos.m_123343_();
        int currentSizeX = size.m_123341_();
        int currentSizeZ = size.m_123343_();
        for (int i = 0; i < normalized / 90; ++i) {
            int newX = resultZ;
            int newZ = currentSizeX - 1 - resultX;
            resultX = newX;
            resultZ = newZ;
            int temp = currentSizeX;
            currentSizeX = currentSizeZ;
            currentSizeZ = temp;
        }
        return new BlockPos(resultX, pos.m_123342_(), resultZ);
    }

    public static float normalizeAngle(float angle) {
        while (angle > 180.0f) {
            angle -= 360.0f;
        }
        while (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public static int normalizeRotation(int rotation) {
        if ((rotation %= 360) < 0) {
            rotation += 360;
        }
        return rotation;
    }
}

