/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.generation;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import ydmsama.hundred_years_war.main.generation.StructureLocationGenerator;
import ydmsama.hundred_years_war.main.generation.StructurePosition;
import ydmsama.hundred_years_war.main.generation.StructurePositionProvider;
import ydmsama.hundred_years_war.main.generation.StructurePositionProviderRegistry;

public final class StructurePositionResolver {
    private final StructureLocationGenerator defaultGenerator;
    private final List<StructurePositionProvider> providers;

    public StructurePositionResolver(ServerLevel level) {
        this.defaultGenerator = new StructureLocationGenerator(level);
        ArrayList<StructurePositionProvider> providerList = new ArrayList<StructurePositionProvider>();
        providerList.addAll(StructurePositionProviderRegistry.createProviders(level));
        providerList.add(this.defaultGenerator::getStructureAt);
        this.providers = List.copyOf(providerList);
    }

    public StructurePosition getStructureAt(int gridX, int gridZ) {
        for (StructurePositionProvider provider : this.providers) {
            StructurePosition position = provider.getStructureAt(gridX, gridZ);
            if (position == null) continue;
            return position;
        }
        return null;
    }

    public StructureLocationGenerator getDefaultGenerator() {
        return this.defaultGenerator;
    }
}

