/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BuildingToolItem
extends Item {
    public BuildingToolItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (world.f_46443_) {
            try {
                Class<?> handlerClass = Class.forName("ydmsama.hundred_years_war.client.handler.BuildingToolClientHandler");
                handlerClass.getMethod("handleRightClick", ItemStack.class).invoke(null, stack);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.f_46443_);
    }

    public static Mode getMode(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Mode")) {
            return Mode.valueOf(stack.m_41783_().m_128461_("Mode"));
        }
        return Mode.SAVE;
    }

    public static void setMode(ItemStack stack, Mode mode) {
        stack.m_41784_().m_128359_("Mode", mode.name());
    }

    public static SaveState getSaveState(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("SaveState")) {
            return SaveState.valueOf(stack.m_41783_().m_128461_("SaveState"));
        }
        return SaveState.NONE;
    }

    public static void setSaveState(ItemStack stack, SaveState state) {
        stack.m_41784_().m_128359_("SaveState", state.name());
    }

    public static void resetSaveState(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128473_("SaveState");
        tag.m_128473_("FirstPos");
        tag.m_128473_("SecondPos");
        tag.m_128473_("EntrancePos");
    }

    public static FillState getFillState(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("FillState")) {
            return FillState.valueOf(stack.m_41783_().m_128461_("FillState"));
        }
        return FillState.NONE;
    }

    public static void setFillState(ItemStack stack, FillState state) {
        stack.m_41784_().m_128359_("FillState", state.name());
    }

    public static void resetFillState(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128473_("FillState");
        tag.m_128473_("FillFirstPos");
        tag.m_128473_("FillSecondPos");
    }

    public static BlockPos getFirstPos(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("FirstPos")) {
            return BlockPos.m_122022_((long)stack.m_41783_().m_128454_("FirstPos"));
        }
        return null;
    }

    public static void setFirstPos(ItemStack stack, BlockPos pos) {
        if (pos != null) {
            stack.m_41784_().m_128356_("FirstPos", pos.m_121878_());
        } else {
            CompoundTag tag = stack.m_41783_();
            if (tag != null) {
                tag.m_128473_("FirstPos");
            }
        }
    }

    public static BlockPos getSecondPos(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("SecondPos")) {
            return BlockPos.m_122022_((long)stack.m_41783_().m_128454_("SecondPos"));
        }
        return null;
    }

    public static void setSecondPos(ItemStack stack, BlockPos pos) {
        if (pos != null) {
            stack.m_41784_().m_128356_("SecondPos", pos.m_121878_());
        } else {
            CompoundTag tag = stack.m_41783_();
            if (tag != null) {
                tag.m_128473_("SecondPos");
            }
        }
    }

    public static BlockPos getEntrancePos(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("EntrancePos")) {
            return BlockPos.m_122022_((long)stack.m_41783_().m_128454_("EntrancePos"));
        }
        return null;
    }

    public static void setEntrancePos(ItemStack stack, BlockPos pos) {
        if (pos != null) {
            stack.m_41784_().m_128356_("EntrancePos", pos.m_121878_());
        } else {
            CompoundTag tag = stack.m_41783_();
            if (tag != null) {
                tag.m_128473_("EntrancePos");
            }
        }
    }

    public static BlockPos getFillFirstPos(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("FillFirstPos")) {
            return BlockPos.m_122022_((long)stack.m_41783_().m_128454_("FillFirstPos"));
        }
        return null;
    }

    public static void setFillFirstPos(ItemStack stack, BlockPos pos) {
        if (pos != null) {
            stack.m_41784_().m_128356_("FillFirstPos", pos.m_121878_());
        } else {
            CompoundTag tag = stack.m_41783_();
            if (tag != null) {
                tag.m_128473_("FillFirstPos");
            }
        }
    }

    public static BlockPos getFillSecondPos(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("FillSecondPos")) {
            return BlockPos.m_122022_((long)stack.m_41783_().m_128454_("FillSecondPos"));
        }
        return null;
    }

    public static void setFillSecondPos(ItemStack stack, BlockPos pos) {
        if (pos != null) {
            stack.m_41784_().m_128356_("FillSecondPos", pos.m_121878_());
        } else {
            CompoundTag tag = stack.m_41783_();
            if (tag != null) {
                tag.m_128473_("FillSecondPos");
            }
        }
    }

    public static String getSelectedTemplate(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("SelectedTemplate")) {
            return stack.m_41783_().m_128461_("SelectedTemplate");
        }
        return null;
    }

    public static void setSelectedTemplate(ItemStack stack, String template) {
        stack.m_41784_().m_128359_("SelectedTemplate", template);
    }

    public static void switchMode(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof BuildingToolItem) {
            Mode currentMode = BuildingToolItem.getMode(stack);
            Mode newMode = currentMode.next();
            BuildingToolItem.setMode(stack, newMode);
            if (newMode == Mode.SAVE) {
                BuildingToolItem.resetSaveState(stack);
                BuildingToolItem.resetFillState(stack);
                CompoundTag tag = stack.m_41784_();
                tag.m_128473_("SelectedTemplate");
            } else if (newMode == Mode.PLACE) {
                BuildingToolItem.resetSaveState(stack);
                BuildingToolItem.resetFillState(stack);
                CompoundTag tag = stack.m_41784_();
                tag.m_128473_("SelectedTemplate");
            } else if (newMode == Mode.FILL) {
                BuildingToolItem.resetSaveState(stack);
                BuildingToolItem.resetFillState(stack);
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        Mode mode = BuildingToolItem.getMode(stack);
        tooltip.add((Component)Component.m_237115_((String)"item.hundred_years_war.building_tool.tooltip.current_mode").m_130940_(ChatFormatting.GRAY).m_7220_((Component)mode.getDisplayName().m_130940_(mode.getColor())));
        tooltip.add((Component)Component.m_237113_((String)"[").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237115_((String)"item.hundred_years_war.building_tool.tooltip.middle_click").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"] ").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237115_((String)"item.hundred_years_war.building_tool.tooltip.switch_mode_text").m_130940_(ChatFormatting.DARK_GRAY)));
        if (mode == Mode.SAVE) {
            BlockPos entrance;
            BlockPos second;
            tooltip.add((Component)Component.m_237113_((String)"[").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237115_((String)"item.hundred_years_war.building_tool.tooltip.key_v").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"] ").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237115_((String)"item.hundred_years_war.building_tool.tooltip.use_save_text").m_130940_(ChatFormatting.DARK_GRAY)));
            tooltip.add((Component)Component.m_237113_((String)"[").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237115_((String)"item.hundred_years_war.building_tool.tooltip.right_click").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"] ").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237115_((String)"item.hundred_years_war.building_tool.tooltip.undo_action").m_130940_(ChatFormatting.DARK_GRAY)));
            SaveState state = BuildingToolItem.getSaveState(stack);
            String stateKey = BuildingToolItem.getSaveStateKey(state);
            tooltip.add((Component)Component.m_237115_((String)stateKey).m_130940_(ChatFormatting.AQUA));
            BlockPos first = BuildingToolItem.getFirstPos(stack);
            if (first != null) {
                tooltip.add((Component)Component.m_237110_((String)"item.hundred_years_war.building_tool.tooltip.first_pos", (Object[])new Object[]{first.m_123344_()}).m_130940_(ChatFormatting.GREEN));
            }
            if ((second = BuildingToolItem.getSecondPos(stack)) != null) {
                tooltip.add((Component)Component.m_237110_((String)"item.hundred_years_war.building_tool.tooltip.second_pos", (Object[])new Object[]{second.m_123344_()}).m_130940_(ChatFormatting.RED));
            }
            if ((entrance = BuildingToolItem.getEntrancePos(stack)) != null) {
                tooltip.add((Component)Component.m_237110_((String)"item.hundred_years_war.building_tool.tooltip.entrance_pos", (Object[])new Object[]{entrance.m_123344_()}).m_130940_(ChatFormatting.BLUE));
            }
        } else if (mode == Mode.PLACE) {
            tooltip.add((Component)Component.m_237113_((String)"[").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237115_((String)"item.hundred_years_war.building_tool.tooltip.key_v").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"] ").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237115_((String)"item.hundred_years_war.building_tool.tooltip.use_place_text").m_130940_(ChatFormatting.DARK_GRAY)));
            tooltip.add((Component)Component.m_237113_((String)"[").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237115_((String)"item.hundred_years_war.building_tool.tooltip.right_click").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"] ").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237115_((String)"item.hundred_years_war.building_tool.tooltip.open_template_list").m_130940_(ChatFormatting.DARK_GRAY)));
            String template = BuildingToolItem.getSelectedTemplate(stack);
            if (template != null && !template.isEmpty()) {
                tooltip.add((Component)Component.m_237110_((String)"item.hundred_years_war.building_tool.tooltip.selected_template", (Object[])new Object[]{template}).m_130940_(ChatFormatting.GOLD));
            }
        } else if (mode == Mode.FILL) {
            BlockPos secondFill;
            tooltip.add((Component)Component.m_237113_((String)"[").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237115_((String)"item.hundred_years_war.building_tool.tooltip.key_v").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"] ").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237115_((String)"item.hundred_years_war.building_tool.tooltip.use_fill_text").m_130940_(ChatFormatting.DARK_GRAY)));
            tooltip.add((Component)Component.m_237113_((String)"[").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237115_((String)"item.hundred_years_war.building_tool.tooltip.key_v").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)" x3] ").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237115_((String)"item.hundred_years_war.building_tool.tooltip.open_fill_ui").m_130940_(ChatFormatting.DARK_GRAY)));
            tooltip.add((Component)Component.m_237113_((String)"[").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237115_((String)"item.hundred_years_war.building_tool.tooltip.right_click").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"] ").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237115_((String)"item.hundred_years_war.building_tool.tooltip.fill_undo").m_130940_(ChatFormatting.DARK_GRAY)));
            FillState fillState = BuildingToolItem.getFillState(stack);
            tooltip.add((Component)Component.m_237115_((String)BuildingToolItem.getFillStateKey(fillState)).m_130940_(ChatFormatting.GOLD));
            BlockPos firstFill = BuildingToolItem.getFillFirstPos(stack);
            if (firstFill != null) {
                tooltip.add((Component)Component.m_237110_((String)"item.hundred_years_war.building_tool.tooltip.fill_first_pos", (Object[])new Object[]{firstFill.m_123344_()}).m_130940_(ChatFormatting.YELLOW));
            }
            if ((secondFill = BuildingToolItem.getFillSecondPos(stack)) != null) {
                tooltip.add((Component)Component.m_237110_((String)"item.hundred_years_war.building_tool.tooltip.fill_second_pos", (Object[])new Object[]{secondFill.m_123344_()}).m_130940_(ChatFormatting.YELLOW));
            }
        }
    }

    private static String getSaveStateKey(SaveState state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case SaveState.NONE -> "item.hundred_years_war.building_tool.tooltip.save.none";
            case SaveState.FIRST_POS -> "item.hundred_years_war.building_tool.tooltip.save.first_pos";
            case SaveState.SECOND_POS -> "item.hundred_years_war.building_tool.tooltip.save.second_pos";
            case SaveState.READY_TO_SAVE -> "item.hundred_years_war.building_tool.tooltip.save.entrance";
        };
    }

    private static String getFillStateKey(FillState state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case FillState.NONE -> "item.hundred_years_war.building_tool.tooltip.fill.none";
            case FillState.FIRST_POS -> "item.hundred_years_war.building_tool.tooltip.fill.first_pos_state";
            case FillState.SECOND_POS -> "item.hundred_years_war.building_tool.tooltip.fill.second_pos_state";
        };
    }

    public boolean m_5812_(ItemStack stack) {
        return BuildingToolItem.getSaveState(stack) == SaveState.READY_TO_SAVE;
    }

    public static enum Mode {
        SAVE("item.hundred_years_war.building_tool.mode.save", ChatFormatting.GREEN),
        PLACE("item.hundred_years_war.building_tool.mode.place", ChatFormatting.BLUE),
        FILL("item.hundred_years_war.building_tool.mode.fill", ChatFormatting.GOLD);

        private final String translationKey;
        private final ChatFormatting color;

        private Mode(String translationKey, ChatFormatting color) {
            this.translationKey = translationKey;
            this.color = color;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public MutableComponent getDisplayName() {
            return Component.m_237115_((String)this.translationKey);
        }

        public ChatFormatting getColor() {
            return this.color;
        }

        public Mode next() {
            return Mode.values()[(this.ordinal() + 1) % Mode.values().length];
        }
    }

    public static enum SaveState {
        NONE,
        FIRST_POS,
        SECOND_POS,
        READY_TO_SAVE;

    }

    public static enum FillState {
        NONE,
        FIRST_POS,
        SECOND_POS;

    }
}

