/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.mixins;

import java.util.List;
import java.util.Objects;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ydmsama.hundred_years_war.main.entity.entities.PriestEntity;
import ydmsama.hundred_years_war.main.registry.HywAttributes;

@Mixin(value={ThrownPotion.class})
public class ThrownPotionMixin {
    private static final double SPLASH_RANGE = 4.0;
    private static final double SPLASH_RANGE_SQ = 16.0;

    @Inject(method={"applySplash"}, at={@At(value="HEAD")}, cancellable=true)
    private void onApplySplash(List<MobEffectInstance> effects, Entity entity, CallbackInfo ci) {
        ThrownPotion thrownPotion = (ThrownPotion)this;
        Entity owner = thrownPotion.m_19749_();
        if (!(owner instanceof PriestEntity)) {
            return;
        }
        PriestEntity priest = (PriestEntity)owner;
        boolean hasHealingEffect = effects.stream().anyMatch(effect -> effect.m_19544_() == MobEffects.f_19601_);
        if (!hasHealingEffect) {
            return;
        }
        AABB effectArea = thrownPotion.m_20191_().m_82377_(4.0, 2.0, 4.0);
        List nearbyEntities = thrownPotion.m_9236_().m_45976_(LivingEntity.class, effectArea);
        for (LivingEntity target : nearbyEntities) {
            double distanceSq;
            if (!target.m_5801_() || (distanceSq = target.m_20280_((Entity)thrownPotion)) >= 16.0 || !priest.isValidTarget(target)) continue;
            float healingAmount = (float)Objects.requireNonNull(priest.m_21051_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get())).m_22135_();
            target.m_5634_(healingAmount);
        }
        ci.cancel();
    }
}

