/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.utils.AttackStrategy;
import ydmsama.hundred_years_war.main.item.CommandStaffItem;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

public class AttackStrategyUpdatePacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "attack_strategy_update");
    private final String strategyId;

    public AttackStrategyUpdatePacket(String strategyId) {
        this.strategyId = strategyId;
    }

    public static void encode(AttackStrategyUpdatePacket packet, FriendlyByteBuf buf) {
        buf.m_130070_(packet.strategyId);
    }

    public static AttackStrategyUpdatePacket decode(FriendlyByteBuf buf) {
        return new AttackStrategyUpdatePacket(buf.m_130277_());
    }

    private static void handlePacket(ServerPlayer player, AttackStrategyUpdatePacket packet) {
        AttackStrategy strategy = AttackStrategy.fromId(packet.strategyId);
        SelectionSystem.Selection selection = SelectionSystem.getSelection(player);
        HashSet<BaseCombatEntity> targets = new HashSet<BaseCombatEntity>();
        if (selection != null) {
            selection.refreshEntities();
            targets.addAll(selection.getEntities());
        }
        AttackStrategyUpdatePacket.addCommandStaffEntities(player, targets);
        for (BaseCombatEntity entity : targets) {
            entity.setAttackStrategy(strategy);
        }
    }

    private static void addCommandStaffEntities(ServerPlayer player, Set<BaseCombatEntity> targets) {
        for (ItemStack staff : AttackStrategyUpdatePacket.getHeldCommandStaff(player)) {
            CompoundTag nbt = staff.m_41783_();
            if (nbt == null || !nbt.m_128425_("TeamEntityUUIDs", 9)) continue;
            ListTag uuidList = nbt.m_128437_("TeamEntityUUIDs", 8);
            for (int i = 0; i < uuidList.size(); ++i) {
                try {
                    BaseCombatEntity combatEntity;
                    UUID entityUUID = UUID.fromString(uuidList.m_128778_(i));
                    Entity entity = player.m_284548_().m_8791_(entityUUID);
                    if (!(entity instanceof BaseCombatEntity) || !(combatEntity = (BaseCombatEntity)entity).m_6084_() || !ServerRelationHelper.hasControlOver((Player)player, (Entity)combatEntity)) continue;
                    targets.add(combatEntity);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    private static List<ItemStack> getHeldCommandStaff(ServerPlayer player) {
        ArrayList<ItemStack> staffs = new ArrayList<ItemStack>();
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        if (mainHand.m_41720_() instanceof CommandStaffItem) {
            staffs.add(mainHand);
        }
        if (offHand.m_41720_() instanceof CommandStaffItem) {
            staffs.add(offHand);
        }
        return staffs;
    }

    public static void handle(AttackStrategyUpdatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                AttackStrategyUpdatePacket.handlePacket(player, packet);
            }
        });
        context.setPacketHandled(true);
    }
}

