/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.blocks.ModBlocks;
import ydmsama.hundred_years_war.main.item.BuildingToolItem;
import ydmsama.hundred_years_war.main.template.BuildTemplateService;
import ydmsama.hundred_years_war.main.template.HywStructureTemplate;
import ydmsama.hundred_years_war.main.template.TemplateManager;

public class BuildingToolActionPacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "building_tool_action");
    private final Action action;
    private final BlockPos pos;
    private final String data;

    public BuildingToolActionPacket(Action action, BlockPos pos, String data) {
        this.action = action;
        this.pos = pos;
        this.data = data;
    }

    public static void encode(BuildingToolActionPacket packet, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)packet.action);
        buf.writeBoolean(packet.pos != null);
        if (packet.pos != null) {
            buf.m_130064_(packet.pos);
        }
        buf.writeBoolean(packet.data != null);
        if (packet.data != null) {
            buf.m_130070_(packet.data);
        }
    }

    public static BuildingToolActionPacket decode(FriendlyByteBuf buf) {
        Action action = (Action)buf.m_130066_(Action.class);
        BlockPos pos = buf.readBoolean() ? buf.m_130135_() : null;
        String data = buf.readBoolean() ? buf.m_130277_() : null;
        return new BuildingToolActionPacket(action, pos, data);
    }

    public static void handle(BuildingToolActionPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                BuildingToolActionPacket.handlePacket(player, packet.action, packet.pos, packet.data);
            }
        });
        context.setPacketHandled(true);
    }

    public static void handlePacket(ServerPlayer player, Action action, BlockPos pos, String data) {
        ItemStack mainHand = player.m_21205_();
        if (!(mainHand.m_41720_() instanceof BuildingToolItem)) {
            return;
        }
        switch (action) {
            case SWITCH_MODE: {
                BuildingToolItem.switchMode(mainHand);
                break;
            }
            case SET_FIRST_POS: {
                if (pos == null) break;
                BuildingToolItem.setFirstPos(mainHand, pos);
                BuildingToolItem.setSaveState(mainHand, BuildingToolItem.SaveState.FIRST_POS);
                break;
            }
            case SET_SECOND_POS: {
                if (pos == null) break;
                BuildingToolItem.setSecondPos(mainHand, pos);
                BuildingToolItem.setSaveState(mainHand, BuildingToolItem.SaveState.SECOND_POS);
                break;
            }
            case SET_ENTRANCE_POS: {
                if (pos == null) break;
                BuildingToolItem.setEntrancePos(mainHand, pos);
                BuildingToolItem.setSaveState(mainHand, BuildingToolItem.SaveState.READY_TO_SAVE);
                break;
            }
            case SET_FILL_FIRST_POS: {
                if (pos == null) break;
                BuildingToolItem.setFillFirstPos(mainHand, pos);
                BuildingToolItem.setFillSecondPos(mainHand, null);
                BuildingToolItem.setFillState(mainHand, BuildingToolItem.FillState.FIRST_POS);
                break;
            }
            case SET_FILL_SECOND_POS: {
                if (pos == null) break;
                BuildingToolItem.setFillSecondPos(mainHand, pos);
                BuildingToolItem.setFillState(mainHand, BuildingToolItem.FillState.SECOND_POS);
                break;
            }
            case SAVE_BUILDING: {
                Level level;
                if (data == null || !((level = player.m_9236_()) instanceof ServerLevel)) break;
                ServerLevel serverLevel = (ServerLevel)level;
                BlockPos firstPos = BuildingToolItem.getFirstPos(mainHand);
                BlockPos secondPos = BuildingToolItem.getSecondPos(mainHand);
                BlockPos entrancePos = BuildingToolItem.getEntrancePos(mainHand);
                if (firstPos == null || secondPos == null) break;
                String[] mainParts = data.split("\\|", 2);
                String name = mainParts[0];
                String category = "";
                String description = "";
                boolean includeEntities = false;
                boolean includeBlockData = true;
                boolean enableGeneration = false;
                int generationWeight = 1;
                int connectionLayerDepth = 10;
                int minGenerationHeight = -64;
                int maxGenerationHeight = 320;
                boolean generateOnSurface = false;
                LinkedHashMap<String, JsonElement> customAttributes = new LinkedHashMap<String, JsonElement>();
                if (mainParts.length > 1) {
                    try {
                        JsonObject settingsJson = JsonParser.parseString((String)mainParts[1]).getAsJsonObject();
                        if (settingsJson.has("category") && settingsJson.get("category").isJsonPrimitive()) {
                            category = settingsJson.get("category").getAsString();
                        }
                        if (settingsJson.has("description") && settingsJson.get("description").isJsonPrimitive()) {
                            description = settingsJson.get("description").getAsString();
                        }
                        if (settingsJson.has("includeEntities")) {
                            includeEntities = settingsJson.get("includeEntities").getAsBoolean();
                        }
                        if (settingsJson.has("includeBlockData")) {
                            includeBlockData = settingsJson.get("includeBlockData").getAsBoolean();
                        }
                        if (settingsJson.has("enableGeneration")) {
                            enableGeneration = settingsJson.get("enableGeneration").getAsBoolean();
                        }
                        if (settingsJson.has("generationWeight")) {
                            generationWeight = BuildingToolActionPacket.safeGetInt(settingsJson, "generationWeight", 1);
                        }
                        if (settingsJson.has("connectionLayerDepth")) {
                            connectionLayerDepth = BuildingToolActionPacket.safeGetInt(settingsJson, "connectionLayerDepth", 10);
                        }
                        if (settingsJson.has("minGenerationHeight")) {
                            minGenerationHeight = BuildingToolActionPacket.safeGetInt(settingsJson, "minGenerationHeight", -64);
                        }
                        if (settingsJson.has("maxGenerationHeight")) {
                            maxGenerationHeight = BuildingToolActionPacket.safeGetInt(settingsJson, "maxGenerationHeight", 320);
                        }
                        if (settingsJson.has("generateOnSurface")) {
                            generateOnSurface = settingsJson.get("generateOnSurface").getAsBoolean();
                        }
                        if (settingsJson.has("customAttributes") && settingsJson.get("customAttributes").isJsonObject()) {
                            JsonObject attributesJson = settingsJson.getAsJsonObject("customAttributes");
                            for (Map.Entry entry : attributesJson.entrySet()) {
                                customAttributes.put((String)entry.getKey(), ((JsonElement)entry.getValue()).deepCopy());
                            }
                        }
                    }
                    catch (JsonSyntaxException | IllegalStateException settingsJson) {
                        // empty catch block
                    }
                }
                String author = player.m_7755_().getString();
                float playerYaw = player.m_146908_();
                player.m_5661_((Component)Component.m_237110_((String)"message.hundred_years_war.building_save_started", (Object[])new Object[]{name}), true);
                int[] lastPercentage = new int[]{-1};
                CompletableFuture<HywStructureTemplate> templateFuture = BuildTemplateService.buildTemplateWithProgress(serverLevel, firstPos, secondPos, entrancePos, name, category, description, author, playerYaw, includeEntities, includeBlockData, enableGeneration, generationWeight, connectionLayerDepth, minGenerationHeight, maxGenerationHeight, generateOnSurface, customAttributes, (current, total) -> {
                    int percentage = (int)((double)current * 100.0 / (double)total);
                    if (percentage != lastPercentage[0]) {
                        lastPercentage[0] = percentage;
                        player.m_20194_().execute(() -> player.m_5661_((Component)Component.m_237110_((String)"message.hundred_years_war.building_save_progress", (Object[])new Object[]{name, percentage}), true));
                    }
                });
                ((CompletableFuture)templateFuture.thenAccept(template -> player.m_20194_().execute(() -> {
                    String templateId = name.toLowerCase().replaceAll("[^a-z0-9_]", "_") + "_" + System.currentTimeMillis();
                    boolean saved = TemplateManager.getInstance().saveTemplate((HywStructureTemplate)template, templateId);
                    if (saved) {
                        player.m_5661_((Component)Component.m_237110_((String)"message.hundred_years_war.building_saved", (Object[])new Object[]{name}), true);
                        BuildingToolItem.setSaveState(mainHand, BuildingToolItem.SaveState.NONE);
                        BuildingToolItem.setFirstPos(mainHand, null);
                        BuildingToolItem.setSecondPos(mainHand, null);
                        BuildingToolItem.setEntrancePos(mainHand, null);
                    } else {
                        player.m_5661_((Component)Component.m_237110_((String)"message.hundred_years_war.building_save_failed", (Object[])new Object[]{name}), true);
                    }
                }))).exceptionally(e -> {
                    player.m_20194_().execute(() -> player.m_5661_((Component)Component.m_237110_((String)"message.hundred_years_war.building_save_error", (Object[])new Object[]{e.getMessage()}), true));
                    return null;
                });
                break;
            }
            case PLACE_BUILDING: {
                String playerName;
                Level firstPos;
                if (pos == null || data == null || !((firstPos = player.m_9236_()) instanceof ServerLevel)) break;
                ServerLevel serverLevel = (ServerLevel)firstPos;
                String[] parts = data.split("\\|");
                String templateId = parts[0];
                int rotation = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
                long buildTimeSeconds = parts.length > 2 ? Long.parseLong(parts[2]) : 0L;
                boolean generateConnectionLayer = parts.length > 3 && Boolean.parseBoolean(parts[3]);
                boolean terrainCheck = parts.length > 4 && Boolean.parseBoolean(parts[4]);
                float currentPlayerYaw = player.m_146908_();
                BuildTemplateService.BuildResult result = BuildTemplateService.createBuildingTaskWithResult(serverLevel, templateId, pos, rotation, currentPlayerYaw, buildTimeSeconds, playerName = player.m_7755_().getString(), generateConnectionLayer, terrainCheck);
                if (result.isSuccess()) {
                    String templateName;
                    HywStructureTemplate template2 = TemplateManager.getInstance().loadTemplate(templateId);
                    String string = templateName = template2 != null ? template2.getName() : templateId;
                    if (buildTimeSeconds == 0L) {
                        player.m_213846_((Component)Component.m_237110_((String)"message.hundred_years_war.building_started_instant", (Object[])new Object[]{templateName}));
                        break;
                    }
                    player.m_213846_((Component)Component.m_237110_((String)"message.hundred_years_war.building_started", (Object[])new Object[]{templateName, buildTimeSeconds}));
                    break;
                }
                MutableComponent errorMessage = switch (result.failureReason) {
                    default -> throw new IncompatibleClassChangeError();
                    case BuildTemplateService.BuildResult.FailureReason.TEMPLATE_NOT_FOUND -> Component.m_237110_((String)"message.hundred_years_war.template_not_found", (Object[])new Object[]{templateId});
                    case BuildTemplateService.BuildResult.FailureReason.BUILDING_COLLISION -> Component.m_237110_((String)"message.hundred_years_war.building_collision", (Object[])new Object[]{result.details});
                    case BuildTemplateService.BuildResult.FailureReason.INVALID_POSITION -> Component.m_237115_((String)"message.hundred_years_war.invalid_position");
                    case BuildTemplateService.BuildResult.FailureReason.TERRAIN_TOO_UNEVEN -> Component.m_237115_((String)"message.hundred_years_war.terrain_too_uneven");
                };
                player.m_213846_((Component)errorMessage);
                break;
            }
            case APPLY_PLACEHOLDER_OPERATION: {
                Level parts = player.m_9236_();
                if (!(parts instanceof ServerLevel)) break;
                ServerLevel serverLevel = (ServerLevel)parts;
                if (data == null) break;
                BlockPos firstPos = BuildingToolItem.getFillFirstPos(mainHand);
                BlockPos secondPos = BuildingToolItem.getFillSecondPos(mainHand);
                if (firstPos == null || secondPos == null) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.hundred_years_war.building_tool.fill_missing_selection"), true);
                    break;
                }
                boolean fillOperation = "fill".equalsIgnoreCase(data);
                boolean clearOperation = "clear".equalsIgnoreCase(data);
                if (!fillOperation && !clearOperation) break;
                int minX = Math.min(firstPos.m_123341_(), secondPos.m_123341_());
                int minY = Math.min(firstPos.m_123342_(), secondPos.m_123342_());
                int minZ = Math.min(firstPos.m_123343_(), secondPos.m_123343_());
                int maxX = Math.max(firstPos.m_123341_(), secondPos.m_123341_());
                int maxY = Math.max(firstPos.m_123342_(), secondPos.m_123342_());
                int maxZ = Math.max(firstPos.m_123343_(), secondPos.m_123343_());
                int affected = 0;
                for (BlockPos target : BlockPos.m_121976_((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ)) {
                    BlockState currentState = serverLevel.m_8055_(target);
                    if (fillOperation) {
                        if (!currentState.m_60795_() || !serverLevel.m_7731_(target, ((Block)ModBlocks.PLACEHOLDER_BLOCK.get()).m_49966_(), 3)) continue;
                        ++affected;
                        continue;
                    }
                    if (!currentState.m_60713_((Block)ModBlocks.PLACEHOLDER_BLOCK.get()) || !serverLevel.m_7731_(target, Blocks.f_50016_.m_49966_(), 3)) continue;
                    ++affected;
                }
                BuildingToolItem.resetFillState(mainHand);
                String messageKey = fillOperation ? "message.hundred_years_war.building_tool.fill_applied" : "message.hundred_years_war.building_tool.fill_cleared";
                player.m_5661_((Component)Component.m_237110_((String)messageKey, (Object[])new Object[]{affected}), true);
                break;
            }
            case UNDO_FILL_FIRST_POS: {
                BuildingToolItem.setFillFirstPos(mainHand, null);
                BuildingToolItem.setFillSecondPos(mainHand, null);
                BuildingToolItem.setFillState(mainHand, BuildingToolItem.FillState.NONE);
                break;
            }
            case UNDO_FILL_SECOND_POS: {
                BuildingToolItem.setFillSecondPos(mainHand, null);
                BuildingToolItem.setFillState(mainHand, BuildingToolItem.FillState.FIRST_POS);
                break;
            }
            case RESET_FILL_SELECTION: {
                BuildingToolItem.resetFillState(mainHand);
                break;
            }
            case UNDO_FIRST_POS: {
                BuildingToolItem.setFirstPos(mainHand, null);
                BuildingToolItem.setSaveState(mainHand, BuildingToolItem.SaveState.NONE);
                break;
            }
            case UNDO_SECOND_POS: {
                BuildingToolItem.setSecondPos(mainHand, null);
                BuildingToolItem.setSaveState(mainHand, BuildingToolItem.SaveState.FIRST_POS);
                break;
            }
            case UNDO_ENTRANCE_POS: {
                BuildingToolItem.setEntrancePos(mainHand, null);
                BuildingToolItem.setSaveState(mainHand, BuildingToolItem.SaveState.SECOND_POS);
            }
        }
    }

    private static int safeGetInt(JsonObject json, String key, int defaultValue) {
        try {
            return json.get(key).getAsInt();
        }
        catch (Exception ignored) {
            return defaultValue;
        }
    }

    public static enum Action {
        SWITCH_MODE,
        SET_FIRST_POS,
        SET_SECOND_POS,
        SET_ENTRANCE_POS,
        SET_FILL_FIRST_POS,
        SET_FILL_SECOND_POS,
        SAVE_BUILDING,
        PLACE_BUILDING,
        UNDO_FIRST_POS,
        UNDO_SECOND_POS,
        UNDO_ENTRANCE_POS,
        APPLY_PLACEHOLDER_OPERATION,
        UNDO_FILL_FIRST_POS,
        UNDO_FILL_SECOND_POS,
        RESET_FILL_SELECTION;

    }
}

