/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.utils.CreativeModeSettings;

public class CreativeSettingsUpdatePacket {
    private final boolean summonFriendly;
    private final boolean controlAllUnits;

    public CreativeSettingsUpdatePacket(boolean summonFriendly, boolean controlAllUnits) {
        this.summonFriendly = summonFriendly;
        this.controlAllUnits = controlAllUnits;
    }

    public static void encode(CreativeSettingsUpdatePacket packet, FriendlyByteBuf buf) {
        buf.writeBoolean(packet.summonFriendly);
        buf.writeBoolean(packet.controlAllUnits);
    }

    public static CreativeSettingsUpdatePacket decode(FriendlyByteBuf buf) {
        boolean summonFriendly = buf.readBoolean();
        boolean controlAllUnits = buf.readBoolean();
        return new CreativeSettingsUpdatePacket(summonFriendly, controlAllUnits);
    }

    public static void handle(CreativeSettingsUpdatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                CreativeSettingsUpdatePacket.handlePacket(player, packet);
            }
        });
        context.setPacketHandled(true);
    }

    public static void handlePacket(ServerPlayer player, CreativeSettingsUpdatePacket packet) {
        if (!player.m_7500_()) {
            return;
        }
        CreativeModeSettings.setSummonFriendly((Player)player, packet.summonFriendly);
        CreativeModeSettings.setControlAllUnits((Player)player, packet.controlAllUnits);
    }

    public boolean isSummonFriendly() {
        return this.summonFriendly;
    }

    public boolean isControlAllUnits() {
        return this.controlAllUnits;
    }
}

