/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.blocks.workstation.FishingWorkstationBlockEntity;

public class FishingWorkstationRangePacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "fishing_workstation_range");
    private final BlockPos pos;
    private final int rangeLeft;
    private final int rangeRight;
    private final int rangeUp;
    private final int rangeDown;
    private final boolean showRange;

    public FishingWorkstationRangePacket(BlockPos pos, int rangeLeft, int rangeRight, int rangeUp, int rangeDown, boolean showRange) {
        this.pos = pos;
        this.rangeLeft = rangeLeft;
        this.rangeRight = rangeRight;
        this.rangeUp = rangeUp;
        this.rangeDown = rangeDown;
        this.showRange = showRange;
    }

    public static void encode(FishingWorkstationRangePacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
        buf.writeInt(packet.rangeLeft);
        buf.writeInt(packet.rangeRight);
        buf.writeInt(packet.rangeUp);
        buf.writeInt(packet.rangeDown);
        buf.writeBoolean(packet.showRange);
    }

    public static FishingWorkstationRangePacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        int rangeLeft = buf.readInt();
        int rangeRight = buf.readInt();
        int rangeUp = buf.readInt();
        int rangeDown = buf.readInt();
        boolean showRange = buf.readBoolean();
        return new FishingWorkstationRangePacket(pos, rangeLeft, rangeRight, rangeUp, rangeDown, showRange);
    }

    public static void handle(FishingWorkstationRangePacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                FishingWorkstationRangePacket.handlePacket(player, packet);
            }
        });
        context.setPacketHandled(true);
    }

    public static void handlePacket(ServerPlayer player, FishingWorkstationRangePacket packet) {
        player.f_8924_.execute(() -> {
            if (!player.m_36326_()) {
                return;
            }
            double distanceSq = player.m_20275_((double)packet.pos.m_123341_() + 0.5, (double)packet.pos.m_123342_() + 0.5, (double)packet.pos.m_123343_() + 0.5);
            if (distanceSq > 64.0) {
                return;
            }
            BlockEntity blockEntity = player.m_9236_().m_7702_(packet.pos);
            if (blockEntity instanceof FishingWorkstationBlockEntity) {
                FishingWorkstationBlockEntity fishingWorkstation = (FishingWorkstationBlockEntity)blockEntity;
                fishingWorkstation.setWorkRangeLeft(packet.rangeLeft);
                fishingWorkstation.setWorkRangeRight(packet.rangeRight);
                fishingWorkstation.setWorkRangeUp(packet.rangeUp);
                fishingWorkstation.setWorkRangeDown(packet.rangeDown);
                fishingWorkstation.setShowRange(packet.showRange);
            }
        });
    }
}

