/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.utils.FormationManager;
import ydmsama.hundred_years_war.main.entity.utils.PathingTaskManagerRegistry;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;

public class MoveCommandPacket {
    private final BlockHitResult hitResult;
    private final boolean queueMode;
    private final boolean formationMode;
    private final String formationType;

    public MoveCommandPacket(BlockHitResult hitResult, boolean queueMode, boolean formationMode, String formationType) {
        this.hitResult = hitResult;
        this.queueMode = queueMode;
        this.formationMode = formationMode;
        this.formationType = formationType;
    }

    public MoveCommandPacket(BlockHitResult hitResult, boolean queueMode, boolean formationMode) {
        this(hitResult, queueMode, formationMode, "loose");
    }

    public static void encode(MoveCommandPacket packet, FriendlyByteBuf buf) {
        buf.m_130062_(packet.hitResult);
        buf.writeBoolean(packet.queueMode);
        buf.writeBoolean(packet.formationMode);
        buf.m_130070_(packet.formationType);
    }

    public static MoveCommandPacket decode(FriendlyByteBuf buf) {
        BlockHitResult hitResult = buf.m_130283_();
        boolean queueMode = buf.readBoolean();
        boolean formationMode = buf.readBoolean();
        String formationType = buf.m_130277_();
        return new MoveCommandPacket(hitResult, queueMode, formationMode, formationType);
    }

    public static void handlePacket(ServerPlayer player, MoveCommandPacket packet) {
        BlockHitResult hitResult = packet.hitResult;
        if (hitResult.m_6662_() == HitResult.Type.BLOCK || hitResult.m_6662_() == HitResult.Type.MISS) {
            BlockPos targetPos;
            BlockHitResult blockHitResult = hitResult;
            if (hitResult.m_6662_() == HitResult.Type.MISS) {
                Vec3 hitLocation = blockHitResult.m_82450_();
                targetPos = new BlockPos((int)hitLocation.f_82479_, (int)hitLocation.f_82480_, (int)hitLocation.f_82481_);
            } else {
                targetPos = blockHitResult.m_82425_();
            }
            SelectionSystem.Selection selection = SelectionSystem.getSelection(player);
            selection.refreshEntities();
            List<BaseCombatEntity> entities = selection.getEntities();
            if (!packet.queueMode) {
                PathingTaskManagerRegistry.getInstance().clearTasksForEntities(entities);
            }
            for (BaseCombatEntity entity : entities) {
                entity.clearPatrolPoints();
            }
            if (packet.formationMode) {
                FormationManager.formMove(entities, targetPos, 1, packet.queueMode, packet.formationType);
            } else {
                FormationManager.move(entities, targetPos, 1, packet.queueMode);
            }
        }
    }

    public static void handle(MoveCommandPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                MoveCommandPacket.handlePacket(player, packet);
            }
        });
        context.setPacketHandled(true);
    }
}

