/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;

public class OpenTransportOrderAckPacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "open_transport_order_ack");
    private final UUID requestId;

    public OpenTransportOrderAckPacket(UUID requestId) {
        this.requestId = requestId;
    }

    public static void encode(OpenTransportOrderAckPacket packet, FriendlyByteBuf buf) {
        buf.m_130077_(packet.requestId);
    }

    public static OpenTransportOrderAckPacket decode(FriendlyByteBuf buf) {
        UUID requestId = buf.m_130259_();
        return new OpenTransportOrderAckPacket(requestId);
    }

    public static void handle(OpenTransportOrderAckPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> ServerPacketHandler.handleTransportOrderAck(packet));
        context.setPacketHandled(true);
    }

    public UUID getRequestId() {
        return this.requestId;
    }
}

