/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;

public class OpenWorkstationSyncPacket {
    private final UUID requestId;
    private final BlockPos pos;
    private final WorkstationType type;

    public OpenWorkstationSyncPacket(UUID requestId, BlockPos pos, WorkstationType type) {
        this.requestId = requestId;
        this.pos = pos;
        this.type = type;
    }

    public static void encode(OpenWorkstationSyncPacket packet, FriendlyByteBuf buf) {
        buf.m_130077_(packet.requestId);
        buf.m_130064_(packet.pos);
        buf.m_130068_((Enum)packet.type);
    }

    public static OpenWorkstationSyncPacket decode(FriendlyByteBuf buf) {
        UUID requestId = buf.m_130259_();
        BlockPos pos = buf.m_130135_();
        WorkstationType type = (WorkstationType)buf.m_130066_(WorkstationType.class);
        return new OpenWorkstationSyncPacket(requestId, pos, type);
    }

    public static void handle(OpenWorkstationSyncPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> OpenWorkstationSyncPacket.handlePacket(packet)));
        context.setPacketHandled(true);
    }

    private static void handlePacket(OpenWorkstationSyncPacket packet) {
        ClientPacketHandler.onOpenWorkstationSync(packet);
    }

    public UUID getRequestId() {
        return this.requestId;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public WorkstationType getType() {
        return this.type;
    }

    public static enum WorkstationType {
        FARMING,
        MINING,
        TRANSPORT,
        FISHING,
        LUMBER,
        CRAFTING,
        BREEDING,
        WAREHOUSE,
        SUPPLY_POINT,
        SPAWN_POINT;

    }
}

