/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.template.PlacedBuilding;

public class PlacedBuildingSyncPacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "placed_buildings_sync");
    private final long chunkOrFlag;
    private final boolean isRemoval;
    private final UUID removalBuildingId;
    private final List<BuildingData> buildings;

    public PlacedBuildingSyncPacket(ChunkPos chunkPos, List<PlacedBuilding> buildingList) {
        this.chunkOrFlag = chunkPos.m_45588_();
        this.isRemoval = false;
        this.removalBuildingId = null;
        this.buildings = new ArrayList<BuildingData>();
        for (PlacedBuilding building : buildingList) {
            this.buildings.add(new BuildingData(building));
        }
    }

    public PlacedBuildingSyncPacket(List<PlacedBuilding> buildingList) {
        this.chunkOrFlag = 0L;
        this.isRemoval = false;
        this.removalBuildingId = null;
        this.buildings = new ArrayList<BuildingData>();
        for (PlacedBuilding building : buildingList) {
            this.buildings.add(new BuildingData(building));
        }
    }

    public PlacedBuildingSyncPacket(PlacedBuilding building, boolean isRemoval) {
        this.chunkOrFlag = -1L;
        this.isRemoval = isRemoval;
        if (isRemoval) {
            this.removalBuildingId = building.getBuildingId();
            this.buildings = new ArrayList<BuildingData>();
        } else {
            this.removalBuildingId = null;
            this.buildings = new ArrayList<BuildingData>();
            this.buildings.add(new BuildingData(building));
        }
    }

    public PlacedBuildingSyncPacket(FriendlyByteBuf buf) {
        this.chunkOrFlag = buf.readLong();
        if (this.chunkOrFlag == -1L) {
            this.isRemoval = buf.readBoolean();
            if (this.isRemoval) {
                this.removalBuildingId = buf.m_130259_();
                this.buildings = new ArrayList<BuildingData>();
            } else {
                this.removalBuildingId = null;
                int count = buf.readInt();
                this.buildings = new ArrayList<BuildingData>();
                for (int i = 0; i < count; ++i) {
                    this.buildings.add(new BuildingData(buf));
                }
            }
        } else {
            this.isRemoval = false;
            this.removalBuildingId = null;
            int count = buf.readInt();
            this.buildings = new ArrayList<BuildingData>();
            for (int i = 0; i < count; ++i) {
                this.buildings.add(new BuildingData(buf));
            }
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeLong(this.chunkOrFlag);
        if (this.chunkOrFlag == -1L) {
            buf.writeBoolean(this.isRemoval);
            if (this.isRemoval) {
                buf.m_130077_(this.removalBuildingId);
            } else {
                buf.writeInt(this.buildings.size());
                for (BuildingData building : this.buildings) {
                    building.write(buf);
                }
            }
        } else {
            buf.writeInt(this.buildings.size());
            for (BuildingData building : this.buildings) {
                building.write(buf);
            }
        }
    }

    public static PlacedBuildingSyncPacket decode(FriendlyByteBuf buf) {
        return new PlacedBuildingSyncPacket(buf);
    }

    public long getChunkOrFlag() {
        return this.chunkOrFlag;
    }

    public boolean isRemoval() {
        return this.isRemoval;
    }

    public UUID getRemovalBuildingId() {
        return this.removalBuildingId;
    }

    public List<BuildingData> getBuildings() {
        return this.buildings;
    }

    public static PlacedBuildingSyncPacket createChunkPacket(ChunkPos chunkPos, List<PlacedBuilding> buildings) {
        return new PlacedBuildingSyncPacket(chunkPos, buildings);
    }

    public static PlacedBuildingSyncPacket createAreaPacket(List<PlacedBuilding> buildings) {
        return new PlacedBuildingSyncPacket(buildings);
    }

    public static PlacedBuildingSyncPacket createUpdatePacket(PlacedBuilding building, boolean isRemoval) {
        return new PlacedBuildingSyncPacket(building, isRemoval);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.onPlacedBuildingSync(this)));
        context.get().setPacketHandled(true);
    }

    public static class BuildingData {
        public final UUID buildingId;
        public final String templateName;
        public final BlockPos minPos;
        public final BlockPos maxPos;
        public final BlockPos entrancePos;
        public final String placedBy;

        public BuildingData(PlacedBuilding building) {
            this.buildingId = building.getBuildingId();
            this.templateName = building.getTemplateName();
            this.minPos = building.getMinPos();
            this.maxPos = building.getMaxPos();
            this.entrancePos = building.getEntrancePos();
            this.placedBy = building.getPlacedBy();
        }

        public BuildingData(FriendlyByteBuf buf) {
            this.buildingId = buf.m_130259_();
            this.templateName = buf.m_130136_(Short.MAX_VALUE);
            this.minPos = buf.m_130135_();
            this.maxPos = buf.m_130135_();
            this.entrancePos = buf.m_130135_();
            this.placedBy = buf.m_130136_(Short.MAX_VALUE);
        }

        public void write(FriendlyByteBuf buf) {
            buf.m_130077_(this.buildingId);
            buf.m_130070_(this.templateName != null ? this.templateName : "");
            buf.m_130064_(this.minPos);
            buf.m_130064_(this.maxPos);
            buf.m_130064_(this.entrancePos);
            buf.m_130070_(this.placedBy != null ? this.placedBy : "");
        }
    }
}

