/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.recruitment.PlayerRecruitmentData;

public class PlayerSettingsSyncPacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "player_settings_sync");
    private final String currentFormation;
    private final String lastNonNoneFormation;
    private final String categoryId;
    private final String unitTypeId;
    private final int level;

    public PlayerSettingsSyncPacket(String currentFormation, String lastNonNoneFormation, PlayerRecruitmentData.RecruitmentSelection selection) {
        this.currentFormation = currentFormation;
        this.lastNonNoneFormation = lastNonNoneFormation;
        this.categoryId = selection.getCategoryId();
        this.unitTypeId = selection.getUnitTypeId();
        this.level = selection.getLevel();
    }

    private PlayerSettingsSyncPacket(String currentFormation, String lastNonNoneFormation, String categoryId, String unitTypeId, int level) {
        this.currentFormation = currentFormation;
        this.lastNonNoneFormation = lastNonNoneFormation;
        this.categoryId = categoryId;
        this.unitTypeId = unitTypeId;
        this.level = level;
    }

    public static void encode(PlayerSettingsSyncPacket packet, FriendlyByteBuf buf) {
        buf.m_130070_(packet.currentFormation);
        buf.m_130070_(packet.lastNonNoneFormation);
        buf.m_130070_(packet.categoryId);
        buf.m_130070_(packet.unitTypeId);
        buf.writeInt(packet.level);
    }

    public static PlayerSettingsSyncPacket decode(FriendlyByteBuf buf) {
        String current = buf.m_130277_();
        String last = buf.m_130277_();
        String category = buf.m_130277_();
        String unitType = buf.m_130277_();
        int level = buf.readInt();
        return new PlayerSettingsSyncPacket(current, last, category, unitType, level);
    }

    public static void handle(PlayerSettingsSyncPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> PlayerSettingsSyncPacket.handlePacket(packet)));
        context.setPacketHandled(true);
    }

    private static void handlePacket(PlayerSettingsSyncPacket packet) {
        ClientPacketHandler.onPlayerSettingsSync(packet);
    }

    public String getCurrentFormation() {
        return this.currentFormation;
    }

    public String getLastNonNoneFormation() {
        return this.lastNonNoneFormation;
    }

    public PlayerRecruitmentData.RecruitmentSelection getSelection() {
        PlayerRecruitmentData.RecruitmentSelection selection = new PlayerRecruitmentData.RecruitmentSelection();
        selection.setCategoryId(this.categoryId);
        selection.setUnitTypeId(this.unitTypeId);
        selection.setLevel(this.level);
        return selection;
    }
}

