/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.network.packets.RelationRequestPacket;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;

public class RelationUpdatePacket {
    public static final ResourceLocation RELATION_UPDATE_PACKET_ID = new ResourceLocation("hundred_years_war", "relation_update_packet");
    private final Map<UUID, RelationSystem.RelationType> relationUpdates = new HashMap<UUID, RelationSystem.RelationType>();

    public void addRelationUpdate(UUID targetUUID, RelationSystem.RelationType relationType) {
        this.relationUpdates.put(targetUUID, relationType);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.relationUpdates.size());
        for (Map.Entry<UUID, RelationSystem.RelationType> entry : this.relationUpdates.entrySet()) {
            buf.m_130077_(entry.getKey());
            buf.writeInt(entry.getValue().ordinal());
        }
    }

    public static RelationUpdatePacket decode(FriendlyByteBuf buf) {
        RelationUpdatePacket packet = new RelationUpdatePacket();
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            UUID targetUUID = buf.m_130259_();
            RelationSystem.RelationType relationType = RelationSystem.RelationType.values()[buf.readInt()];
            packet.addRelationUpdate(targetUUID, relationType);
        }
        return packet;
    }

    public static void handleUpdate(ServerPlayer player, RelationUpdatePacket packet) {
        UUID playerUUID = player.m_20148_();
        for (Map.Entry<UUID, RelationSystem.RelationType> entry : packet.relationUpdates.entrySet()) {
            UUID targetUUID = entry.getKey();
            RelationSystem.RelationType relationType = entry.getValue();
            RelationSystem.setRelation(playerUUID, targetUUID, relationType);
            TeamRelationData targetTeamData = RelationSystem.getTeamRelationData(targetUUID);
            if (targetTeamData == null) continue;
            Set<UUID> teamMembers = targetTeamData.getAllMembers().keySet();
            for (UUID memberUUID : teamMembers) {
                RelationSystem.setRelation(playerUUID, memberUUID, relationType);
            }
        }
        RelationRequestPacket.handlePacket(player);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
            if (sender != null) {
                RelationUpdatePacket.handleUpdate(sender, this);
            }
        });
        context.get().setPacketHandled(true);
    }
}

