/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.spawn.SpawnPointBlockEntity;

public class SpawnPointConfigPacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "spawn_point_config");
    private final BlockPos pos;
    private final Mode mode;
    private final ConfigData configData;

    public SpawnPointConfigPacket(BlockPos pos, ConfigData configData) {
        this.pos = pos;
        this.mode = Mode.UPDATE;
        this.configData = configData;
    }

    public SpawnPointConfigPacket(BlockPos pos, Mode mode) {
        this.pos = pos;
        this.mode = mode;
        this.configData = null;
    }

    private SpawnPointConfigPacket(BlockPos pos, Mode mode, ConfigData data) {
        this.pos = pos;
        this.mode = mode;
        this.configData = data;
    }

    public static void encode(SpawnPointConfigPacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
        buf.m_130068_((Enum)packet.mode);
        if (packet.mode == Mode.UPDATE && packet.configData != null) {
            ConfigData data = packet.configData;
            buf.writeDouble(data.activationDistance());
            buf.writeDouble(data.horizontalRange());
            buf.writeDouble(data.verticalRange());
            buf.writeInt(data.perSpawnCount());
            buf.writeInt(data.remainingCount());
            buf.writeInt(data.minInterval());
            buf.writeInt(data.maxInterval());
            buf.writeInt(data.currentInterval());
            buf.writeInt(data.maxActive());
            buf.writeBoolean(data.infinite());
            buf.writeBoolean(data.showActivationRange());
            buf.writeBoolean(data.paused());
            buf.writeBoolean(data.periodicReset());
            buf.writeLong(data.resetInterval());
            buf.writeLong(data.currentResetCooldown());
            buf.m_130130_(data.entries().size());
            for (SpawnEntryData entry : data.entries()) {
                buf.m_130085_(entry.id());
                buf.m_130130_(entry.weight());
                buf.m_130130_(entry.level());
                buf.m_130130_(entry.equipmentLevel());
            }
        }
    }

    public static SpawnPointConfigPacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        Mode mode = (Mode)buf.m_130066_(Mode.class);
        if (mode == Mode.UPDATE) {
            double activation = buf.readDouble();
            double horizontal = buf.readDouble();
            double vertical = buf.readDouble();
            int perSpawn = buf.readInt();
            int remaining = buf.readInt();
            int minInterval = buf.readInt();
            int maxInterval = buf.readInt();
            int currentInterval = buf.readInt();
            int maxActive = buf.readInt();
            boolean infinite = buf.readBoolean();
            boolean showActivationRange = buf.readBoolean();
            boolean paused = buf.readBoolean();
            boolean periodicReset = buf.readBoolean();
            long resetInterval = buf.readLong();
            long currentResetCooldown = buf.readLong();
            int size = buf.m_130242_();
            ArrayList<SpawnEntryData> entries = new ArrayList<SpawnEntryData>();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = buf.m_130281_();
                int weight = buf.m_130242_();
                int level = buf.m_130242_();
                int equipmentLevel = buf.m_130242_();
                entries.add(new SpawnEntryData(id, weight, level, equipmentLevel));
            }
            ConfigData data = new ConfigData(activation, horizontal, vertical, perSpawn, remaining, minInterval, maxInterval, currentInterval, maxActive, infinite, showActivationRange, paused, periodicReset, resetInterval, currentResetCooldown, entries);
            return new SpawnPointConfigPacket(pos, mode, data);
        }
        return new SpawnPointConfigPacket(pos, mode, null);
    }

    private static void handlePacket(ServerPlayer player, SpawnPointConfigPacket packet) {
        ServerLevel level = player.m_284548_();
        BlockEntity blockEntity = level.m_7702_(packet.pos);
        if (!(blockEntity instanceof SpawnPointBlockEntity)) {
            return;
        }
        SpawnPointBlockEntity spawnPoint = (SpawnPointBlockEntity)blockEntity;
        switch (packet.mode) {
            case UPDATE: {
                SpawnPointConfigPacket.applyUpdate(spawnPoint, packet.configData);
                break;
            }
            case SAVE_DEFAULTS: {
                spawnPoint.saveCurrentAsInitial();
                break;
            }
            case RESTORE_DEFAULTS: {
                spawnPoint.restoreSavedState();
            }
        }
    }

    private static void applyUpdate(SpawnPointBlockEntity spawnPoint, ConfigData data) {
        if (data == null) {
            return;
        }
        ArrayList<SpawnPointBlockEntity.SpawnEntry> entries = new ArrayList<SpawnPointBlockEntity.SpawnEntry>();
        for (SpawnEntryData entry : data.entries()) {
            if (entry.weight() <= 0) continue;
            entries.add(new SpawnPointBlockEntity.SpawnEntry(entry.id(), entry.weight(), entry.level(), entry.equipmentLevel()));
        }
        spawnPoint.applyConfiguration(data.activationDistance(), data.horizontalRange(), data.verticalRange(), data.perSpawnCount(), data.remainingCount(), data.minInterval(), data.maxInterval(), data.currentInterval(), data.maxActive(), data.infinite(), data.showActivationRange(), data.paused(), data.periodicReset(), data.resetInterval(), data.currentResetCooldown(), entries);
    }

    public static void handle(SpawnPointConfigPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                SpawnPointConfigPacket.handlePacket(player, packet);
            }
        });
        context.setPacketHandled(true);
    }

    public BlockPos pos() {
        return this.pos;
    }

    public Mode mode() {
        return this.mode;
    }

    public ConfigData configData() {
        return this.configData;
    }

    public static enum Mode {
        UPDATE,
        SAVE_DEFAULTS,
        RESTORE_DEFAULTS;

    }

    public record ConfigData(double activationDistance, double horizontalRange, double verticalRange, int perSpawnCount, int remainingCount, int minInterval, int maxInterval, int currentInterval, int maxActive, boolean infinite, boolean showActivationRange, boolean paused, boolean periodicReset, long resetInterval, long currentResetCooldown, List<SpawnEntryData> entries) {
    }

    public record SpawnEntryData(ResourceLocation id, int weight, int level, int equipmentLevel) {
    }
}

