/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.supply.SupplyPointBlockEntity;

public class SupplyRangeTogglePacket {
    private final BlockPos blockPos;
    private final boolean showRange;

    public SupplyRangeTogglePacket(BlockPos blockPos, boolean showRange) {
        this.blockPos = blockPos;
        this.showRange = showRange;
    }

    public static void encode(SupplyRangeTogglePacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.blockPos);
        buf.writeBoolean(packet.showRange);
    }

    public static SupplyRangeTogglePacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        boolean showRange = buf.readBoolean();
        return new SupplyRangeTogglePacket(pos, showRange);
    }

    public static void handle(SupplyRangeTogglePacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                SupplyRangeTogglePacket.handlePacket(player, packet);
            }
        });
        context.setPacketHandled(true);
    }

    public static void handlePacket(ServerPlayer player, SupplyRangeTogglePacket packet) {
        SupplyPointBlockEntity supplyPoint;
        BlockEntity blockEntity = player.m_9236_().m_7702_(packet.blockPos);
        if (blockEntity instanceof SupplyPointBlockEntity && (supplyPoint = (SupplyPointBlockEntity)blockEntity).m_6542_((Player)player)) {
            supplyPoint.setShowRange(packet.showRange);
            supplyPoint.m_6596_();
            player.m_9236_().m_7260_(packet.blockPos, supplyPoint.m_58900_(), supplyPoint.m_58900_(), 3);
        }
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public boolean isShowRange() {
        return this.showRange;
    }
}

