/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.TeamApplicationsResponsePacket;
import ydmsama.hundred_years_war.main.utils.PlayerRelationData;
import ydmsama.hundred_years_war.main.utils.RelationData;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;

public class TeamApplicationsRequestPacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "team_applications_request");

    public TeamApplicationsRequestPacket() {
    }

    public TeamApplicationsRequestPacket(FriendlyByteBuf buf) {
    }

    public void encode(FriendlyByteBuf buf) {
    }

    public static TeamApplicationsRequestPacket decode(FriendlyByteBuf buf) {
        return new TeamApplicationsRequestPacket(buf);
    }

    public static void handlePacket(ServerPlayer player) {
        UUID playerUUID = player.m_20148_();
        List<UUID> playerTeams = RelationSystem.getPlayerTeams(playerUUID);
        if (!playerTeams.isEmpty()) {
            UUID teamUUID = playerTeams.get(0);
            TeamRelationData teamData = RelationSystem.getTeamRelationData(teamUUID);
            if (teamData != null) {
                TeamRelationData.MemberType memberType = teamData.getMemberType(playerUUID);
                if (memberType == TeamRelationData.MemberType.OWNER || memberType == TeamRelationData.MemberType.ADMIN) {
                    ArrayList<TeamApplicationsResponsePacket.Application> applications = new ArrayList<TeamApplicationsResponsePacket.Application>();
                    for (UUID applicantUUID : teamData.getPendingApplications()) {
                        RelationData relationData = RelationSystem.getRelationData(applicantUUID);
                        String applicantName = relationData instanceof PlayerRelationData ? ((PlayerRelationData)relationData).getPlayerName() : Optional.ofNullable(player.m_20194_().m_6846_().m_11259_(applicantUUID)).map(p -> p.m_7755_().getString()).orElse("Unknown");
                        long applyTime = System.currentTimeMillis();
                        applications.add(new TeamApplicationsResponsePacket.Application(applicantName, applicantUUID, applyTime));
                    }
                    TeamApplicationsResponsePacket responsePacket = new TeamApplicationsResponsePacket(applications);
                    ServerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)responsePacket);
                    System.out.println("\u53d1\u9001\u56e2\u961f\u7533\u8bf7\u5217\u8868\u7ed9\u73a9\u5bb6 " + player.m_7755_().getString() + "\uff0c\u7533\u8bf7\u6570\u91cf: " + applications.size());
                } else {
                    TeamApplicationsRequestPacket.sendEmptyTeamApplicationsResponse(player);
                }
            } else {
                TeamApplicationsRequestPacket.sendEmptyTeamApplicationsResponse(player);
            }
        } else {
            TeamApplicationsRequestPacket.sendEmptyTeamApplicationsResponse(player);
        }
    }

    private static void sendEmptyTeamApplicationsResponse(ServerPlayer player) {
        TeamApplicationsResponsePacket responsePacket = new TeamApplicationsResponsePacket(new ArrayList<TeamApplicationsResponsePacket.Application>());
        ServerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)responsePacket);
    }

    public static void handle(TeamApplicationsRequestPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                TeamApplicationsRequestPacket.handlePacket(player);
            }
        });
        context.setPacketHandled(true);
    }
}

