/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.TeamCreateResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamInfoRequestPacket;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;

public class TeamCreateRequestPacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "team_create");
    private final String teamName;

    public TeamCreateRequestPacket(String teamName) {
        this.teamName = teamName;
    }

    public TeamCreateRequestPacket(FriendlyByteBuf buf) {
        this.teamName = buf.m_130277_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.teamName);
    }

    public static TeamCreateRequestPacket decode(FriendlyByteBuf buf) {
        return new TeamCreateRequestPacket(buf);
    }

    public String getTeamName() {
        return this.teamName;
    }

    public static void handle(TeamCreateRequestPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                TeamCreateRequestPacket.handlePacket(player, packet);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void handlePacket(ServerPlayer player, TeamCreateRequestPacket packet) {
        String teamName = packet.getTeamName();
        if (teamName == null || teamName.trim().isEmpty()) {
            TeamCreateRequestPacket.sendTeamCreateResponse(player, false, "team_name_empty", null);
            return;
        }
        if (teamName.length() < 3) {
            TeamCreateRequestPacket.sendTeamCreateResponse(player, false, "team_name_too_short", null);
            return;
        }
        if (teamName.length() > 20) {
            TeamCreateRequestPacket.sendTeamCreateResponse(player, false, "team_name_too_long", null);
            return;
        }
        boolean nameExists = false;
        for (UUID existingTeamUUID : RelationSystem.getAllTeams().keySet()) {
            if (!RelationSystem.getTeamRelationData(existingTeamUUID).getTeamName().equals(teamName)) continue;
            nameExists = true;
            break;
        }
        if (nameExists) {
            TeamCreateRequestPacket.sendTeamCreateResponse(player, false, "team_name_exists", null);
            player.m_213846_((Component)Component.m_237115_((String)"message.hundred_years_war.team_name_exists"));
            return;
        }
        TeamRelationData teamData = RelationSystem.createTeam(teamName, player.m_20148_());
        if (teamData != null) {
            UUID teamUUID = teamData.getUUID();
            TeamCreateRequestPacket.sendTeamCreateResponse(player, true, "team_create_success", teamUUID);
            player.m_213846_((Component)Component.m_237110_((String)"message.hundred_years_war.team_created", (Object[])new Object[]{teamName}));
        } else {
            TeamCreateRequestPacket.sendTeamCreateResponse(player, false, "team_name_exists", null);
            player.m_213846_((Component)Component.m_237115_((String)"message.hundred_years_war.team_name_exists"));
        }
        TeamInfoRequestPacket.handlePacket(player);
    }

    private static void sendTeamCreateResponse(ServerPlayer player, boolean success, String message, UUID teamUUID) {
        TeamCreateResponsePacket responsePacket = new TeamCreateResponsePacket(success, message, teamUUID);
        ServerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)responsePacket);
    }
}

