/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.network.packets.TeamInfoRequestPacket;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;

public class TeamLeaveRequestPacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "team_leave");
    private final UUID teamUUID;

    public TeamLeaveRequestPacket(UUID teamUUID) {
        this.teamUUID = teamUUID;
    }

    public TeamLeaveRequestPacket(FriendlyByteBuf buf) {
        this.teamUUID = buf.m_130259_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.teamUUID);
    }

    public static TeamLeaveRequestPacket decode(FriendlyByteBuf buf) {
        return new TeamLeaveRequestPacket(buf);
    }

    public UUID getTeamUUID() {
        return this.teamUUID;
    }

    public static void handle(TeamLeaveRequestPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                TeamLeaveRequestPacket.handlePacket(player, packet);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void handlePacket(ServerPlayer player, TeamLeaveRequestPacket packet) {
        UUID playerUUID = player.m_20148_();
        UUID teamUUID = packet.getTeamUUID();
        TeamRelationData teamData = RelationSystem.getTeamRelationData(teamUUID);
        if (teamData == null) {
            player.m_213846_((Component)Component.m_237115_((String)"message.hundred_years_war.team_not_found"));
            return;
        }
        if (!teamData.isMember(playerUUID)) {
            player.m_213846_((Component)Component.m_237115_((String)"message.hundred_years_war.not_in_team"));
            return;
        }
        boolean isOwner = teamData.getMemberType(playerUUID) == TeamRelationData.MemberType.OWNER;
        String teamName = teamData.getTeamName();
        int memberCount = teamData.getAllMembers().size();
        boolean success = RelationSystem.leaveTeam(playerUUID, teamUUID);
        if (success) {
            if (isOwner) {
                if (memberCount == 1) {
                    player.m_213846_((Component)Component.m_237110_((String)"message.hundred_years_war.disbanded_team", (Object[])new Object[]{teamName}));
                } else {
                    player.m_213846_((Component)Component.m_237110_((String)"message.hundred_years_war.left_team_as_owner", (Object[])new Object[]{teamName}));
                    for (UUID memberUUID : teamData.getAllMembers().keySet()) {
                        ServerPlayer member;
                        if (memberUUID.equals(playerUUID) || (member = player.m_20194_().m_6846_().m_11259_(memberUUID)) == null) continue;
                        member.m_213846_((Component)Component.m_237110_((String)"message.hundred_years_war.owner_left", (Object[])new Object[]{player.m_7755_().getString()}));
                    }
                }
            } else {
                player.m_213846_((Component)Component.m_237110_((String)"message.hundred_years_war.left_team", (Object[])new Object[]{teamName}));
                for (UUID memberUUID : teamData.getAllMembers().keySet()) {
                    ServerPlayer member = player.m_20194_().m_6846_().m_11259_(memberUUID);
                    if (member == null) continue;
                    member.m_213846_((Component)Component.m_237110_((String)"message.hundred_years_war.member_left", (Object[])new Object[]{player.m_7755_().getString()}));
                }
            }
        } else {
            player.m_213846_((Component)Component.m_237115_((String)"message.hundred_years_war.leave_failed"));
        }
        TeamInfoRequestPacket.handlePacket(player);
    }
}

