/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.TeamListResponsePacket;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;

public class TeamListRequestPacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "team_list_request");

    public TeamListRequestPacket() {
    }

    public TeamListRequestPacket(FriendlyByteBuf buf) {
    }

    public void encode(FriendlyByteBuf buf) {
    }

    public static TeamListRequestPacket decode(FriendlyByteBuf buf) {
        return new TeamListRequestPacket(buf);
    }

    public static void handle(TeamListRequestPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                TeamListRequestPacket.handlePacket(player);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void handlePacket(ServerPlayer player) {
        TeamListResponsePacket responsePacket = new TeamListResponsePacket();
        Map<UUID, TeamRelationData> allTeams = RelationSystem.getAllTeams();
        UUID playerTeamUUID = RelationSystem.getPlayerTeamUUID(player.m_20148_());
        for (Map.Entry<UUID, TeamRelationData> entry : allTeams.entrySet()) {
            UUID teamUUID = entry.getKey();
            TeamRelationData teamData = entry.getValue();
            UUID ownerUUID = null;
            for (Map.Entry<UUID, TeamRelationData.MemberType> memberEntry : teamData.getAllMembers().entrySet()) {
                if (memberEntry.getValue() != TeamRelationData.MemberType.OWNER) continue;
                ownerUUID = memberEntry.getKey();
                break;
            }
            String ownerName = ownerUUID != null ? Optional.ofNullable(player.m_20194_().m_6846_().m_11259_(ownerUUID)).map(p -> p.m_7755_().getString()).orElse("Unknown") : "Unknown";
            int memberCount = teamData.getAllMembers().size();
            RelationSystem.RelationType relation = RelationSystem.getPlayerRelationWithTeam(player.m_20148_(), teamUUID);
            responsePacket.addTeam(teamUUID, teamData.getTeamName(), memberCount, ownerName, relation);
        }
        ServerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)responsePacket);
    }
}

