/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;

public class TeamMembersResponsePacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "team_members_response");
    private final UUID teamUUID;
    private final String teamName;
    private final List<Member> members;

    public TeamMembersResponsePacket(UUID teamUUID, String teamName, List<Member> members) {
        this.teamUUID = teamUUID;
        this.teamName = teamName;
        this.members = members;
    }

    public TeamMembersResponsePacket(FriendlyByteBuf buf) {
        this.teamUUID = buf.m_130259_();
        this.teamName = buf.m_130277_();
        int size = buf.readInt();
        this.members = new ArrayList<Member>(size);
        for (int i = 0; i < size; ++i) {
            String playerName = buf.m_130277_();
            UUID playerUUID = buf.m_130259_();
            Member.Role role = Member.Role.values()[buf.readByte()];
            long joinTime = buf.readLong();
            this.members.add(new Member(playerName, playerUUID, role, joinTime));
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.teamUUID);
        buf.m_130070_(this.teamName);
        buf.writeInt(this.members.size());
        for (Member member : this.members) {
            buf.m_130070_(member.getPlayerName());
            buf.m_130077_(member.getPlayerUUID());
            buf.writeByte(member.getRole().ordinal());
            buf.writeLong(member.getJoinTime());
        }
    }

    public static TeamMembersResponsePacket decode(FriendlyByteBuf buf) {
        return new TeamMembersResponsePacket(buf);
    }

    public static void handle(TeamMembersResponsePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> TeamMembersResponsePacket.handlePacket(packet)));
        ctx.get().setPacketHandled(true);
    }

    private static void handlePacket(TeamMembersResponsePacket packet) {
        ClientPacketHandler.onTeamMembersResponse(packet);
    }

    public UUID getTeamUUID() {
        return this.teamUUID;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public List<Member> getMembers() {
        return this.members;
    }

    public static class Member {
        private final String playerName;
        private final UUID playerUUID;
        private final Role role;
        private final long joinTime;

        public Member(String playerName, UUID playerUUID, Role role, long joinTime) {
            this.playerName = playerName;
            this.playerUUID = playerUUID;
            this.role = role;
            this.joinTime = joinTime;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public UUID getPlayerUUID() {
            return this.playerUUID;
        }

        public Role getRole() {
            return this.role;
        }

        public long getJoinTime() {
            return this.joinTime;
        }

        public static enum Role {
            OWNER,
            ADMIN,
            MEMBER;

        }
    }
}

