/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;

public class TeamRelationResponsePacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "team_relation_response_packet");
    private final Map<UUID, RelationInfo> relationInfoMap = new HashMap<UUID, RelationInfo>();
    private final Map<UUID, TeamInfo> teamInfoMap = new HashMap<UUID, TeamInfo>();
    private final UUID teamUUID;

    public TeamRelationResponsePacket(UUID teamUUID) {
        this.teamUUID = teamUUID;
    }

    public static TeamRelationResponsePacket decode(FriendlyByteBuf buf) {
        UUID teamUUID = buf.m_130259_();
        TeamRelationResponsePacket packet = new TeamRelationResponsePacket(teamUUID);
        int playerCount = buf.readInt();
        for (int i = 0; i < playerCount; ++i) {
            UUID uuid = buf.m_130259_();
            String playerName = buf.m_130277_();
            RelationSystem.RelationType teamRelation = RelationSystem.RelationType.valueOf(buf.m_130277_());
            RelationSystem.RelationType theirRelation = RelationSystem.RelationType.valueOf(buf.m_130277_());
            packet.relationInfoMap.put(uuid, new RelationInfo(playerName, teamRelation, theirRelation));
        }
        int teamCount = buf.readInt();
        for (int i = 0; i < teamCount; ++i) {
            UUID otherTeamUuid = buf.m_130259_();
            String teamName = buf.m_130277_();
            RelationSystem.RelationType teamRelation = RelationSystem.RelationType.valueOf(buf.m_130277_());
            RelationSystem.RelationType theirRelation = RelationSystem.RelationType.valueOf(buf.m_130277_());
            int memberCount = buf.readInt();
            HashMap<UUID, TeamRelationData.MemberType> members = new HashMap<UUID, TeamRelationData.MemberType>();
            for (int j = 0; j < memberCount; ++j) {
                UUID memberUuid = buf.m_130259_();
                TeamRelationData.MemberType memberType = TeamRelationData.MemberType.valueOf(buf.m_130277_());
                members.put(memberUuid, memberType);
            }
            packet.teamInfoMap.put(otherTeamUuid, new TeamInfo(teamName, teamRelation, members, theirRelation));
        }
        return packet;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.teamUUID);
        buf.writeInt(this.relationInfoMap.size());
        for (Map.Entry<UUID, RelationInfo> entry : this.relationInfoMap.entrySet()) {
            buf.m_130077_(entry.getKey());
            buf.m_130070_(entry.getValue().getPlayerName());
            buf.m_130070_(entry.getValue().getTeamRelation().name());
            buf.m_130070_(entry.getValue().getTheirRelation().name());
        }
        buf.writeInt(this.teamInfoMap.size());
        for (Map.Entry<UUID, Object> entry : this.teamInfoMap.entrySet()) {
            buf.m_130077_(entry.getKey());
            buf.m_130070_(((TeamInfo)entry.getValue()).getTeamName());
            buf.m_130070_(((TeamInfo)entry.getValue()).getTeamRelation().name());
            buf.m_130070_(((TeamInfo)entry.getValue()).getTheirRelation().name());
            Map<UUID, TeamRelationData.MemberType> members = ((TeamInfo)entry.getValue()).getMembers();
            buf.writeInt(members.size());
            for (Map.Entry<UUID, TeamRelationData.MemberType> memberEntry : members.entrySet()) {
                buf.m_130077_(memberEntry.getKey());
                buf.m_130070_(memberEntry.getValue().name());
            }
        }
    }

    public void addRelationInfo(UUID uuid, String playerName, RelationSystem.RelationType teamRelation, RelationSystem.RelationType theirRelation) {
        this.relationInfoMap.put(uuid, new RelationInfo(playerName, teamRelation, theirRelation));
    }

    public void addTeamInfo(UUID teamUuid, String teamName, RelationSystem.RelationType teamRelation, Map<UUID, TeamRelationData.MemberType> members) {
        this.addTeamInfo(teamUuid, teamName, teamRelation, members, RelationSystem.RelationType.NEUTRAL);
    }

    public void addTeamInfo(UUID teamUuid, String teamName, RelationSystem.RelationType teamRelation, Map<UUID, TeamRelationData.MemberType> members, RelationSystem.RelationType theirRelation) {
        this.teamInfoMap.put(teamUuid, new TeamInfo(teamName, teamRelation, members, theirRelation));
    }

    public Map<UUID, RelationInfo> getRelationInfoMap() {
        return this.relationInfoMap;
    }

    public Map<UUID, TeamInfo> getTeamInfoMap() {
        return this.teamInfoMap;
    }

    public UUID getTeamUUID() {
        return this.teamUUID;
    }

    public static void handle(TeamRelationResponsePacket packet, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> TeamRelationResponsePacket.handlePacket(packet)));
        ctx.setPacketHandled(true);
    }

    private static void handlePacket(TeamRelationResponsePacket packet) {
        ClientPacketHandler.onTeamRelationResponse(packet);
    }

    public static class RelationInfo {
        private final String playerName;
        private final RelationSystem.RelationType teamRelation;
        private final RelationSystem.RelationType theirRelation;

        public RelationInfo(String playerName, RelationSystem.RelationType teamRelation, RelationSystem.RelationType theirRelation) {
            this.playerName = playerName;
            this.teamRelation = teamRelation;
            this.theirRelation = theirRelation;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public RelationSystem.RelationType getTeamRelation() {
            return this.teamRelation;
        }

        public RelationSystem.RelationType getTheirRelation() {
            return this.theirRelation;
        }
    }

    public static class TeamInfo {
        private final String teamName;
        private final RelationSystem.RelationType teamRelation;
        private final Map<UUID, TeamRelationData.MemberType> members;
        private RelationSystem.RelationType theirRelation;

        public TeamInfo(String teamName, RelationSystem.RelationType teamRelation, Map<UUID, TeamRelationData.MemberType> members) {
            this(teamName, teamRelation, members, RelationSystem.RelationType.NEUTRAL);
        }

        public TeamInfo(String teamName, RelationSystem.RelationType teamRelation, Map<UUID, TeamRelationData.MemberType> members, RelationSystem.RelationType theirRelation) {
            this.teamName = teamName;
            this.teamRelation = teamRelation;
            this.members = members;
            this.theirRelation = theirRelation;
        }

        public String getTeamName() {
            return this.teamName;
        }

        public RelationSystem.RelationType getTeamRelation() {
            return this.teamRelation;
        }

        public Map<UUID, TeamRelationData.MemberType> getMembers() {
            return this.members;
        }

        public RelationSystem.RelationType getTheirRelation() {
            return this.theirRelation;
        }

        public void setTheirRelation(RelationSystem.RelationType theirRelation) {
            this.theirRelation = theirRelation;
        }
    }
}

