/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.template.HywStructureTemplate;
import ydmsama.hundred_years_war.main.template.TemplateManager;

public class TemplateDataRequestPacket {
    private final String templateId;

    public TemplateDataRequestPacket(String templateId) {
        this.templateId = templateId;
    }

    public static void encode(TemplateDataRequestPacket packet, FriendlyByteBuf buf) {
        buf.m_130070_(packet.templateId);
    }

    public static TemplateDataRequestPacket decode(FriendlyByteBuf buf) {
        String templateId = buf.m_130277_();
        return new TemplateDataRequestPacket(templateId);
    }

    public static void handle(TemplateDataRequestPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                TemplateDataRequestPacket.handlePacket(player, packet);
            }
        });
        context.setPacketHandled(true);
    }

    public static void handlePacket(ServerPlayer player, TemplateDataRequestPacket packet) {
        HywStructureTemplate template = TemplateManager.getInstance().loadTemplate(packet.templateId);
        if (template == null) {
            player.m_213846_((Component)Component.m_237113_((String)("Template not found: " + packet.templateId)));
            return;
        }
        ServerPacketHandler.sendTemplateData(player, packet.templateId, template);
    }

    public String getTemplateId() {
        return this.templateId;
    }
}

