/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.template.HywStructureTemplate;
import ydmsama.hundred_years_war.main.template.TemplateSerializer;

public class TemplateDataResponsePacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "template_data_response");
    private final String templateId;
    private final BlockPos reportedSize;
    private final BlockPos reportedEntrance;
    private final float reportedYaw;
    private final byte[] payload;

    public TemplateDataResponsePacket(String templateId, HywStructureTemplate template) {
        this.templateId = templateId;
        this.reportedSize = template.getSize();
        this.reportedEntrance = template.getEntrance() != null ? template.getEntrance() : BlockPos.f_121853_;
        this.reportedYaw = template.getPlayerYaw();
        try {
            this.payload = TemplateSerializer.serializeToBytes(template);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize template " + templateId, e);
        }
    }

    private TemplateDataResponsePacket(String templateId, BlockPos reportedSize, BlockPos reportedEntrance, float reportedYaw, byte[] payload) {
        this.templateId = templateId;
        this.reportedSize = reportedSize;
        this.reportedEntrance = reportedEntrance;
        this.reportedYaw = reportedYaw;
        this.payload = payload;
    }

    public static TemplateDataResponsePacket create(String templateId, HywStructureTemplate template) {
        return new TemplateDataResponsePacket(templateId, template);
    }

    public static void encode(TemplateDataResponsePacket packet, FriendlyByteBuf buf) {
        buf.m_130070_(packet.templateId);
        buf.m_130064_(packet.reportedSize);
        buf.m_130064_(packet.reportedEntrance);
        buf.writeFloat(packet.reportedYaw);
        buf.m_130087_(packet.payload);
    }

    public static TemplateDataResponsePacket decode(FriendlyByteBuf buf) {
        String templateId = buf.m_130277_();
        BlockPos reportedSize = buf.m_130135_();
        BlockPos reportedEntrance = buf.m_130135_();
        float reportedYaw = buf.readFloat();
        byte[] payload = buf.m_130052_();
        return new TemplateDataResponsePacket(templateId, reportedSize, reportedEntrance, reportedYaw, payload);
    }

    public static void handle(TemplateDataResponsePacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> TemplateDataResponsePacket.handlePacket(packet)));
        context.setPacketHandled(true);
    }

    private static void handlePacket(TemplateDataResponsePacket packet) {
        try {
            HywStructureTemplate template = TemplateSerializer.deserializeFromBytes(packet.payload);
            Map<BlockPos, BlockState> blocks = TemplateDataResponsePacket.extractBlocks(template);
            BlockPos size = template.getSize() != null ? template.getSize() : packet.reportedSize;
            BlockPos entrance = template.getEntrance() != null ? template.getEntrance() : packet.reportedEntrance;
            float yaw = template.getPlayerYaw();
            ClientPacketHandler.onTemplateDataResponse(packet.templateId, size, entrance, blocks, yaw);
        }
        catch (Exception e) {
            System.err.println("Failed to deserialize template " + packet.templateId + ": " + e.getMessage());
            e.printStackTrace();
            ClientPacketHandler.onTemplateDataResponse(packet.templateId, packet.reportedSize, packet.reportedEntrance, new HashMap<BlockPos, BlockState>(), packet.reportedYaw);
        }
    }

    public static Map<BlockPos, BlockState> extractBlocks(HywStructureTemplate template) {
        HashMap<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
        for (Map.Entry<HywStructureTemplate.ChunkPos, HywStructureTemplate.TemplateChunk> entry : template.getChunks().entrySet()) {
            HywStructureTemplate.ChunkPos chunkPos = entry.getKey();
            HywStructureTemplate.TemplateChunk chunk = entry.getValue();
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        BlockState state = chunk.getBlock(x, y, z);
                        if (state == null || state.m_60795_()) continue;
                        BlockPos pos = new BlockPos(chunkPos.x * 16 + x, chunkPos.y * 16 + y, chunkPos.z * 16 + z);
                        blocks.put(pos, state);
                    }
                }
            }
        }
        return blocks;
    }
}

