/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.template.TemplateMetadata;

public final class TemplateListResponsePacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "template_list_response");
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private final List<TemplateMetadata> metadataCollection;

    public TemplateListResponsePacket(Collection<TemplateMetadata> metadataCollection) {
        this.metadataCollection = metadataCollection == null ? new ArrayList<TemplateMetadata>() : new ArrayList<TemplateMetadata>(metadataCollection);
    }

    public static void encode(TemplateListResponsePacket packet, FriendlyByteBuf buf) {
        buf.m_130130_(packet.metadataCollection.size());
        for (TemplateMetadata metadata : packet.metadataCollection) {
            buf.m_130070_(metadata.getTemplateId() == null ? "" : metadata.getTemplateId());
            buf.m_130070_(TemplateListResponsePacket.nullToEmpty(metadata.getName()));
            buf.m_130070_(TemplateListResponsePacket.nullToEmpty(metadata.getCategory()));
            buf.m_130070_(TemplateListResponsePacket.nullToEmpty(metadata.getDescription()));
            TemplateListResponsePacket.writeNullableBlockPos(buf, metadata.getSize());
            TemplateListResponsePacket.writeNullableBlockPos(buf, metadata.getEntrance());
            buf.m_130070_(TemplateListResponsePacket.nullToEmpty(metadata.getAuthor()));
            buf.writeLong(metadata.getCreatedTime());
            buf.m_130130_(metadata.getTotalBlocks());
            buf.writeFloat(metadata.getPlayerYaw());
            buf.writeBoolean(metadata.getFileName() != null);
            if (metadata.getFileName() != null) {
                buf.m_130070_(metadata.getFileName());
            }
            buf.writeLong(metadata.getFileSize());
            Map<String, Integer> blockCount = metadata.getBlockCount();
            buf.m_130130_(blockCount != null ? blockCount.size() : 0);
            if (blockCount != null) {
                for (Map.Entry<String, Integer> entry : blockCount.entrySet()) {
                    buf.m_130070_(entry.getKey());
                    buf.m_130130_(entry.getValue().intValue());
                }
            }
            buf.writeBoolean(metadata.isGenerationEnabled());
            buf.m_130130_(metadata.getGenerationWeight());
            buf.m_130130_(metadata.getConnectionLayerDepth());
            buf.m_130130_(metadata.getMinGenerationHeight());
            buf.m_130130_(metadata.getMaxGenerationHeight());
            buf.writeBoolean(metadata.isGenerateOnSurface());
            Map<String, JsonElement> attributes = metadata.getCustomAttributes();
            buf.m_130130_(attributes.size());
            for (Map.Entry<String, JsonElement> entry : attributes.entrySet()) {
                buf.m_130070_(entry.getKey());
                buf.m_130070_(GSON.toJson(entry.getValue()));
            }
        }
    }

    public static TemplateListResponsePacket decode(FriendlyByteBuf buf) {
        int count = buf.m_130242_();
        ArrayList<TemplateMetadata> list = new ArrayList<TemplateMetadata>(count);
        for (int i = 0; i < count; ++i) {
            String templateId = buf.m_130277_();
            String name = TemplateListResponsePacket.emptyToNull(buf.m_130277_());
            String category = TemplateListResponsePacket.emptyToNull(buf.m_130277_());
            String description = TemplateListResponsePacket.emptyToNull(buf.m_130277_());
            BlockPos size = TemplateListResponsePacket.readNullableBlockPos(buf);
            BlockPos entrance = TemplateListResponsePacket.readNullableBlockPos(buf);
            String author = TemplateListResponsePacket.emptyToNull(buf.m_130277_());
            long createdTime = buf.readLong();
            int totalBlocks = buf.m_130242_();
            float playerYaw = buf.readFloat();
            String fileName = null;
            if (buf.readBoolean()) {
                fileName = buf.m_130277_();
            }
            long fileSize = buf.readLong();
            int blockCountSize = buf.m_130242_();
            LinkedHashMap<String, Integer> blockCount = new LinkedHashMap<String, Integer>(blockCountSize);
            for (int j = 0; j < blockCountSize; ++j) {
                String key = buf.m_130277_();
                int value = buf.m_130242_();
                blockCount.put(key, value);
            }
            TemplateMetadata metadata = new TemplateMetadata(name, category, description, size, entrance, author, createdTime, totalBlocks, blockCount, fileName, fileSize, playerYaw);
            metadata.setTemplateId(templateId.isEmpty() ? null : templateId);
            boolean enableGeneration = buf.readBoolean();
            metadata.setGenerationEnabled(enableGeneration);
            metadata.setGenerationWeight(buf.m_130242_());
            metadata.setConnectionLayerDepth(buf.m_130242_());
            metadata.setMinGenerationHeight(buf.m_130242_());
            metadata.setMaxGenerationHeight(buf.m_130242_());
            metadata.setGenerateOnSurface(buf.readBoolean());
            int attributeCount = buf.m_130242_();
            LinkedHashMap<String, JsonElement> customAttributes = new LinkedHashMap<String, JsonElement>(attributeCount);
            for (int j = 0; j < attributeCount; ++j) {
                String key = buf.m_130277_();
                String json = buf.m_130277_();
                customAttributes.put(key, JsonParser.parseString((String)json));
            }
            metadata.setCustomAttributes(customAttributes);
            list.add(metadata);
        }
        return new TemplateListResponsePacket(list);
    }

    public static void handle(TemplateListResponsePacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> TemplateListResponsePacket.handlePacket(packet)));
        context.setPacketHandled(true);
    }

    private static void handlePacket(TemplateListResponsePacket packet) {
        ClientPacketHandler.onTemplateListResponse(packet.getMetadataCollection());
    }

    public List<TemplateMetadata> getMetadataCollection() {
        return this.metadataCollection;
    }

    private static String nullToEmpty(String value) {
        return value == null ? "" : value;
    }

    private static String emptyToNull(String value) {
        return value.isEmpty() ? null : value;
    }

    private static void writeNullableBlockPos(FriendlyByteBuf buf, BlockPos pos) {
        if (pos == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.m_130064_(pos);
        }
    }

    private static BlockPos readNullableBlockPos(FriendlyByteBuf buf) {
        if (!buf.readBoolean()) {
            return null;
        }
        return buf.m_130135_();
    }
}

