/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.template.TemplateManager;
import ydmsama.hundred_years_war.main.template.TemplateMetadata;

public class UpdateTemplatePropertiesPacket {
    private final String templateId;
    private final boolean enableGeneration;
    private final int generationWeight;
    private final int connectionLayerDepth;
    private final int minGenerationHeight;
    private final int maxGenerationHeight;
    private final boolean generateOnSurface;
    private final Map<String, JsonElement> customAttributes;

    public UpdateTemplatePropertiesPacket(String templateId, boolean enableGeneration, int generationWeight, int connectionLayerDepth, int minGenerationHeight, int maxGenerationHeight, boolean generateOnSurface, Map<String, JsonElement> customAttributes) {
        this.templateId = templateId;
        this.enableGeneration = enableGeneration;
        this.generationWeight = generationWeight;
        this.connectionLayerDepth = connectionLayerDepth;
        this.minGenerationHeight = minGenerationHeight;
        this.maxGenerationHeight = maxGenerationHeight;
        this.generateOnSurface = generateOnSurface;
        this.customAttributes = customAttributes;
    }

    public static void encode(UpdateTemplatePropertiesPacket packet, FriendlyByteBuf buf) {
        buf.m_130070_(packet.templateId);
        buf.writeBoolean(packet.enableGeneration);
        buf.writeInt(packet.generationWeight);
        buf.writeInt(packet.connectionLayerDepth);
        buf.writeInt(packet.minGenerationHeight);
        buf.writeInt(packet.maxGenerationHeight);
        buf.writeBoolean(packet.generateOnSurface);
        buf.m_130130_(packet.customAttributes.size());
        packet.customAttributes.forEach((key, value) -> {
            buf.m_130070_(key);
            buf.m_130070_(value == null ? "" : value.toString());
        });
    }

    public static UpdateTemplatePropertiesPacket decode(FriendlyByteBuf buf) {
        String templateId = buf.m_130277_();
        boolean enableGeneration = buf.readBoolean();
        int generationWeight = buf.readInt();
        int connectionLayerDepth = buf.readInt();
        int minGenerationHeight = buf.readInt();
        int maxGenerationHeight = buf.readInt();
        boolean generateOnSurface = buf.readBoolean();
        int size = buf.m_130242_();
        HashMap<String, JsonElement> attributes = new HashMap<String, JsonElement>(size);
        for (int i = 0; i < size; ++i) {
            String key = buf.m_130277_();
            String json = buf.m_130277_();
            attributes.put(key, UpdateTemplatePropertiesPacket.parseJson(json));
        }
        return new UpdateTemplatePropertiesPacket(templateId, enableGeneration, generationWeight, connectionLayerDepth, minGenerationHeight, maxGenerationHeight, generateOnSurface, attributes);
    }

    public static void handle(UpdateTemplatePropertiesPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                UpdateTemplatePropertiesPacket.handlePacket(player, packet);
            }
        });
        context.setPacketHandled(true);
    }

    public static void handlePacket(ServerPlayer player, UpdateTemplatePropertiesPacket packet) {
        TemplateMetadata metadata;
        TemplateManager templateManager = TemplateManager.getInstance();
        if (!templateManager.isInitialized()) {
            templateManager.initialize(player.m_20194_());
        }
        if ((metadata = templateManager.getMetadata(packet.templateId)) == null) {
            templateManager.rescanTemplates();
            metadata = templateManager.getMetadata(packet.templateId);
            if (metadata == null) {
                player.m_5661_((Component)Component.m_237113_((String)("Template not found: " + packet.templateId)).m_130940_(ChatFormatting.RED), true);
                return;
            }
        }
        metadata.setGenerationEnabled(packet.enableGeneration);
        metadata.setGenerationWeight(packet.generationWeight);
        metadata.setConnectionLayerDepth(packet.connectionLayerDepth);
        metadata.setMinGenerationHeight(packet.minGenerationHeight);
        metadata.setMaxGenerationHeight(packet.maxGenerationHeight);
        metadata.setGenerateOnSurface(packet.generateOnSurface);
        metadata.setCustomAttributes(packet.customAttributes);
        metadata.ensureCommonAttributes();
        boolean success = templateManager.saveMetadataToFile(packet.templateId, metadata);
        if (success) {
            player.m_5661_((Component)Component.m_237110_((String)"gui.hundred_years_war.template_properties.saved", (Object[])new Object[]{metadata.getName()}).m_130940_(ChatFormatting.GREEN), true);
        } else {
            player.m_5661_((Component)Component.m_237113_((String)"Failed to save template properties").m_130940_(ChatFormatting.RED), true);
        }
    }

    public static JsonElement parseJson(String json) {
        if (json == null || json.isEmpty()) {
            return JsonNull.INSTANCE;
        }
        try {
            return JsonParser.parseString((String)json);
        }
        catch (JsonSyntaxException e) {
            return new JsonPrimitive(json);
        }
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public boolean isEnableGeneration() {
        return this.enableGeneration;
    }

    public int getGenerationWeight() {
        return this.generationWeight;
    }

    public int getConnectionLayerDepth() {
        return this.connectionLayerDepth;
    }

    public int getMinGenerationHeight() {
        return this.minGenerationHeight;
    }

    public int getMaxGenerationHeight() {
        return this.maxGenerationHeight;
    }

    public boolean isGenerateOnSurface() {
        return this.generateOnSurface;
    }

    public Map<String, JsonElement> getCustomAttributes() {
        return this.customAttributes;
    }
}

