/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets.warehouse;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.warehouse.WarehouseItemData;

public class WarehouseDataSyncPacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "warehouse_data_sync");
    private final BlockPos blockPos;
    private final List<WarehouseItemData> items;
    private final int totalCapacity;
    private final int usedCapacity;
    private final String sortType;
    private final boolean sortAscending;

    public WarehouseDataSyncPacket(BlockPos blockPos, List<WarehouseItemData> items, int totalCapacity, int usedCapacity, String sortType, boolean sortAscending) {
        this.blockPos = blockPos;
        this.items = items;
        this.totalCapacity = totalCapacity;
        this.usedCapacity = usedCapacity;
        this.sortType = sortType;
        this.sortAscending = sortAscending;
    }

    public WarehouseDataSyncPacket(BlockPos blockPos, List<WarehouseItemData> items, int totalCapacity, int usedCapacity) {
        this(blockPos, items, totalCapacity, usedCapacity, "NAME", true);
    }

    public static WarehouseDataSyncPacket fromItemStacks(BlockPos blockPos, List<ItemStack> itemStacks, int totalCapacity, int usedCapacity) {
        ArrayList<WarehouseItemData> itemDataList = new ArrayList<WarehouseItemData>();
        for (ItemStack stack : itemStacks) {
            itemDataList.add(new WarehouseItemData(stack, stack.m_41613_()));
        }
        return new WarehouseDataSyncPacket(blockPos, itemDataList, totalCapacity, usedCapacity);
    }

    public static void encode(WarehouseDataSyncPacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.blockPos);
        buf.writeInt(packet.totalCapacity);
        buf.writeInt(packet.usedCapacity);
        buf.m_130070_(packet.sortType);
        buf.writeBoolean(packet.sortAscending);
        buf.writeInt(packet.items.size());
        for (WarehouseItemData item : packet.items) {
            item.encode(buf);
        }
    }

    public static WarehouseDataSyncPacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        int totalCapacity = buf.readInt();
        int usedCapacity = buf.readInt();
        String sortType = buf.m_130277_();
        boolean sortAscending = buf.readBoolean();
        int itemCount = buf.readInt();
        ArrayList<WarehouseItemData> items = new ArrayList<WarehouseItemData>();
        for (int i = 0; i < itemCount; ++i) {
            items.add(WarehouseItemData.decode(buf));
        }
        return new WarehouseDataSyncPacket(pos, items, totalCapacity, usedCapacity, sortType, sortAscending);
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public List<WarehouseItemData> getItemData() {
        return this.items;
    }

    public List<ItemStack> getDisplayItems() {
        ArrayList<ItemStack> displayItems = new ArrayList<ItemStack>();
        for (WarehouseItemData data : this.items) {
            ItemStack display = data.getItemType();
            display.m_41764_(data.getActualCount());
            displayItems.add(display);
        }
        return displayItems;
    }

    public int getTotalCapacity() {
        return this.totalCapacity;
    }

    public int getUsedCapacity() {
        return this.usedCapacity;
    }

    public String getSortType() {
        return this.sortType;
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public static void handlePacket(WarehouseDataSyncPacket packet) {
        ClientPacketHandler.onWarehouseDataSync(packet);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> WarehouseDataSyncPacket.handlePacket(this)));
        context.get().setPacketHandled(true);
    }
}

