/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets.warehouse;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseControlBlockEntity;

public class WarehouseItemDepositPacket {
    private final BlockPos warehousePos;

    public WarehouseItemDepositPacket(BlockPos warehousePos) {
        this.warehousePos = warehousePos;
    }

    public static void encode(WarehouseItemDepositPacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.warehousePos);
    }

    public static WarehouseItemDepositPacket decode(FriendlyByteBuf buf) {
        BlockPos warehousePos = buf.m_130135_();
        return new WarehouseItemDepositPacket(warehousePos);
    }

    public static void handle(WarehouseItemDepositPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ItemStack cursorStack;
            WarehouseControlBlockEntity warehouse;
            BlockEntity blockEntity;
            ServerPlayer player = context.getSender();
            if (player != null && (blockEntity = player.m_9236_().m_7702_(packet.warehousePos)) instanceof WarehouseControlBlockEntity && (warehouse = (WarehouseControlBlockEntity)blockEntity).stillValid((Player)player) && !(cursorStack = player.f_36096_.m_142621_()).m_41619_()) {
                ItemStack remaining = warehouse.tryAddItem(cursorStack);
                player.f_36096_.m_142503_(remaining);
                warehouse.syncToClient(player);
                player.f_36096_.m_38946_();
            }
        });
        context.setPacketHandled(true);
    }
}

