/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets.warehouse;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseControlBlockEntity;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseControlScreenHandler;

public class WarehouseItemRequestPacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "warehouse_item_request");
    private final BlockPos blockPos;
    private final ItemStack requestItem;
    private final int actualCount;
    private final boolean shiftClick;
    private final boolean rightClick;

    public WarehouseItemRequestPacket(BlockPos blockPos, ItemStack requestItem, boolean shiftClick, boolean rightClick) {
        this.blockPos = blockPos;
        this.requestItem = requestItem.m_41777_();
        this.actualCount = requestItem.m_41613_();
        this.requestItem.m_41764_(1);
        this.shiftClick = shiftClick;
        this.rightClick = rightClick;
    }

    public static void encode(WarehouseItemRequestPacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.blockPos);
        buf.m_130055_(packet.requestItem);
        buf.m_130130_(packet.actualCount);
        buf.writeBoolean(packet.shiftClick);
        buf.writeBoolean(packet.rightClick);
    }

    public static WarehouseItemRequestPacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        ItemStack item = buf.m_130267_();
        int actualCount = buf.m_130242_();
        item.m_41764_(actualCount);
        boolean shiftClick = buf.readBoolean();
        boolean rightClick = buf.readBoolean();
        return new WarehouseItemRequestPacket(pos, item, shiftClick, rightClick);
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public ItemStack getRequestItem() {
        ItemStack result = this.requestItem.m_41777_();
        result.m_41764_(this.actualCount);
        return result;
    }

    public boolean isShiftClick() {
        return this.shiftClick;
    }

    public boolean isRightClick() {
        return this.rightClick;
    }

    public static void handlePacket(ServerPlayer player, WarehouseItemRequestPacket packet) {
        WarehouseControlBlockEntity warehouse;
        BlockEntity blockEntity = player.m_9236_().m_7702_(packet.blockPos);
        if (blockEntity instanceof WarehouseControlBlockEntity && (warehouse = (WarehouseControlBlockEntity)blockEntity).stillValid((Player)player)) {
            ItemStack requestItem = packet.getRequestItem();
            boolean rightClick = packet.rightClick;
            boolean shiftClick = packet.shiftClick;
            ItemStack cursorStack = player.f_36096_.m_142621_();
            if (!cursorStack.m_41619_()) {
                ItemStack remaining = warehouse.tryAddItem(cursorStack);
                player.f_36096_.m_142503_(remaining);
            } else {
                int available = warehouse.getItemCount(requestItem);
                int requestCount = rightClick ? Math.min((available + 1) / 2, requestItem.m_41741_()) : Math.min(available, requestItem.m_41741_());
                ItemStack extractRequest = requestItem.m_41777_();
                extractRequest.m_41764_(requestCount);
                ItemStack extracted = warehouse.tryExtractItem(extractRequest);
                if (!extracted.m_41619_()) {
                    AbstractContainerMenu abstractContainerMenu;
                    if (shiftClick && (abstractContainerMenu = player.f_36096_) instanceof WarehouseControlScreenHandler) {
                        WarehouseControlScreenHandler screenHandler = (WarehouseControlScreenHandler)abstractContainerMenu;
                        if (!screenHandler.moveItemStackToPublic(extracted, 0, 36, false)) {
                            warehouse.tryAddItem(extracted);
                        }
                    } else {
                        player.f_36096_.m_142503_(extracted);
                    }
                }
            }
            warehouse.syncToClient(player);
            player.f_36096_.m_38946_();
        }
    }

    public static void handle(WarehouseItemRequestPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                WarehouseItemRequestPacket.handlePacket(player, packet);
            }
        });
        context.setPacketHandled(true);
    }
}

