/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets.warehouse;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseControlBlockEntity;

public class WarehouseSortPacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "warehouse_sort");
    private final BlockPos blockPos;
    private final boolean changeSortType;
    private final boolean changeSortOrder;

    public WarehouseSortPacket(BlockPos blockPos, boolean changeSortType, boolean changeSortOrder) {
        this.blockPos = blockPos;
        this.changeSortType = changeSortType;
        this.changeSortOrder = changeSortOrder;
    }

    public static void encode(WarehouseSortPacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.blockPos);
        buf.writeBoolean(packet.changeSortType);
        buf.writeBoolean(packet.changeSortOrder);
    }

    public static WarehouseSortPacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        boolean changeSortType = buf.readBoolean();
        boolean changeSortOrder = buf.readBoolean();
        return new WarehouseSortPacket(pos, changeSortType, changeSortOrder);
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public boolean isChangeSortType() {
        return this.changeSortType;
    }

    public boolean isChangeSortOrder() {
        return this.changeSortOrder;
    }

    public static void handlePacket(ServerPlayer player, WarehouseSortPacket packet) {
        WarehouseControlBlockEntity warehouse;
        BlockEntity blockEntity = player.m_9236_().m_7702_(packet.blockPos);
        if (blockEntity instanceof WarehouseControlBlockEntity && (warehouse = (WarehouseControlBlockEntity)blockEntity).stillValid((Player)player)) {
            if (packet.changeSortType) {
                warehouse.setSortType(warehouse.getSortType().next());
            }
            if (packet.changeSortOrder) {
                warehouse.setSortAscending(!warehouse.isSortAscending());
            }
        }
    }

    public static void handle(WarehouseSortPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                WarehouseSortPacket.handlePacket(player, packet);
            }
        });
        context.setPacketHandled(true);
    }
}

