/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.spawn;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;

public class SpawnPointBlockEntity
extends BlockEntity {
    public static final String TAG_ACTIVATION_DISTANCE = "ActivationDistance";
    public static final String TAG_HORIZONTAL_RANGE = "HorizontalRange";
    public static final String TAG_VERTICAL_RANGE = "VerticalRange";
    public static final String TAG_PER_SPAWN = "PerSpawn";
    public static final String TAG_REMAINING = "Remaining";
    public static final String TAG_MIN_INTERVAL = "MinInterval";
    public static final String TAG_MAX_INTERVAL = "MaxInterval";
    public static final String TAG_CURRENT_INTERVAL = "CurrentInterval";
    public static final String TAG_MAX_ACTIVE = "MaxActive";
    public static final String TAG_INFINITE = "Infinite";
    public static final String TAG_RESET_INTERVAL = "ResetInterval";
    public static final String TAG_LAST_ACTIVATION = "LastActivation";
    public static final String TAG_LAST_TICK = "LastTick";
    public static final String TAG_LAST_RESET = "LastReset";
    public static final String TAG_CURRENT_RESET_COOLDOWN = "CurrentResetCooldown";
    public static final String TAG_SPAWN_ENTRIES = "SpawnEntries";
    public static final String TAG_ACTIVE_ENTITIES = "ActiveEntities";
    public static final String TAG_SAVED_STATE = "SavedState";
    public static final String TAG_ACTIVE_COUNT = "ActiveCount";
    public static final String TAG_SHOW_ACTIVATION_RANGE = "ShowActivationRange";
    public static final String TAG_PAUSED = "Paused";
    public static final String TAG_PERIODIC_RESET = "PeriodicReset";
    private double activationDistance = 16.0;
    private double horizontalRange = 4.0;
    private double verticalRange = 2.0;
    private int perSpawnCount = 1;
    private int remainingCount = 20;
    private int minInterval = 5;
    private int maxInterval = 20;
    private int currentInterval = 0;
    private int maxActiveEntities = 5;
    private boolean infiniteSummon = false;
    private long resetInterval = 0L;
    private long currentResetCooldown = 0L;
    private boolean showActivationRange = false;
    private boolean paused = true;
    private boolean periodicReset = false;
    private int trackedActiveEntities = 0;
    private int lastSyncedActiveEntities = -1;
    private long lastActiveSyncTick = -1L;
    private long lastActivationTick = -1L;
    private long lastTickTime = -1L;
    private long lastResetTick = -1L;
    private final List<SpawnEntry> spawnEntries = new ArrayList<SpawnEntry>();
    private final Set<UUID> spawnedEntities = new HashSet<UUID>();
    private SavedState savedState = null;
    private int cachedActiveCount = -1;
    private long lastCountTick = -1L;
    private static final int COUNT_CACHE_INTERVAL = 20;
    private static final int ACTIVE_COUNT_SYNC_INTERVAL = 5;

    public SpawnPointBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SPAWN_POINT.get(), pos, state);
        this.spawnEntries.add(new SpawnEntry(new ResourceLocation("minecraft", "zombie"), 1, 1, 1));
    }

    public void serverTick() {
        Level level = this.m_58904_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        long gameTime = serverLevel.m_46467_();
        long delta = 1L;
        if (this.lastTickTime >= 0L) {
            delta = Math.max(1L, gameTime - this.lastTickTime);
        }
        this.lastTickTime = gameTime;
        boolean needsSync = false;
        if (gameTime - this.lastActiveSyncTick >= 5L) {
            this.countActiveEntitiesInRange((Level)serverLevel);
        }
        if (this.periodicReset && this.savedState == null) {
            this.periodicReset = false;
            needsSync = true;
        }
        if (this.paused) {
            if (needsSync) {
                this.m_6596_();
                this.sync();
            }
            return;
        }
        int oldInterval = this.currentInterval;
        long oldResetCooldown = this.currentResetCooldown;
        if (this.currentInterval > 0) {
            this.currentInterval = (int)Math.max(0L, (long)this.currentInterval - delta);
            if (this.currentInterval != oldInterval) {
                needsSync = true;
            }
        }
        if (this.periodicReset && this.savedState != null && this.currentResetCooldown > 0L) {
            this.currentResetCooldown = Math.max(0L, this.currentResetCooldown - delta);
            if (this.currentResetCooldown != oldResetCooldown) {
                needsSync = true;
            }
            if (this.currentResetCooldown == 0L && oldResetCooldown > 0L) {
                this.restoreSavedState();
                this.currentResetCooldown = this.resetInterval;
                needsSync = true;
            }
        }
        if (gameTime % 100L == 0L) {
            this.cleanupDeadEntities(serverLevel);
        }
        if (needsSync) {
            this.m_6596_();
            this.sync();
        }
        if (this.currentInterval > 0) {
            return;
        }
        if (!this.canAttemptSpawn(serverLevel)) {
            return;
        }
        if (!this.hasNearbyPlayer(serverLevel)) {
            return;
        }
        int spawned = this.performSpawn(serverLevel, serverLevel.f_46441_);
        if (spawned > 0) {
            this.lastActivationTick = gameTime;
            this.lastResetTick = gameTime;
            this.currentInterval = this.computeNextInterval(serverLevel.f_46441_);
            this.m_6596_();
            this.sync();
        }
    }

    private int performSpawn(ServerLevel level, RandomSource random) {
        SpawnEntry entry;
        int currentActive;
        int currentActive2;
        int allowed;
        if (this.spawnEntries.isEmpty()) {
            return 0;
        }
        int n = allowed = this.infiniteSummon ? Integer.MAX_VALUE : this.remainingCount;
        if (allowed <= 0) {
            return 0;
        }
        int toSpawn = Math.min(this.perSpawnCount, allowed);
        if (this.maxActiveEntities > 0 && (toSpawn = Math.min(toSpawn, Math.max(0, this.maxActiveEntities - (currentActive2 = this.countActiveEntitiesInRange((Level)level))))) <= 0) {
            return 0;
        }
        int spawned = 0;
        for (int i = 0; i < toSpawn && (this.maxActiveEntities <= 0 || (currentActive = this.countActiveEntitiesInRange((Level)level)) < this.maxActiveEntities) && (entry = this.chooseEntry(random)) != null; ++i) {
            double z;
            EntityType entityType = BuiltInRegistries.f_256780_.m_6612_(entry.entityId()).orElse(null);
            if (entityType == null) continue;
            double x = (double)this.m_58899_().m_123341_() + 0.5 + Mth.m_216263_((RandomSource)random, (double)(-this.horizontalRange), (double)this.horizontalRange);
            Double groundY = this.findGroundPosition(level, x, z = (double)this.m_58899_().m_123343_() + 0.5 + Mth.m_216263_((RandomSource)random, (double)(-this.horizontalRange), (double)this.horizontalRange));
            double y = groundY != null ? groundY : (double)this.m_58899_().m_123342_() + Mth.m_216263_((RandomSource)random, (double)(-this.verticalRange), (double)this.verticalRange);
            Entity entity = entityType.m_20615_((Level)level);
            if (entity == null) continue;
            if (entity instanceof BaseCombatEntity) {
                BaseCombatEntity baseCombatEntity = (BaseCombatEntity)entity;
                baseCombatEntity.applyLevelWithStats(entry.level());
                baseCombatEntity.setEquipment(entry.equipmentLevel());
                baseCombatEntity.setRequiresSupply(false);
            }
            entity.m_7678_(x, y, z, random.m_188501_() * 360.0f, 0.0f);
            if (!level.m_45786_(entity)) {
                entity.m_146870_();
                continue;
            }
            if (!level.m_8860_(entity)) continue;
            this.spawnedEntities.add(entity.m_20148_());
            ++spawned;
        }
        if (spawned > 0) {
            if (!this.infiniteSummon) {
                this.remainingCount = Math.max(0, this.remainingCount - spawned);
            }
            this.cachedActiveCount = -1;
            this.countActiveEntitiesInRange((Level)level);
        }
        return spawned;
    }

    private Double findGroundPosition(ServerLevel level, double x, double z) {
        BlockPos centerPos = this.m_58899_();
        int minY = (int)Math.floor((double)centerPos.m_123342_() - this.verticalRange);
        int maxY = (int)Math.ceil((double)centerPos.m_123342_() + this.verticalRange);
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        int blockX = Mth.m_14107_((double)x);
        int blockZ = Mth.m_14107_((double)z);
        for (int y = maxY; y >= minY; --y) {
            checkPos.m_122178_(blockX, y, blockZ);
            BlockState groundState = level.m_8055_((BlockPos)checkPos);
            if (!this.isValidGround(level, (BlockPos)checkPos, groundState)) continue;
            checkPos.m_122178_(blockX, y + 1, blockZ);
            BlockState aboveState1 = level.m_8055_((BlockPos)checkPos);
            checkPos.m_122178_(blockX, y + 2, blockZ);
            BlockState aboveState2 = level.m_8055_((BlockPos)checkPos);
            if (aboveState1.m_60804_((BlockGetter)level, (BlockPos)checkPos.m_142448_(y + 1)) || aboveState2.m_60804_((BlockGetter)level, (BlockPos)checkPos.m_142448_(y + 2))) continue;
            return (double)y + 1.0;
        }
        return null;
    }

    private boolean isValidGround(ServerLevel level, BlockPos pos, BlockState state) {
        if (!state.m_60804_((BlockGetter)level, pos)) {
            return false;
        }
        return state.m_60783_((BlockGetter)level, pos, Direction.UP);
    }

    private SpawnEntry chooseEntry(RandomSource random) {
        if (this.spawnEntries.isEmpty()) {
            return null;
        }
        int totalWeight = this.spawnEntries.stream().mapToInt(SpawnEntry::weight).sum();
        if (totalWeight <= 0) {
            return this.spawnEntries.get(0);
        }
        int value = random.m_188503_(totalWeight);
        int cumulative = 0;
        for (SpawnEntry entry : this.spawnEntries) {
            if (value >= (cumulative += entry.weight())) continue;
            return entry;
        }
        return this.spawnEntries.get(this.spawnEntries.size() - 1);
    }

    private int computeNextInterval(RandomSource random) {
        int max;
        if (this.minInterval <= 0 && this.maxInterval <= 0) {
            return 0;
        }
        int min = Math.max(0, this.minInterval);
        if (min == (max = Math.max(min, this.maxInterval))) {
            return min;
        }
        return random.m_188503_(max - min + 1) + min;
    }

    private boolean canAttemptSpawn(ServerLevel serverLevel) {
        int currentActive;
        if (this.spawnEntries.isEmpty()) {
            return false;
        }
        if (!this.infiniteSummon && this.remainingCount <= 0) {
            return false;
        }
        return this.maxActiveEntities <= 0 || (currentActive = this.countActiveEntitiesInRange((Level)serverLevel)) < this.maxActiveEntities;
    }

    private void cleanupDeadEntities(ServerLevel serverLevel) {
        if (this.spawnedEntities.isEmpty()) {
            return;
        }
        int sizeBefore = this.spawnedEntities.size();
        this.spawnedEntities.removeIf(uuid -> {
            Entity entity = serverLevel.m_8791_(uuid);
            return entity == null || !entity.m_6084_();
        });
        if (this.spawnedEntities.size() != sizeBefore) {
            this.cachedActiveCount = -1;
            this.countActiveEntitiesInRange((Level)serverLevel);
        }
    }

    private int countActiveEntitiesInRange(Level level) {
        if (level == null) {
            return this.trackedActiveEntities;
        }
        if (this.activationDistance <= 0.0 || this.spawnedEntities.isEmpty()) {
            this.updateTrackedActiveEntities(level, 0);
            return 0;
        }
        double scanRadius = this.activationDistance;
        AABB scanBox = new AABB((double)this.m_58899_().m_123341_() - scanRadius, (double)this.m_58899_().m_123342_() - scanRadius, (double)this.m_58899_().m_123343_() - scanRadius, (double)this.m_58899_().m_123341_() + scanRadius + 1.0, (double)this.m_58899_().m_123342_() + scanRadius + 1.0, (double)this.m_58899_().m_123343_() + scanRadius + 1.0);
        List nearbyEntities = level.m_6249_((Entity)null, scanBox, entity -> {
            if (entity == null || !entity.m_6084_()) {
                return false;
            }
            return this.spawnedEntities.contains(entity.m_20148_());
        });
        this.updateTrackedActiveEntities(level, nearbyEntities.size());
        return nearbyEntities.size();
    }

    public int getActiveEntityCount(Level level) {
        if (level == null) {
            return this.trackedActiveEntities;
        }
        if (level.f_46443_) {
            return this.trackedActiveEntities;
        }
        long gameTime = level.m_46467_();
        if (this.cachedActiveCount >= 0 && this.lastCountTick >= 0L && gameTime - this.lastCountTick < 20L) {
            return this.cachedActiveCount;
        }
        this.cachedActiveCount = this.countActiveEntitiesInRange(level);
        this.lastCountTick = gameTime;
        return this.cachedActiveCount;
    }

    private void updateTrackedActiveEntities(Level level, int newCount) {
        if (this.trackedActiveEntities == newCount) {
            if (level != null && !level.f_46443_) {
                long gameTime = level.m_46467_();
                if (this.lastSyncedActiveEntities < 0) {
                    this.lastSyncedActiveEntities = newCount;
                }
                if (this.lastActiveSyncTick < 0L) {
                    this.lastActiveSyncTick = gameTime;
                }
            }
            return;
        }
        this.trackedActiveEntities = newCount;
        if (level == null || level.f_46443_) {
            return;
        }
        long gameTime = level.m_46467_();
        if (newCount != this.lastSyncedActiveEntities || this.lastSyncedActiveEntities < 0 || gameTime - this.lastActiveSyncTick >= 5L) {
            this.lastSyncedActiveEntities = newCount;
            this.lastActiveSyncTick = gameTime;
            this.m_6596_();
            this.sync();
        }
    }

    public void restoreSavedState() {
        Level currentLevel;
        if (this.savedState == null) {
            return;
        }
        this.activationDistance = this.savedState.activationDistance();
        this.horizontalRange = this.savedState.horizontalRange();
        this.verticalRange = this.savedState.verticalRange();
        this.perSpawnCount = this.savedState.perSpawnCount();
        this.remainingCount = this.savedState.remainingCount();
        this.minInterval = this.savedState.minInterval();
        this.maxInterval = this.savedState.maxInterval();
        this.currentInterval = this.savedState.currentInterval();
        this.maxActiveEntities = this.savedState.maxActiveEntities();
        this.infiniteSummon = this.savedState.infiniteSummon();
        this.resetInterval = this.savedState.resetInterval();
        this.spawnEntries.clear();
        this.spawnEntries.addAll(this.savedState.spawnEntries());
        long l = this.lastResetTick = this.m_58904_() != null ? this.m_58904_().m_46467_() : -1L;
        if (this.periodicReset && this.resetInterval > 0L) {
            this.currentResetCooldown = this.resetInterval;
        }
        if ((currentLevel = this.m_58904_()) != null && !currentLevel.f_46443_) {
            this.cachedActiveCount = -1;
            this.countActiveEntitiesInRange(currentLevel);
        }
        this.m_6596_();
        this.sync();
    }

    public void saveCurrentAsInitial() {
        Level currentLevel;
        this.savedState = new SavedState(this.activationDistance, this.horizontalRange, this.verticalRange, this.perSpawnCount, this.remainingCount, this.minInterval, this.maxInterval, this.currentInterval, this.maxActiveEntities, this.infiniteSummon, this.resetInterval, new ArrayList<SpawnEntry>(this.spawnEntries));
        long l = this.lastResetTick = this.m_58904_() != null ? this.m_58904_().m_46467_() : this.lastResetTick;
        if (this.periodicReset && this.resetInterval > 0L) {
            this.currentResetCooldown = this.resetInterval;
        }
        if ((currentLevel = this.m_58904_()) != null && !currentLevel.f_46443_) {
            this.cachedActiveCount = -1;
            this.countActiveEntitiesInRange(currentLevel);
        }
        this.m_6596_();
        this.sync();
    }

    public List<SpawnEntry> getSpawnEntries() {
        return this.spawnEntries;
    }

    public Component getPrimaryEntryName() {
        if (this.spawnEntries.isEmpty()) {
            return null;
        }
        ResourceLocation id = this.spawnEntries.get(0).entityId();
        return BuiltInRegistries.f_256780_.m_6612_(id).map(EntityType::m_20676_).orElse((Component)Component.m_237113_((String)id.toString()));
    }

    public void setSpawnEntries(List<SpawnEntry> entries) {
        this.spawnEntries.clear();
        entries.stream().filter(entry -> entry.weight() > 0).forEach(this.spawnEntries::add);
        this.m_6596_();
        this.sync();
    }

    public void setActivationDistance(double activationDistance) {
        this.activationDistance = Math.max(0.0, activationDistance);
        this.m_6596_();
        this.sync();
    }

    public double getActivationDistance() {
        return this.activationDistance;
    }

    public double getHorizontalRange() {
        return this.horizontalRange;
    }

    public void setHorizontalRange(double horizontalRange) {
        this.horizontalRange = Math.max(0.0, horizontalRange);
        this.m_6596_();
        this.sync();
    }

    public double getVerticalRange() {
        return this.verticalRange;
    }

    public void setVerticalRange(double verticalRange) {
        this.verticalRange = Math.max(0.0, verticalRange);
        this.m_6596_();
        this.sync();
    }

    public int getPerSpawnCount() {
        return this.perSpawnCount;
    }

    public void setPerSpawnCount(int perSpawnCount) {
        this.perSpawnCount = Math.max(1, perSpawnCount);
        this.m_6596_();
        this.sync();
    }

    public int getRemainingCount() {
        return this.remainingCount;
    }

    public void setRemainingCount(int remainingCount) {
        this.remainingCount = Math.max(0, remainingCount);
        this.m_6596_();
        this.sync();
    }

    public int getMinInterval() {
        return this.minInterval;
    }

    public void setMinInterval(int minInterval) {
        this.minInterval = Math.max(0, minInterval);
        this.m_6596_();
        this.sync();
    }

    public int getMaxInterval() {
        return this.maxInterval;
    }

    public void setMaxInterval(int maxInterval) {
        this.maxInterval = Math.max(0, maxInterval);
        this.m_6596_();
        this.sync();
    }

    public int getCurrentInterval() {
        return this.currentInterval;
    }

    public void setCurrentInterval(int currentInterval) {
        this.currentInterval = Math.max(0, currentInterval);
        this.m_6596_();
        this.sync();
    }

    public int getMaxActiveEntities() {
        return this.maxActiveEntities;
    }

    public void setMaxActiveEntities(int maxActiveEntities) {
        this.maxActiveEntities = Math.max(0, maxActiveEntities);
        this.m_6596_();
        this.sync();
    }

    public boolean isInfiniteSummon() {
        return this.infiniteSummon;
    }

    public void setInfiniteSummon(boolean infiniteSummon) {
        this.infiniteSummon = infiniteSummon;
        this.m_6596_();
        this.sync();
    }

    public long getResetInterval() {
        return this.resetInterval;
    }

    public void setResetInterval(long resetInterval) {
        this.resetInterval = Math.max(0L, resetInterval);
        this.m_6596_();
        this.sync();
    }

    public long getCurrentResetCooldown() {
        return this.currentResetCooldown;
    }

    public void setCurrentResetCooldown(long currentResetCooldown) {
        this.currentResetCooldown = Math.max(0L, currentResetCooldown);
        this.m_6596_();
        this.sync();
    }

    public boolean isShowActivationRange() {
        return this.showActivationRange;
    }

    public void setShowActivationRange(boolean showActivationRange) {
        this.showActivationRange = showActivationRange;
        this.m_6596_();
        this.sync();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
        this.m_6596_();
        this.sync();
    }

    public boolean isPeriodicResetEnabled() {
        return this.periodicReset;
    }

    public void setPeriodicReset(boolean periodicReset) {
        boolean newValue;
        this.periodicReset = newValue = periodicReset && this.savedState != null;
        if (newValue && this.currentResetCooldown <= 0L && this.resetInterval > 0L) {
            this.currentResetCooldown = this.resetInterval;
        }
        this.m_6596_();
        this.sync();
    }

    public void applyConfiguration(double activationDistance, double horizontalRange, double verticalRange, int perSpawnCount, int remainingCount, int minInterval, int maxInterval, int currentInterval, int maxActiveEntities, boolean infiniteSummon, boolean showActivationRange, boolean paused, boolean periodicReset, long resetInterval, long currentResetCooldown, List<SpawnEntry> entries) {
        boolean periodicResetEnabled;
        this.activationDistance = Math.max(0.0, activationDistance);
        this.horizontalRange = Math.max(0.0, horizontalRange);
        this.verticalRange = Math.max(0.0, verticalRange);
        this.perSpawnCount = Math.max(1, perSpawnCount);
        this.remainingCount = Math.max(0, remainingCount);
        this.minInterval = Math.max(0, minInterval);
        this.maxInterval = Math.max(this.minInterval, maxInterval);
        this.currentInterval = Math.max(0, currentInterval);
        this.maxActiveEntities = Math.max(0, maxActiveEntities);
        this.infiniteSummon = infiniteSummon;
        this.showActivationRange = showActivationRange;
        this.paused = paused;
        this.periodicReset = periodicResetEnabled = periodicReset && this.savedState != null;
        this.resetInterval = Math.max(0L, resetInterval);
        this.currentResetCooldown = Math.max(0L, currentResetCooldown);
        if (periodicResetEnabled && this.currentResetCooldown <= 0L && this.resetInterval > 0L) {
            this.currentResetCooldown = this.resetInterval;
        }
        this.spawnEntries.clear();
        entries.stream().filter(entry -> entry.weight() > 0).forEach(this.spawnEntries::add);
        if (this.infiniteSummon) {
            this.remainingCount = 0;
        }
        this.m_6596_();
        this.sync();
    }

    public SavedState getSavedState() {
        return this.savedState;
    }

    public long getLastActivationTick() {
        return this.lastActivationTick;
    }

    public long getLastResetTick() {
        return this.lastResetTick;
    }

    public long getLastTickTime() {
        return this.lastTickTime;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.activationDistance = tag.m_128459_(TAG_ACTIVATION_DISTANCE);
        this.horizontalRange = tag.m_128459_(TAG_HORIZONTAL_RANGE);
        this.verticalRange = tag.m_128459_(TAG_VERTICAL_RANGE);
        this.perSpawnCount = tag.m_128451_(TAG_PER_SPAWN);
        this.remainingCount = tag.m_128451_(TAG_REMAINING);
        this.minInterval = tag.m_128451_(TAG_MIN_INTERVAL);
        this.maxInterval = tag.m_128451_(TAG_MAX_INTERVAL);
        this.currentInterval = tag.m_128451_(TAG_CURRENT_INTERVAL);
        this.maxActiveEntities = tag.m_128451_(TAG_MAX_ACTIVE);
        this.infiniteSummon = tag.m_128471_(TAG_INFINITE);
        this.showActivationRange = tag.m_128471_(TAG_SHOW_ACTIVATION_RANGE);
        this.paused = tag.m_128471_(TAG_PAUSED);
        this.periodicReset = tag.m_128471_(TAG_PERIODIC_RESET);
        this.resetInterval = tag.m_128454_(TAG_RESET_INTERVAL);
        this.currentResetCooldown = tag.m_128454_(TAG_CURRENT_RESET_COOLDOWN);
        this.lastActivationTick = tag.m_128454_(TAG_LAST_ACTIVATION);
        this.lastTickTime = tag.m_128454_(TAG_LAST_TICK);
        this.lastResetTick = tag.m_128454_(TAG_LAST_RESET);
        this.trackedActiveEntities = tag.m_128425_(TAG_ACTIVE_COUNT, 3) ? tag.m_128451_(TAG_ACTIVE_COUNT) : 0;
        this.lastSyncedActiveEntities = this.trackedActiveEntities;
        this.lastActiveSyncTick = this.f_58857_ != null ? this.f_58857_.m_46467_() : -1L;
        this.spawnEntries.clear();
        ListTag listTag = tag.m_128437_(TAG_SPAWN_ENTRIES, 10);
        for (Tag entryTag : listTag) {
            CompoundTag entryCompound;
            SpawnEntry entry;
            if (!(entryTag instanceof CompoundTag) || (entry = SpawnEntry.fromTag(entryCompound = (CompoundTag)entryTag)) == null) continue;
            this.spawnEntries.add(entry);
        }
        this.spawnedEntities.clear();
        ListTag activeList = tag.m_128437_(TAG_ACTIVE_ENTITIES, 10);
        for (Tag activeTag : activeList) {
            if (!(activeTag instanceof CompoundTag)) continue;
            CompoundTag compoundTag = (CompoundTag)activeTag;
            this.spawnedEntities.add(NbtUtils.m_129233_((Tag)compoundTag));
        }
        this.savedState = tag.m_128425_(TAG_SAVED_STATE, 10) ? SavedState.fromTag(tag.m_128469_(TAG_SAVED_STATE)) : null;
        if (this.periodicReset && this.savedState == null) {
            this.periodicReset = false;
        }
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            // empty if block
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128347_(TAG_ACTIVATION_DISTANCE, this.activationDistance);
        tag.m_128347_(TAG_HORIZONTAL_RANGE, this.horizontalRange);
        tag.m_128347_(TAG_VERTICAL_RANGE, this.verticalRange);
        tag.m_128405_(TAG_PER_SPAWN, this.perSpawnCount);
        tag.m_128405_(TAG_REMAINING, this.remainingCount);
        tag.m_128405_(TAG_MIN_INTERVAL, this.minInterval);
        tag.m_128405_(TAG_MAX_INTERVAL, this.maxInterval);
        tag.m_128405_(TAG_CURRENT_INTERVAL, this.currentInterval);
        tag.m_128405_(TAG_MAX_ACTIVE, this.maxActiveEntities);
        tag.m_128379_(TAG_INFINITE, this.infiniteSummon);
        tag.m_128379_(TAG_SHOW_ACTIVATION_RANGE, this.showActivationRange);
        tag.m_128379_(TAG_PAUSED, this.paused);
        tag.m_128379_(TAG_PERIODIC_RESET, this.periodicReset);
        tag.m_128356_(TAG_RESET_INTERVAL, this.resetInterval);
        tag.m_128356_(TAG_CURRENT_RESET_COOLDOWN, this.currentResetCooldown);
        tag.m_128356_(TAG_LAST_ACTIVATION, this.lastActivationTick);
        tag.m_128356_(TAG_LAST_TICK, this.lastTickTime);
        tag.m_128356_(TAG_LAST_RESET, this.lastResetTick);
        tag.m_128405_(TAG_ACTIVE_COUNT, this.trackedActiveEntities);
        ListTag listTag = new ListTag();
        for (SpawnEntry entry : this.spawnEntries) {
            listTag.add((Object)entry.toTag());
        }
        tag.m_128365_(TAG_SPAWN_ENTRIES, (Tag)listTag);
        ListTag activeList = new ListTag();
        for (UUID uuid : this.spawnedEntities) {
            activeList.add((Object)NbtUtils.m_129226_((UUID)uuid));
        }
        tag.m_128365_(TAG_ACTIVE_ENTITIES, (Tag)activeList);
        if (this.savedState != null) {
            tag.m_128365_(TAG_SAVED_STATE, (Tag)this.savedState.toTag());
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = this.m_187482_();
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            // empty if block
        }
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void sync() {
        Level level = this.m_58904_();
        if (level == null) {
            return;
        }
        level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public void m_187476_(ItemStack stack) {
        CompoundTag tag = this.createItemExportTag();
        BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)this.m_58903_(), (CompoundTag)tag);
    }

    private CompoundTag createItemExportTag() {
        CompoundTag tag = this.m_187482_();
        tag.m_128365_(TAG_ACTIVE_ENTITIES, (Tag)new ListTag());
        tag.m_128405_(TAG_ACTIVE_COUNT, 0);
        tag.m_128356_(TAG_LAST_ACTIVATION, -1L);
        tag.m_128356_(TAG_LAST_TICK, -1L);
        tag.m_128356_(TAG_LAST_RESET, -1L);
        int clampedInterval = Math.max(0, tag.m_128451_(TAG_CURRENT_INTERVAL));
        tag.m_128405_(TAG_CURRENT_INTERVAL, clampedInterval);
        long clampedReset = Math.max(0L, tag.m_128454_(TAG_CURRENT_RESET_COOLDOWN));
        tag.m_128356_(TAG_CURRENT_RESET_COOLDOWN, clampedReset);
        return tag;
    }

    private boolean hasNearbyPlayer(ServerLevel level) {
        if (this.activationDistance <= 0.0) {
            return true;
        }
        return level.m_45924_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, this.activationDistance, false) != null;
    }

    public record SavedState(double activationDistance, double horizontalRange, double verticalRange, int perSpawnCount, int remainingCount, int minInterval, int maxInterval, int currentInterval, int maxActiveEntities, boolean infiniteSummon, long resetInterval, List<SpawnEntry> spawnEntries) {
        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128347_(SpawnPointBlockEntity.TAG_ACTIVATION_DISTANCE, this.activationDistance);
            tag.m_128347_(SpawnPointBlockEntity.TAG_HORIZONTAL_RANGE, this.horizontalRange);
            tag.m_128347_(SpawnPointBlockEntity.TAG_VERTICAL_RANGE, this.verticalRange);
            tag.m_128405_(SpawnPointBlockEntity.TAG_PER_SPAWN, this.perSpawnCount);
            tag.m_128405_(SpawnPointBlockEntity.TAG_REMAINING, this.remainingCount);
            tag.m_128405_(SpawnPointBlockEntity.TAG_MIN_INTERVAL, this.minInterval);
            tag.m_128405_(SpawnPointBlockEntity.TAG_MAX_INTERVAL, this.maxInterval);
            tag.m_128405_(SpawnPointBlockEntity.TAG_CURRENT_INTERVAL, this.currentInterval);
            tag.m_128405_(SpawnPointBlockEntity.TAG_MAX_ACTIVE, this.maxActiveEntities);
            tag.m_128379_(SpawnPointBlockEntity.TAG_INFINITE, this.infiniteSummon);
            tag.m_128356_(SpawnPointBlockEntity.TAG_RESET_INTERVAL, this.resetInterval);
            ListTag listTag = new ListTag();
            for (SpawnEntry entry : this.spawnEntries) {
                listTag.add((Object)entry.toTag());
            }
            tag.m_128365_(SpawnPointBlockEntity.TAG_SPAWN_ENTRIES, (Tag)listTag);
            return tag;
        }

        public static SavedState fromTag(CompoundTag tag) {
            double activationDistance = tag.m_128459_(SpawnPointBlockEntity.TAG_ACTIVATION_DISTANCE);
            double horizontalRange = tag.m_128459_(SpawnPointBlockEntity.TAG_HORIZONTAL_RANGE);
            double verticalRange = tag.m_128459_(SpawnPointBlockEntity.TAG_VERTICAL_RANGE);
            int perSpawn = tag.m_128451_(SpawnPointBlockEntity.TAG_PER_SPAWN);
            int remaining = tag.m_128451_(SpawnPointBlockEntity.TAG_REMAINING);
            int minInterval = tag.m_128451_(SpawnPointBlockEntity.TAG_MIN_INTERVAL);
            int maxInterval = tag.m_128451_(SpawnPointBlockEntity.TAG_MAX_INTERVAL);
            int currentInterval = tag.m_128451_(SpawnPointBlockEntity.TAG_CURRENT_INTERVAL);
            int maxActive = tag.m_128451_(SpawnPointBlockEntity.TAG_MAX_ACTIVE);
            boolean infinite = tag.m_128471_(SpawnPointBlockEntity.TAG_INFINITE);
            long reset = tag.m_128454_(SpawnPointBlockEntity.TAG_RESET_INTERVAL);
            ArrayList entries = Lists.newArrayList();
            ListTag listTag = tag.m_128437_(SpawnPointBlockEntity.TAG_SPAWN_ENTRIES, 10);
            for (Tag entryTag : listTag) {
                CompoundTag entryCompound;
                SpawnEntry entry;
                if (!(entryTag instanceof CompoundTag) || (entry = SpawnEntry.fromTag(entryCompound = (CompoundTag)entryTag)) == null) continue;
                entries.add(entry);
            }
            return new SavedState(activationDistance, horizontalRange, verticalRange, perSpawn, remaining, minInterval, maxInterval, currentInterval, maxActive, infinite, reset, entries);
        }
    }

    public record SpawnEntry(ResourceLocation entityId, int weight, int level, int equipmentLevel) {
        public SpawnEntry {
            weight = Math.max(1, weight);
            level = Math.max(1, level);
            equipmentLevel = Math.max(1, equipmentLevel);
        }

        public static SpawnEntry fromTag(CompoundTag tag) {
            if (!tag.m_128441_("id")) {
                return null;
            }
            ResourceLocation id = new ResourceLocation(tag.m_128461_("id"));
            int weight = tag.m_128451_("weight");
            if (weight <= 0) {
                return null;
            }
            int level = tag.m_128441_("level") ? Math.max(1, tag.m_128451_("level")) : 1;
            int equipmentLevel = tag.m_128441_("equipment_level") ? Math.max(1, tag.m_128451_("equipment_level")) : level;
            return new SpawnEntry(id, weight, level, equipmentLevel);
        }

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("id", this.entityId.toString());
            tag.m_128405_("weight", Math.max(1, this.weight));
            tag.m_128405_("level", Math.max(1, this.level));
            tag.m_128405_("equipment_level", Math.max(1, this.equipmentLevel));
            return tag;
        }
    }
}

