/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.supply;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.entity.utils.BaseCombatSupport;
import ydmsama.hundred_years_war.main.supply.SupplyPointBlockEntity;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

public class SupplyManager {
    private static final Map<UUID, SupplyRelation> entityRelations = new ConcurrentHashMap<UUID, SupplyRelation>();
    private static final Map<UUID, SupplySource> supplySources = new ConcurrentHashMap<UUID, SupplySource>();
    private static final Map<UUID, Long> lastDamageTime = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, Long> noSupplyStartTime = new ConcurrentHashMap<UUID, Long>();
    private static final double SUPPLY_RANGE = 100.0;
    private static final long SUPPLY_CHECK_INTERVAL = 1200000L;
    private static final long DAMAGE_INTERVAL = 10000L;
    private static final long DAMAGE_START_DELAY = 60000L;
    private static final int NO_SUPPLY_EFFECT_DURATION = 24000;
    private static final int NO_SUPPLY_WEAKNESS_LEVEL = 3;
    private static final int NO_SUPPLY_SLOWNESS_LEVEL = 1;
    private static final float MIN_SUPPLY_DAMAGE_HEALTH = 2.0f;
    private static final double TICKS_PER_MINECRAFT_DAY = 24000.0;

    public static void tick(ServerLevel level) {
        if (!ServerModConfig.INSTANCE.isEnableSupplySystem()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        HashSet<UUID> relationsToRemove = new HashSet<UUID>();
        HashMap<UUID, BaseCombatSupport> relationsToReestablish = new HashMap<UUID, BaseCombatSupport>();
        for (Map.Entry<UUID, SupplyRelation> entry : entityRelations.entrySet()) {
            UUID entityId2 = entry.getKey();
            SupplyRelation relation = entry.getValue();
            Entity entity = level.m_8791_(entityId2);
            if (entity instanceof BaseCombatSupport) {
                Long lastDamage;
                BaseCombatSupport combatEntity = (BaseCombatSupport)entity;
                if (!combatEntity.requiresSupply() || !entity.m_6084_()) {
                    relationsToRemove.add(entityId2);
                    continue;
                }
                relation.updateEntityPos(entity.m_20183_());
                if (relation.getDistance() > 100.0) {
                    relationsToRemove.add(entityId2);
                    relationsToReestablish.put(entityId2, combatEntity);
                    continue;
                }
                SupplySource source = supplySources.get(relation.getSourceId());
                if (source == null) {
                    relationsToRemove.add(entityId2);
                    relationsToReestablish.put(entityId2, combatEntity);
                    continue;
                }
                if (!SupplyManager.isSourceFriendlyWithEntity(source, combatEntity)) {
                    relationsToRemove.add(entityId2);
                    relationsToReestablish.put(entityId2, combatEntity);
                    continue;
                }
                double dailyConsumption = Math.max(0.0, combatEntity.getDailySupplyConsumption());
                relation.setDailyConsumption(dailyConsumption);
                double consumptionPerTick = dailyConsumption / 24000.0;
                if (source.getSupplyValue() <= 0.0 || consumptionPerTick > 0.0 && source.getSupplyValue() < consumptionPerTick) {
                    relationsToRemove.add(entityId2);
                    relationsToReestablish.put(entityId2, combatEntity);
                    continue;
                }
                if (source.consumeSupply(consumptionPerTick)) {
                    relation.updateSupplyTime();
                    combatEntity.asLivingEntity().m_21195_(MobEffects.f_19612_);
                    combatEntity.asLivingEntity().m_21195_(MobEffects.f_19597_);
                    combatEntity.asLivingEntity().m_21195_(MobEffects.f_19613_);
                    noSupplyStartTime.remove(entityId2);
                    continue;
                }
                SupplyManager.applyNoSupplyEffects(combatEntity, entityId2, currentTime, level);
                if (!relation.isExpired() || (lastDamage = lastDamageTime.get(entityId2)) != null && currentTime - lastDamage <= 10000L) continue;
                combatEntity.asLivingEntity().m_6469_(combatEntity.asLivingEntity().m_269291_().m_269064_(), 1.0f);
                lastDamageTime.put(entityId2, currentTime);
                continue;
            }
            if (entity != null && entity.m_6084_()) continue;
            relationsToRemove.add(entityId2);
        }
        if (!relationsToRemove.isEmpty()) {
            for (UUID entityId3 : relationsToRemove) {
                SupplyManager.removeSupplyRelation(entityId3);
            }
        }
        if (!relationsToReestablish.isEmpty()) {
            for (BaseCombatSupport combatEntity : relationsToReestablish.values()) {
                SupplyManager.tryEstablishSupply(combatEntity, (Level)level);
            }
        }
        Iterator<Map.Entry<UUID, SupplySource>> sourceIterator = supplySources.entrySet().iterator();
        while (sourceIterator.hasNext()) {
            BlockEntity blockEntity;
            Map.Entry<UUID, SupplySource> sourceEntry = sourceIterator.next();
            SupplySource source = sourceEntry.getValue();
            source.getSuppliedEntities().removeIf(entityId -> !entityRelations.containsKey(entityId));
            if (source.getSupplyValue() <= 0.0 && !source.getSuppliedEntities().isEmpty()) {
                for (UUID entityId4 : new ArrayList<UUID>(source.getSuppliedEntities())) {
                    SupplyManager.removeSupplyRelation(entityId4);
                    Entity entity = level.m_8791_(entityId4);
                    if (!(entity instanceof BaseCombatSupport)) continue;
                    BaseCombatSupport combatEntity = (BaseCombatSupport)entity;
                    SupplyManager.tryEstablishSupply(combatEntity, (Level)level);
                }
            }
            if (source.getType() != SupplySourceType.SUPPLY_POINT || (blockEntity = SupplyManager.findSupplyPointBlockEntity((Level)level, source.getId())) != null) continue;
            for (UUID entityId5 : new ArrayList<UUID>(source.getSuppliedEntities())) {
                SupplyManager.removeSupplyRelation(entityId5);
            }
            sourceIterator.remove();
        }
    }

    public static void tryEstablishSupply(BaseCombatSupport entity, Level level) {
        if (!entity.requiresSupply()) {
            return;
        }
        if (!ServerModConfig.INSTANCE.isEnableSupplySystem()) {
            return;
        }
        LivingEntity livingEntity = entity.asLivingEntity();
        UUID entityId = livingEntity.m_20148_();
        if (entityRelations.containsKey(entityId)) {
            return;
        }
        BlockPos entityPos = livingEntity.m_20183_();
        SupplySource nearestSource = null;
        double nearestDistance = 101.0;
        BlockPos nearestSourcePos = null;
        for (Map.Entry<UUID, SupplySource> entry : supplySources.entrySet()) {
            double distance;
            Player player;
            SupplySource source = entry.getValue();
            BlockPos sourcePos = null;
            if (source.getType() == SupplySourceType.SUPPLY_POINT) {
                BlockEntity blockEntity;
                sourcePos = source.getBlockPos();
                if (sourcePos != null && !((blockEntity = level.m_7702_(sourcePos)) instanceof SupplyPointBlockEntity)) {
                    sourcePos = null;
                }
            } else if (source.getType() == SupplySourceType.PLAYER && (player = level.m_46003_(source.getId())) != null) {
                sourcePos = player.m_20183_();
            }
            if (sourcePos == null || !((distance = Math.sqrt(entityPos.m_123331_((Vec3i)sourcePos))) < nearestDistance) || !(distance <= 100.0) || !(source.getSupplyValue() > 0.0) || !SupplyManager.isSourceFriendlyWithEntity(source, entity)) continue;
            nearestSource = source;
            nearestDistance = distance;
            nearestSourcePos = sourcePos;
        }
        if (nearestSource != null) {
            SupplyRelation relation = new SupplyRelation(entityId, nearestSource.getId(), nearestSource.getType(), entityPos, nearestSourcePos);
            relation.setDailyConsumption(Math.max(0.0, entity.getDailySupplyConsumption()));
            entityRelations.put(entityId, relation);
            nearestSource.getSuppliedEntities().add(entityId);
        } else if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SupplyManager.applyNoSupplyEffects(entity, entityId, System.currentTimeMillis(), serverLevel);
        }
    }

    public static void removeSupplyRelation(UUID entityId) {
        SupplySource source;
        SupplyRelation relation = entityRelations.remove(entityId);
        if (relation != null && (source = supplySources.get(relation.getSourceId())) != null) {
            source.getSuppliedEntities().remove(entityId);
        }
        lastDamageTime.remove(entityId);
        noSupplyStartTime.remove(entityId);
    }

    public static void registerSupplySource(UUID sourceId, SupplySourceType type, double maxSupply) {
        SupplySource source = supplySources.get(sourceId);
        if (source == null) {
            source = new SupplySource(sourceId, type, maxSupply);
            supplySources.put(sourceId, source);
        } else {
            source.setMaxSupplyValue(maxSupply);
        }
        if (type == SupplySourceType.PLAYER && source.getOwnerId() == null) {
            source.setOwnerId(sourceId);
        }
    }

    public static void registerSupplySource(UUID sourceId, SupplySourceType type, double maxSupply, BlockPos blockPos) {
        SupplySource source = supplySources.get(sourceId);
        if (source == null) {
            source = new SupplySource(sourceId, type, maxSupply, blockPos);
            supplySources.put(sourceId, source);
        } else {
            source.setMaxSupplyValue(maxSupply);
            source.setBlockPos(blockPos);
        }
        if (type == SupplySourceType.PLAYER && source.getOwnerId() == null) {
            source.setOwnerId(sourceId);
        }
    }

    public static void unregisterSupplySource(UUID sourceId) {
        SupplySource source = supplySources.remove(sourceId);
        if (source != null) {
            for (UUID entityId : source.getSuppliedEntities()) {
                entityRelations.remove(entityId);
                lastDamageTime.remove(entityId);
                noSupplyStartTime.remove(entityId);
            }
        }
    }

    public static SupplySource getSupplySource(UUID sourceId) {
        return supplySources.get(sourceId);
    }

    public static double convertFoodToSupply(int foodValue) {
        return (double)foodValue * 0.5;
    }

    public static double getDailyConsumption(UUID sourceId) {
        SupplySource source = supplySources.get(sourceId);
        if (source == null) {
            return 0.0;
        }
        double totalConsumption = 0.0;
        for (UUID entityId : source.getSuppliedEntities()) {
            SupplyRelation relation = entityRelations.get(entityId);
            if (relation == null || !relation.getSourceId().equals(sourceId)) continue;
            totalConsumption += Math.max(0.0, relation.getDailyConsumption());
        }
        return totalConsumption;
    }

    private static BlockEntity findSupplyPointBlockEntity(Level level, UUID blockEntityId) {
        SupplySource source = supplySources.get(blockEntityId);
        if (source != null && source.getBlockPos() != null) {
            return level.m_7702_(source.getBlockPos());
        }
        return null;
    }

    public static void saveData(Path savePath) throws IOException {
        CompoundTag rootTag = new CompoundTag();
        ListTag relationsList = new ListTag();
        for (SupplyRelation supplyRelation : entityRelations.values()) {
            relationsList.add((Object)supplyRelation.saveToNbt());
        }
        rootTag.m_128365_("Relations", (Tag)relationsList);
        ListTag sourcesList = new ListTag();
        for (SupplySource supplySource : supplySources.values()) {
            sourcesList.add((Object)supplySource.saveToNbt());
        }
        rootTag.m_128365_("Sources", (Tag)sourcesList);
        ListTag listTag = new ListTag();
        for (Map.Entry<UUID, Long> entry : lastDamageTime.entrySet()) {
            CompoundTag damageTag = new CompoundTag();
            damageTag.m_128362_("EntityId", entry.getKey());
            damageTag.m_128356_("LastDamage", entry.getValue().longValue());
            listTag.add((Object)damageTag);
        }
        rootTag.m_128365_("DamageTimes", (Tag)listTag);
        ListTag listTag2 = new ListTag();
        for (Map.Entry<UUID, Long> entry : noSupplyStartTime.entrySet()) {
            CompoundTag noSupplyTag = new CompoundTag();
            noSupplyTag.m_128362_("EntityId", entry.getKey());
            noSupplyTag.m_128356_("StartTime", entry.getValue().longValue());
            listTag2.add((Object)noSupplyTag);
        }
        rootTag.m_128365_("NoSupplyTimes", (Tag)listTag2);
        NbtIo.m_128944_((CompoundTag)rootTag, (File)savePath.toFile());
    }

    public static void loadData(Path savePath) {
        entityRelations.clear();
        supplySources.clear();
        lastDamageTime.clear();
        noSupplyStartTime.clear();
        if (Files.exists(savePath, new LinkOption[0])) {
            try {
                CompoundTag rootTag = NbtIo.m_128937_((File)savePath.toFile());
                ListTag relationsList = rootTag.m_128437_("Relations", 10);
                for (int i = 0; i < relationsList.size(); ++i) {
                    SupplyRelation relation = SupplyRelation.loadFromNbt(relationsList.m_128728_(i));
                    entityRelations.put(relation.getEntityId(), relation);
                }
                ListTag sourcesList = rootTag.m_128437_("Sources", 10);
                for (int i = 0; i < sourcesList.size(); ++i) {
                    SupplySource source = SupplySource.loadFromNbt(sourcesList.m_128728_(i));
                    if (source.getType() == SupplySourceType.PLAYER && source.getOwnerId() == null) {
                        source.setOwnerId(source.getId());
                    }
                    supplySources.put(source.getId(), source);
                }
                ListTag damageList = rootTag.m_128437_("DamageTimes", 10);
                for (int i = 0; i < damageList.size(); ++i) {
                    CompoundTag damageTag = damageList.m_128728_(i);
                    lastDamageTime.put(damageTag.m_128342_("EntityId"), damageTag.m_128454_("LastDamage"));
                }
                if (rootTag.m_128441_("NoSupplyTimes")) {
                    ListTag noSupplyList = rootTag.m_128437_("NoSupplyTimes", 10);
                    for (int i = 0; i < noSupplyList.size(); ++i) {
                        CompoundTag noSupplyTag = noSupplyList.m_128728_(i);
                        noSupplyStartTime.put(noSupplyTag.m_128342_("EntityId"), noSupplyTag.m_128454_("StartTime"));
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Map<UUID, SupplyRelation> getEntityRelations() {
        return new HashMap<UUID, SupplyRelation>(entityRelations);
    }

    public static Map<UUID, SupplySource> getSupplySources() {
        return new HashMap<UUID, SupplySource>(supplySources);
    }

    public static void setSupplySourceOwner(UUID sourceId, UUID ownerId) {
        SupplySource source = supplySources.get(sourceId);
        if (source != null) {
            source.setOwnerId(ownerId);
        }
    }

    public static boolean hasActiveSupply(BaseCombatSupport entity) {
        if (entity == null) {
            return false;
        }
        if (!ServerModConfig.INSTANCE.isEnableSupplySystem()) {
            return true;
        }
        if (!entity.requiresSupply()) {
            return true;
        }
        SupplyRelation relation = entityRelations.get(entity.getUUID());
        return relation != null && !relation.isExpired();
    }

    private static boolean isSourceFriendlyWithEntity(SupplySource source, BaseCombatSupport entity) {
        UUID sourceOwner;
        if (source == null || entity == null) {
            return false;
        }
        UUID entityOwner = entity.m_21805_();
        if (entityOwner == null) {
            return false;
        }
        if (source.getType() == SupplySourceType.PLAYER && source.getOwnerId() == null) {
            source.setOwnerId(source.getId());
        }
        if ((sourceOwner = source.getOwnerId()) == null) {
            return true;
        }
        if (sourceOwner.equals(entityOwner)) {
            return true;
        }
        RelationSystem.RelationType forward = RelationSystem.getRelation(sourceOwner, entityOwner);
        RelationSystem.RelationType backward = RelationSystem.getRelation(entityOwner, sourceOwner);
        if (forward == RelationSystem.RelationType.HOSTILE || backward == RelationSystem.RelationType.HOSTILE) {
            return false;
        }
        return forward == RelationSystem.RelationType.FRIENDLY || forward == RelationSystem.RelationType.CONTROL || backward == RelationSystem.RelationType.FRIENDLY || backward == RelationSystem.RelationType.CONTROL;
    }

    private static void applyNoSupplyEffects(BaseCombatSupport entity, UUID entityId, long currentTime, ServerLevel level) {
        noSupplyStartTime.putIfAbsent(entityId, currentTime);
        long noSupplyDuration = currentTime - noSupplyStartTime.get(entityId);
        LivingEntity livingEntity = entity.asLivingEntity();
        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 60, 0, false, false));
        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 24000, Math.max(0, 0), false, false));
        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 24000, Math.max(0, 2), false, false));
        if (livingEntity.f_19797_ % 40 == 0) {
            level.m_8767_((ParticleOptions)ParticleTypes.f_123792_, livingEntity.m_20185_(), livingEntity.m_20186_() + (double)livingEntity.m_20206_() + 0.3, livingEntity.m_20189_(), 1, 0.3, 0.3, 0.3, 0.0);
        }
        if (noSupplyDuration > 60000L) {
            Long lastDamage = lastDamageTime.get(entityId);
            if (livingEntity.m_21223_() > 2.0f && (lastDamage == null || currentTime - lastDamage > 10000L)) {
                livingEntity.m_6469_(livingEntity.m_269291_().m_269064_(), 1.0f);
                lastDamageTime.put(entityId, currentTime);
            }
        }
    }

    public static class SupplyRelation {
        private final UUID entityId;
        private final UUID sourceId;
        private final SupplySourceType sourceType;
        private BlockPos lastKnownEntityPos;
        private BlockPos sourcePos;
        private long lastSupplyTime;
        private long establishedTime;
        private double dailyConsumption;

        public SupplyRelation(UUID entityId, UUID sourceId, SupplySourceType sourceType, BlockPos entityPos, BlockPos sourcePos) {
            this.entityId = entityId;
            this.sourceId = sourceId;
            this.sourceType = sourceType;
            this.lastKnownEntityPos = entityPos;
            this.sourcePos = sourcePos;
            this.lastSupplyTime = System.currentTimeMillis();
            this.establishedTime = System.currentTimeMillis();
            this.dailyConsumption = 0.0;
        }

        public void updateEntityPos(BlockPos pos) {
            this.lastKnownEntityPos = pos;
        }

        public void updateSupplyTime() {
            this.lastSupplyTime = System.currentTimeMillis();
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.lastSupplyTime > 1200000L;
        }

        public double getDistance() {
            if (this.lastKnownEntityPos == null || this.sourcePos == null) {
                return Double.MAX_VALUE;
            }
            return Math.sqrt(this.lastKnownEntityPos.m_123331_((Vec3i)this.sourcePos));
        }

        public CompoundTag saveToNbt() {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("EntityId", this.entityId);
            tag.m_128362_("SourceId", this.sourceId);
            tag.m_128359_("SourceType", this.sourceType.name());
            tag.m_128347_("DailyConsumption", this.dailyConsumption);
            if (this.lastKnownEntityPos != null) {
                tag.m_128356_("EntityPos", this.lastKnownEntityPos.m_121878_());
            }
            if (this.sourcePos != null) {
                tag.m_128356_("SourcePos", this.sourcePos.m_121878_());
            }
            tag.m_128356_("LastSupplyTime", this.lastSupplyTime);
            tag.m_128356_("EstablishedTime", this.establishedTime);
            return tag;
        }

        public static SupplyRelation loadFromNbt(CompoundTag tag) {
            UUID entityId = tag.m_128342_("EntityId");
            UUID sourceId = tag.m_128342_("SourceId");
            SupplySourceType sourceType = SupplySourceType.valueOf(tag.m_128461_("SourceType"));
            BlockPos entityPos = tag.m_128441_("EntityPos") ? BlockPos.m_122022_((long)tag.m_128454_("EntityPos")) : null;
            BlockPos sourcePos = tag.m_128441_("SourcePos") ? BlockPos.m_122022_((long)tag.m_128454_("SourcePos")) : null;
            SupplyRelation relation = new SupplyRelation(entityId, sourceId, sourceType, entityPos, sourcePos);
            relation.lastSupplyTime = tag.m_128454_("LastSupplyTime");
            relation.establishedTime = tag.m_128454_("EstablishedTime");
            relation.dailyConsumption = Math.max(0.0, tag.m_128459_("DailyConsumption"));
            return relation;
        }

        public UUID getEntityId() {
            return this.entityId;
        }

        public UUID getSourceId() {
            return this.sourceId;
        }

        public SupplySourceType getSourceType() {
            return this.sourceType;
        }

        public BlockPos getLastKnownEntityPos() {
            return this.lastKnownEntityPos;
        }

        public BlockPos getSourcePos() {
            return this.sourcePos;
        }

        public long getLastSupplyTime() {
            return this.lastSupplyTime;
        }

        public double getDailyConsumption() {
            return this.dailyConsumption;
        }

        public void setDailyConsumption(double dailyConsumption) {
            this.dailyConsumption = Math.max(0.0, dailyConsumption);
        }
    }

    public static class SupplySource {
        private final UUID id;
        private final SupplySourceType type;
        private double supplyValue;
        private double maxSupplyValue;
        private final Set<UUID> suppliedEntities;
        private BlockPos blockPos;
        private UUID ownerId;

        public SupplySource(UUID id, SupplySourceType type, double maxSupplyValue) {
            this.id = id;
            this.type = type;
            this.supplyValue = 0.0;
            this.maxSupplyValue = maxSupplyValue;
            this.suppliedEntities = new HashSet<UUID>();
        }

        public SupplySource(UUID id, SupplySourceType type, double maxSupplyValue, BlockPos blockPos) {
            this(id, type, maxSupplyValue);
            this.blockPos = blockPos;
        }

        public boolean canSupply(double amount) {
            return this.supplyValue >= amount;
        }

        public boolean consumeSupply(double amount) {
            if (this.canSupply(amount)) {
                this.supplyValue -= amount;
                return true;
            }
            return false;
        }

        public void addSupply(double amount) {
            this.supplyValue = Math.min(this.supplyValue + amount, this.maxSupplyValue);
        }

        public CompoundTag saveToNbt() {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("Id", this.id);
            tag.m_128359_("Type", this.type.name());
            tag.m_128347_("SupplyValue", this.supplyValue);
            tag.m_128347_("MaxSupplyValue", this.maxSupplyValue);
            if (this.blockPos != null) {
                tag.m_128356_("BlockPos", this.blockPos.m_121878_());
            }
            if (this.ownerId != null) {
                tag.m_128362_("OwnerId", this.ownerId);
            }
            ListTag entitiesList = new ListTag();
            for (UUID entityId : this.suppliedEntities) {
                CompoundTag entityTag = new CompoundTag();
                entityTag.m_128362_("EntityId", entityId);
                entitiesList.add((Object)entityTag);
            }
            tag.m_128365_("SuppliedEntities", (Tag)entitiesList);
            return tag;
        }

        public static SupplySource loadFromNbt(CompoundTag tag) {
            UUID id = tag.m_128342_("Id");
            SupplySourceType type = SupplySourceType.valueOf(tag.m_128461_("Type"));
            double maxSupplyValue = tag.m_128459_("MaxSupplyValue");
            BlockPos blockPos = tag.m_128441_("BlockPos") ? BlockPos.m_122022_((long)tag.m_128454_("BlockPos")) : null;
            SupplySource source = blockPos != null ? new SupplySource(id, type, maxSupplyValue, blockPos) : new SupplySource(id, type, maxSupplyValue);
            source.supplyValue = tag.m_128459_("SupplyValue");
            if (tag.m_128441_("OwnerId")) {
                source.ownerId = tag.m_128342_("OwnerId");
            }
            ListTag entitiesList = tag.m_128437_("SuppliedEntities", 10);
            for (int i = 0; i < entitiesList.size(); ++i) {
                CompoundTag entityTag = entitiesList.m_128728_(i);
                source.suppliedEntities.add(entityTag.m_128342_("EntityId"));
            }
            return source;
        }

        public UUID getId() {
            return this.id;
        }

        public SupplySourceType getType() {
            return this.type;
        }

        public double getSupplyValue() {
            return this.supplyValue;
        }

        public double getMaxSupplyValue() {
            return this.maxSupplyValue;
        }

        public Set<UUID> getSuppliedEntities() {
            return this.suppliedEntities;
        }

        public void setSupplyValue(double value) {
            this.supplyValue = Math.min(value, this.maxSupplyValue);
        }

        public BlockPos getBlockPos() {
            return this.blockPos;
        }

        public void setBlockPos(BlockPos pos) {
            this.blockPos = pos;
        }

        public UUID getOwnerId() {
            return this.ownerId;
        }

        public void setOwnerId(UUID ownerId) {
            this.ownerId = ownerId;
        }

        public void setMaxSupplyValue(double maxSupplyValue) {
            this.maxSupplyValue = maxSupplyValue;
        }
    }

    public static enum SupplySourceType {
        SUPPLY_POINT,
        PLAYER;

    }
}

