/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.supply;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.OpenWorkstationSyncPacket;
import ydmsama.hundred_years_war.main.supply.SupplyPointBlockEntity;

public class SupplyPointBlock
extends BaseEntityBlock {
    public SupplyPointBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60978_(0.5f));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SupplyPointBlockEntity) {
            SupplyPointBlockEntity supplyPointEntity = (SupplyPointBlockEntity)blockEntity;
            if (!level.f_46443_) {
                if (supplyPointEntity.getOwnerUuid() == null) {
                    supplyPointEntity.setOwner(player);
                }
                if (!supplyPointEntity.canPlayerAccess(player)) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.hundred_years_war.supply_point.cannot_access"), true);
                    return InteractionResult.FAIL;
                }
                supplyPointEntity.m_6596_();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ServerPacketHandler.sendOpenWorkstationSync(serverPlayer, pos, OpenWorkstationSyncPacket.WorkstationType.SUPPLY_POINT);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.m_6402_(level, pos, state, placer, stack);
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof SupplyPointBlockEntity) {
            SupplyPointBlockEntity supplyPoint = (SupplyPointBlockEntity)blockEntity;
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128441_("BlockEntityTag")) {
                CompoundTag blockEntityTag = tag.m_128469_("BlockEntityTag");
                supplyPoint.m_142466_(blockEntityTag);
                supplyPoint.m_6596_();
            }
            if (placer instanceof Player) {
                Player player = (Player)placer;
                supplyPoint.setOwner(player);
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SupplyPointBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (!level.f_46443_) {
            return SupplyPointBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.SUPPLY_POINT.get()), (world, pos, blockState, blockEntity) -> blockEntity.tick());
        }
        return null;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && !state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof SupplyPointBlockEntity) {
            SupplyPointBlockEntity supplyPoint = (SupplyPointBlockEntity)blockEntity;
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)supplyPoint);
            ItemStack stack = new ItemStack((ItemLike)this);
            CompoundTag blockEntityTag = supplyPoint.m_187482_();
            blockEntityTag.m_128473_("Items");
            if (!blockEntityTag.m_128456_()) {
                stack.m_41700_("BlockEntityTag", (Tag)blockEntityTag);
            }
            Containers.m_18992_((Level)level, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (ItemStack)stack);
            supplyPoint.m_6211_();
        }
        super.m_6810_(state, level, pos, newState, moved);
    }
}

