/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.supply;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.supply.SupplyManager;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

public class SupplyPointBlockEntity
extends BlockEntity
implements Container {
    private static final int CONTAINER_SIZE = 9;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private UUID blockEntityId = UUID.randomUUID();
    private double storedSupply = 0.0;
    private double maxStoredSupply = 1000.0;
    private int conversionProgress = 0;
    private static final int CONVERSION_RATE = 10;
    private double supplyToTransfer = 0.0;
    private boolean showRange = false;
    private UUID ownerUuid;
    private String ownerName = "";

    public SupplyPointBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.SUPPLY_POINT.get(), pos, blockState);
        SupplyManager.registerSupplySource(this.blockEntityId, SupplyManager.SupplySourceType.SUPPLY_POINT, this.maxStoredSupply, pos);
        SupplyManager.SupplySource source = SupplyManager.getSupplySource(this.blockEntityId);
        if (source != null) {
            source.setSupplyValue(this.storedSupply);
        }
    }

    public void setOwner(Player player) {
        if (player != null) {
            this.setOwner(player.m_20148_(), player.m_36316_().getName());
        }
    }

    public void setOwner(UUID ownerUuid, String ownerName) {
        this.ownerUuid = ownerUuid;
        this.ownerName = ownerName != null ? ownerName : "";
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            SupplyManager.setSupplySourceOwner(this.blockEntityId, ownerUuid);
            SupplyManager.registerSupplySource(this.blockEntityId, SupplyManager.SupplySourceType.SUPPLY_POINT, this.maxStoredSupply, this.m_58899_());
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public UUID getOwnerUuid() {
        return this.ownerUuid;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public boolean canPlayerAccess(Player player) {
        if (player == null) {
            return false;
        }
        if (this.ownerUuid == null) {
            return true;
        }
        UUID playerUuid = player.m_20148_();
        if (this.ownerUuid.equals(playerUuid)) {
            return true;
        }
        RelationSystem.RelationType forward = RelationSystem.getRelation(this.ownerUuid, playerUuid);
        RelationSystem.RelationType backward = RelationSystem.getRelation(playerUuid, this.ownerUuid);
        if (forward == RelationSystem.RelationType.HOSTILE || backward == RelationSystem.RelationType.HOSTILE) {
            return false;
        }
        return forward == RelationSystem.RelationType.FRIENDLY || forward == RelationSystem.RelationType.CONTROL || backward == RelationSystem.RelationType.FRIENDLY || backward == RelationSystem.RelationType.CONTROL;
    }

    public void tick() {
        double actualSupply;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        SupplyManager.SupplySource source = SupplyManager.getSupplySource(this.blockEntityId);
        if (source != null && Math.abs((actualSupply = source.getSupplyValue()) - this.storedSupply) > 0.001) {
            this.storedSupply = actualSupply;
            this.m_6596_();
        }
        ++this.conversionProgress;
        if (this.conversionProgress >= 20) {
            this.conversionProgress = 0;
            this.convertFoodToSupply();
        }
    }

    private void convertFoodToSupply() {
        int foodConverted = 0;
        for (int i = 0; i < this.items.size() && foodConverted < 10; ++i) {
            int foodValue;
            double supplyValue;
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.m_41619_() || !stack.m_41614_() || !(this.storedSupply + (supplyValue = SupplyManager.convertFoodToSupply(foodValue = stack.m_41720_().m_41473_().m_38744_())) <= this.maxStoredSupply)) continue;
            stack.m_41774_(1);
            this.storedSupply += supplyValue;
            ++foodConverted;
            this.m_6596_();
            SupplyManager.SupplySource source = SupplyManager.getSupplySource(this.blockEntityId);
            if (source == null) continue;
            source.setSupplyValue(this.storedSupply);
        }
    }

    public void depositSupply(double amount) {
        this.storedSupply = Math.min(this.storedSupply + amount, this.maxStoredSupply);
        this.m_6596_();
        SupplyManager.SupplySource source = SupplyManager.getSupplySource(this.blockEntityId);
        if (source != null) {
            source.setSupplyValue(this.storedSupply);
        }
    }

    public double withdrawSupply(double amount) {
        double withdrawn = Math.min(amount, this.storedSupply);
        this.storedSupply -= withdrawn;
        this.m_6596_();
        SupplyManager.SupplySource source = SupplyManager.getSupplySource(this.blockEntityId);
        if (source != null) {
            source.setSupplyValue(this.storedSupply);
        }
        return withdrawn;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128362_("BlockEntityId", this.blockEntityId);
        tag.m_128347_("StoredSupply", this.storedSupply);
        tag.m_128347_("MaxStoredSupply", this.maxStoredSupply);
        tag.m_128405_("ConversionProgress", this.conversionProgress);
        tag.m_128347_("SupplyToTransfer", this.supplyToTransfer);
        tag.m_128379_("ShowRange", this.showRange);
        if (this.ownerUuid != null) {
            tag.m_128362_("OwnerUUID", this.ownerUuid);
        }
        if (!this.ownerName.isEmpty()) {
            tag.m_128359_("OwnerName", this.ownerName);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        if (tag.m_128441_("BlockEntityId")) {
            UUID loadedId = tag.m_128342_("BlockEntityId");
            SupplyManager.unregisterSupplySource(this.blockEntityId);
            this.blockEntityId = loadedId;
            SupplyManager.registerSupplySource(loadedId, SupplyManager.SupplySourceType.SUPPLY_POINT, this.maxStoredSupply, this.m_58899_());
        }
        this.storedSupply = tag.m_128459_("StoredSupply");
        this.maxStoredSupply = tag.m_128459_("MaxStoredSupply");
        this.conversionProgress = tag.m_128451_("ConversionProgress");
        this.supplyToTransfer = tag.m_128459_("SupplyToTransfer");
        this.showRange = tag.m_128471_("ShowRange");
        this.ownerUuid = tag.m_128441_("OwnerUUID") ? tag.m_128342_("OwnerUUID") : null;
        this.ownerName = tag.m_128441_("OwnerName") ? tag.m_128461_("OwnerName") : "";
        SupplyManager.SupplySource source = SupplyManager.getSupplySource(this.blockEntityId);
        if (source != null) {
            source.setSupplyValue(this.storedSupply);
            source.setBlockPos(this.m_58899_());
            if (this.ownerUuid != null) {
                source.setOwnerId(this.ownerUuid);
            }
        }
    }

    public void m_7651_() {
        super.m_7651_();
        SupplyManager.unregisterSupplySource(this.blockEntityId);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public int m_6643_() {
        return 9;
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack result = ContainerHelper.m_18969_(this.items, (int)slot, (int)amount);
        if (!result.m_41619_()) {
            this.m_6596_();
        }
        return result;
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.items, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.items.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.items.clear();
        this.m_6596_();
    }

    public UUID getBlockEntityId() {
        return this.blockEntityId;
    }

    public double getStoredSupply() {
        return this.storedSupply;
    }

    public double getMaxStoredSupply() {
        return this.maxStoredSupply;
    }

    public double getDailyConsumption() {
        return SupplyManager.getDailyConsumption(this.blockEntityId);
    }

    public void setSupplyToTransfer(double amount) {
        this.supplyToTransfer = amount;
    }

    public double getSupplyToTransfer() {
        return this.supplyToTransfer;
    }

    public boolean isShowRange() {
        return this.showRange;
    }

    public void setShowRange(boolean showRange) {
        this.showRange = showRange;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public AABB getSupplyArea() {
        int range = 50;
        BlockPos pos = this.m_58899_();
        return new AABB((double)(pos.m_123341_() - range), (double)(pos.m_123342_() - range), (double)(pos.m_123343_() - range), (double)(pos.m_123341_() + range + 1), (double)(pos.m_123342_() + range + 1), (double)(pos.m_123343_() + range + 1));
    }
}

