/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.supply;

import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import ydmsama.hundred_years_war.main.supply.SupplyDataEncoding;
import ydmsama.hundred_years_war.main.supply.SupplyManager;
import ydmsama.hundred_years_war.main.supply.SupplyPointBlockEntity;

public class SupplyPointScreenHandler
extends AbstractContainerMenu {
    public static final MenuType<SupplyPointScreenHandler> TYPE = new MenuType(SupplyPointScreenHandler::clientCreate, null);
    private static BlockPos clientBlockPos = null;
    private final SupplyPointBlockEntity blockEntity;
    private final ContainerData containerData;
    private final BlockPos blockPos;
    private static final int DAILY_CONSUMPTION_SLOT = 2;
    private static final int TRANSFER_SLOT = 3;
    private static final int SUPPLIED_COUNT_SLOT = 4;
    private static final int SHOW_RANGE_SLOT = 5;

    public static SupplyPointScreenHandler clientCreate(int syncId, Inventory playerInventory) {
        BlockPos pos = clientBlockPos;
        clientBlockPos = null;
        if (pos != null) {
            SupplyPointBlockEntity blockEntity = (SupplyPointBlockEntity)playerInventory.f_35978_.m_9236_().m_7702_(pos);
            return new SupplyPointScreenHandler(syncId, playerInventory, blockEntity);
        }
        throw new IllegalStateException("No BlockPos set for client screen handler creation");
    }

    public static void setClientBlockPos(BlockPos pos) {
        clientBlockPos = pos;
    }

    public SupplyPointScreenHandler(int syncId, Inventory playerInventory, SupplyPointBlockEntity blockEntity) {
        super(TYPE, syncId);
        this.blockEntity = blockEntity;
        this.blockPos = blockEntity != null ? blockEntity.m_58899_() : BlockPos.f_121853_;
        SupplyPointScreenHandler.m_38869_((Container)blockEntity, (int)9);
        blockEntity.m_5856_(playerInventory.f_35978_);
        this.containerData = new SimpleContainerData(6);
        this.updateContainerData();
        this.m_38884_(this.containerData);
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot(blockEntity, i, 8 + i * 18, 35){

                public boolean m_5857_(ItemStack stack) {
                    return stack.m_41614_();
                }
            });
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 145 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 203));
        }
    }

    private void updateContainerData() {
        if (this.blockEntity != null) {
            this.containerData.m_8050_(0, (int)this.blockEntity.getStoredSupply());
            this.containerData.m_8050_(1, (int)this.blockEntity.getMaxStoredSupply());
            this.containerData.m_8050_(2, SupplyDataEncoding.encode(this.blockEntity.getDailyConsumption()));
            this.containerData.m_8050_(3, SupplyDataEncoding.encode(this.blockEntity.getSupplyToTransfer()));
            SupplyManager.SupplySource source = SupplyManager.getSupplySource(this.blockEntity.getBlockEntityId());
            this.containerData.m_8050_(4, source != null ? source.getSuppliedEntities().size() : 0);
            this.containerData.m_8050_(5, this.blockEntity.isShowRange() ? 1 : 0);
        }
    }

    public void m_38946_() {
        super.m_38946_();
        this.updateContainerData();
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack result = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            result = slotStack.m_41777_();
            if (index < 9) {
                if (!this.m_38903_(slotStack, 9, 45, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (slotStack.m_41614_()) {
                if (!this.m_38903_(slotStack, 0, 9, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == result.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return result;
    }

    public boolean m_6875_(Player player) {
        return this.blockEntity != null && this.blockEntity.m_6542_(player);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (this.blockEntity != null) {
            this.blockEntity.m_5785_(player);
        }
    }

    public double getStoredSupply() {
        return this.containerData.m_6413_(0);
    }

    public double getMaxStoredSupply() {
        return this.containerData.m_6413_(1);
    }

    public double getDailyConsumption() {
        return SupplyDataEncoding.decode(this.containerData.m_6413_(2));
    }

    public boolean isDailyConsumptionClamped() {
        return SupplyDataEncoding.isClamped(this.containerData.m_6413_(2));
    }

    public double getDailyConsumptionDisplayCap() {
        return SupplyDataEncoding.getClampValue();
    }

    public double getSupplyToTransfer() {
        return SupplyDataEncoding.decode(this.containerData.m_6413_(3));
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public SupplyPointBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public int getSuppliedEntityCount() {
        return this.containerData.m_6413_(4);
    }

    public boolean isShowRange() {
        return this.containerData.m_6413_(5) == 1;
    }

    public String getOwnerName() {
        return this.blockEntity != null ? this.blockEntity.getOwnerName() : "";
    }
}

