/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.template;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ydmsama.hundred_years_war.main.blocks.ModBlocks;
import ydmsama.hundred_years_war.main.template.HywStructureTemplate;
import ydmsama.hundred_years_war.main.template.TemplateManager;

public class BuildingTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildingTask.class);
    private static final int CLEAR_FLAGS = 35;
    private static final int FAST_TRACK_BLOCKS_PER_TICK = 10000;
    private static final int CONNECTION_COLUMNS_PER_TICK = 500;
    private static final int CONNECTION_FAST_TRACK_MULTIPLIER = 10;
    private static final int WATER_SURFACE_CHECKS_PER_TICK = 500;
    private static final int BURIAL_CHECKS_PER_TICK = 2048;
    private static final String ATTRIBUTE_GENERATE_ON_WATER_SURFACE = "generate_on_water_surface";
    private static final String ATTRIBUTE_MIN_BURIAL_RATE = "min_burial_rate";
    private static final String ATTRIBUTE_MAX_BURIAL_RATE = "max_burial_rate";
    private final UUID taskId;
    private final String templateId;
    private final BlockPos position;
    private final int rotation;
    private final float currentPlayerYaw;
    private final long totalBuildTime;
    private final String playerName;
    private final boolean generateConnectionLayer;
    private final boolean terrainCheck;
    private HywStructureTemplate template;
    private List<BlockPlacement> pendingPlacements;
    private int currentIndex = 0;
    private long startTime = -1L;
    private long elapsedTime = 0L;
    private boolean completed = false;
    private boolean failed = false;
    private String failureReason = null;
    private volatile boolean preparing = false;
    private volatile boolean prepareCompleted = false;
    private int placedBlocks = 0;
    private int failedBlocks = 0;
    private boolean fastTrack = false;
    private List<ConnectionColumn> connectionColumns = Collections.emptyList();
    private List<BlockPlacement> connectionPlacements = new ArrayList<BlockPlacement>();
    private int connectionColumnIndex = 0;
    private int connectionLayerActualPositions = 0;
    private int connectionLayerMaxDepthReached = 0;
    private boolean connectionLayerReady = true;
    private boolean connectionLayerFailed = false;
    private boolean startLogged = false;
    private boolean finishLogged = false;
    private boolean failureLogged = false;
    private boolean failureMessageSent = false;
    private int connectionLayerMaxDepth = 10;
    private long connectionLayerStartTime = -1L;
    private final boolean templateRequestsWaterSurfaceValidation;
    private List<BlockPos> waterSurfaceCheckPositions = Collections.emptyList();
    private int waterSurfaceCheckIndex = 0;
    private boolean waterSurfaceValidationReady = true;
    private boolean waterSurfaceValidationFailed = false;
    private boolean waterSurfaceValidationInitialized = false;
    private final double minBurialRate;
    private final double maxBurialRate;
    private boolean burialValidationRequired = false;
    private boolean burialValidationReady = true;
    private boolean burialValidationFailed = false;
    private List<BlockPos> burialCheckPositions = Collections.emptyList();
    private int burialCheckIndex = 0;
    private int burialOccupiedPositions = 0;
    private BlockPos minPos = null;
    private BlockPos maxPos = null;
    private UUID registeredBuildingId = null;
    private List<ChunkPos> requiredChunksForBuilding = Collections.emptyList();

    private static void logWarn(String message, Object ... args) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.warn(message, args);
        }
    }

    public BuildingTask(String templateId, BlockPos position, int rotation, float currentPlayerYaw, long totalBuildTime, String playerName) {
        this(templateId, position, rotation, currentPlayerYaw, totalBuildTime, playerName, false, false);
    }

    public BuildingTask(String templateId, BlockPos position, int rotation, float currentPlayerYaw, long totalBuildTime, String playerName, boolean generateConnectionLayer) {
        this(templateId, position, rotation, currentPlayerYaw, totalBuildTime, playerName, generateConnectionLayer, false);
    }

    public BuildingTask(String templateId, BlockPos position, int rotation, float currentPlayerYaw, long totalBuildTime, String playerName, boolean generateConnectionLayer, boolean terrainCheck) {
        this(templateId, position, rotation, currentPlayerYaw, totalBuildTime, playerName, generateConnectionLayer, terrainCheck, null);
    }

    public BuildingTask(String templateId, BlockPos position, int rotation, float currentPlayerYaw, long totalBuildTime, String playerName, boolean generateConnectionLayer, boolean terrainCheck, ServerLevel level) {
        this(templateId, null, position, rotation, currentPlayerYaw, totalBuildTime, playerName, generateConnectionLayer, terrainCheck, level);
    }

    public BuildingTask(String templateId, HywStructureTemplate preloadedTemplate, BlockPos position, int rotation, float currentPlayerYaw, long totalBuildTime, String playerName, boolean generateConnectionLayer, boolean terrainCheck, ServerLevel level) {
        this(templateId, preloadedTemplate, position, rotation, currentPlayerYaw, totalBuildTime, playerName, generateConnectionLayer, terrainCheck, level, true);
    }

    public BuildingTask(String templateId, HywStructureTemplate preloadedTemplate, BlockPos position, int rotation, float currentPlayerYaw, long totalBuildTime, String playerName, boolean generateConnectionLayer, boolean terrainCheck, ServerLevel level, boolean immediatePreparation) {
        this.taskId = UUID.randomUUID();
        this.templateId = templateId;
        this.position = position;
        this.rotation = rotation;
        this.currentPlayerYaw = currentPlayerYaw;
        this.totalBuildTime = totalBuildTime;
        this.playerName = playerName;
        this.generateConnectionLayer = generateConnectionLayer;
        this.terrainCheck = terrainCheck;
        this.template = preloadedTemplate != null ? preloadedTemplate : TemplateManager.getInstance().loadTemplate(templateId);
        double[] burialBounds = BuildingTask.resolveBurialConstraints(this.template);
        this.minBurialRate = burialBounds[0];
        this.maxBurialRate = burialBounds[1];
        this.resetBurialValidationState();
        this.templateRequestsWaterSurfaceValidation = BuildingTask.isTemplateAttributeEnabled(this.template, ATTRIBUTE_GENERATE_ON_WATER_SURFACE);
        this.waterSurfaceValidationReady = !this.templateRequestsWaterSurfaceValidation;
        boolean bl = this.waterSurfaceValidationInitialized = !this.templateRequestsWaterSurfaceValidation;
        if (this.template == null) {
            this.failed = true;
            this.failureReason = "Template not found: " + templateId;
            this.logTaskFailed();
        } else if (immediatePreparation) {
            this.preparePlacements(level);
        } else {
            this.preparing = true;
        }
    }

    public BuildingTask(CompoundTag tag) {
        this.taskId = tag.m_128342_("taskId");
        this.templateId = tag.m_128461_("templateId");
        this.position = BlockPos.m_122022_((long)tag.m_128454_("position"));
        this.rotation = tag.m_128451_("rotation");
        this.currentPlayerYaw = tag.m_128457_("currentPlayerYaw");
        this.totalBuildTime = tag.m_128454_("totalBuildTime");
        this.playerName = tag.m_128461_("playerName");
        this.generateConnectionLayer = tag.m_128471_("generateConnectionLayer");
        this.terrainCheck = tag.m_128471_("terrainCheck");
        this.currentIndex = tag.m_128451_("currentIndex");
        this.startTime = tag.m_128454_("startTime");
        this.elapsedTime = tag.m_128454_("elapsedTime");
        this.completed = tag.m_128471_("completed");
        this.failed = tag.m_128471_("failed");
        this.failureReason = tag.m_128441_("failureReason") ? tag.m_128461_("failureReason") : null;
        this.placedBlocks = tag.m_128451_("placedBlocks");
        this.failedBlocks = tag.m_128451_("failedBlocks");
        if (tag.m_128441_("minPos")) {
            this.minPos = BlockPos.m_122022_((long)tag.m_128454_("minPos"));
        }
        if (tag.m_128441_("maxPos")) {
            this.maxPos = BlockPos.m_122022_((long)tag.m_128454_("maxPos"));
        }
        if (tag.m_128441_("registeredBuildingId")) {
            this.registeredBuildingId = tag.m_128342_("registeredBuildingId");
        }
        this.fastTrack = tag.m_128471_("fastTrack");
        this.preparing = tag.m_128471_("preparing");
        this.prepareCompleted = tag.m_128471_("prepareCompleted");
        if (this.startTime != -1L) {
            this.startLogged = true;
        }
        if (this.completed) {
            this.finishLogged = true;
        }
        if (this.failed) {
            this.failureLogged = true;
        }
        this.template = TemplateManager.getInstance().loadTemplate(this.templateId);
        double[] burialBounds = BuildingTask.resolveBurialConstraints(this.template);
        this.minBurialRate = burialBounds[0];
        this.maxBurialRate = burialBounds[1];
        this.resetBurialValidationState();
        this.templateRequestsWaterSurfaceValidation = BuildingTask.isTemplateAttributeEnabled(this.template, ATTRIBUTE_GENERATE_ON_WATER_SURFACE);
        this.waterSurfaceValidationReady = !this.templateRequestsWaterSurfaceValidation;
        boolean bl = this.waterSurfaceValidationInitialized = !this.templateRequestsWaterSurfaceValidation;
        if (this.template == null && !this.failed) {
            this.failed = true;
            this.failureReason = "Template not found on reload: " + this.templateId;
            this.logTaskFailed();
        }
        if (!this.failed && !this.completed && this.template != null) {
            this.preparePlacements();
        }
    }

    private void preparePlacements() {
        this.preparePlacements(null);
    }

    public void completeAsyncPreparation() {
        if (!this.preparing) {
            return;
        }
        try {
            this.preparePlacementsAsync();
            this.prepareCompleted = true;
            this.preparing = false;
            this.connectionLayerReady = !this.generateConnectionLayer && !this.terrainCheck;
        }
        catch (Exception e) {
            BuildingTask.logWarn("\u5f02\u6b65\u51c6\u5907\u5931\u8d25: {}", e.getMessage());
            this.failed = true;
            this.failureReason = "Async preparation failed: " + e.getMessage();
            this.preparing = false;
            this.logTaskFailed();
        }
    }

    private void preparePlacementsAsync() {
        if (this.template == null) {
            return;
        }
        this.pendingPlacements = new ArrayList<BlockPlacement>();
        this.minPos = null;
        this.maxPos = null;
        float savedYaw = this.template.getPlayerYaw();
        float relativeYaw = BuildingTask.normalizeAngle(savedYaw - this.currentPlayerYaw);
        int relativeRotation = Math.round(relativeYaw / 90.0f) * 90;
        relativeRotation = BuildingTask.normalizeRotation(relativeRotation);
        int totalRotation = BuildingTask.normalizeRotation(this.rotation + relativeRotation);
        BlockPos entrance = this.template.getEntrance();
        if (entrance == null) {
            entrance = BlockPos.f_121853_;
        }
        BlockPos transformedEntrance = BuildingTask.transformPosition(entrance, this.template.getSize(), totalRotation);
        BlockPos offset = this.position.m_121996_((Vec3i)transformedEntrance);
        HashMap<BlockState, BlockState> rotationCache = new HashMap<BlockState, BlockState>();
        for (Map.Entry<HywStructureTemplate.ChunkPos, HywStructureTemplate.TemplateChunk> entry : this.template.getChunks().entrySet()) {
            HywStructureTemplate.ChunkPos chunkPos = entry.getKey();
            HywStructureTemplate.TemplateChunk chunk = entry.getValue();
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        BlockState transformedState;
                        BlockState state = chunk.getBlock(x, y, z);
                        if (state == null || state.m_60795_()) continue;
                        BlockPos relativePos = new BlockPos(chunkPos.x * 16 + x, chunkPos.y * 16 + y, chunkPos.z * 16 + z);
                        BlockPos transformedPos = BuildingTask.transformPosition(relativePos, this.template.getSize(), totalRotation);
                        BlockPos worldPos = offset.m_121955_((Vec3i)transformedPos);
                        boolean isPlaceholder = state.m_60713_((Block)ModBlocks.PLACEHOLDER_BLOCK.get());
                        CompoundTag tileData = null;
                        if (isPlaceholder) {
                            transformedState = Blocks.f_50016_.m_49966_();
                        } else {
                            transformedState = rotationCache.computeIfAbsent(state, s -> BuildingTask.transformBlockState(s, totalRotation));
                            tileData = chunk.getTileData(x, y, z);
                        }
                        this.pendingPlacements.add(new BlockPlacement(worldPos, transformedState, tileData));
                        if (this.minPos == null) {
                            this.minPos = worldPos;
                            this.maxPos = worldPos;
                            continue;
                        }
                        this.minPos = new BlockPos(Math.min(this.minPos.m_123341_(), worldPos.m_123341_()), Math.min(this.minPos.m_123342_(), worldPos.m_123342_()), Math.min(this.minPos.m_123343_(), worldPos.m_123343_()));
                        this.maxPos = new BlockPos(Math.max(this.maxPos.m_123341_(), worldPos.m_123341_()), Math.max(this.maxPos.m_123342_(), worldPos.m_123342_()), Math.max(this.maxPos.m_123343_(), worldPos.m_123343_()));
                    }
                }
            }
        }
        this.sortPendingPlacements();
        this.prepareBurialValidationState();
        this.prepareWaterSurfaceValidationState();
        this.calculateRequiredChunks();
    }

    private void preparePlacements(ServerLevel level) {
        if (this.template == null) {
            return;
        }
        this.pendingPlacements = new ArrayList<BlockPlacement>();
        this.minPos = null;
        this.maxPos = null;
        float savedYaw = this.template.getPlayerYaw();
        float relativeYaw = BuildingTask.normalizeAngle(savedYaw - this.currentPlayerYaw);
        int relativeRotation = Math.round(relativeYaw / 90.0f) * 90;
        relativeRotation = BuildingTask.normalizeRotation(relativeRotation);
        int totalRotation = BuildingTask.normalizeRotation(this.rotation + relativeRotation);
        BlockPos entrance = this.template.getEntrance();
        if (entrance == null) {
            entrance = BlockPos.f_121853_;
        }
        BlockPos transformedEntrance = BuildingTask.transformPosition(entrance, this.template.getSize(), totalRotation);
        BlockPos offset = this.position.m_121996_((Vec3i)transformedEntrance);
        HashMap<BlockState, BlockState> rotationCache = new HashMap<BlockState, BlockState>();
        for (Map.Entry<HywStructureTemplate.ChunkPos, HywStructureTemplate.TemplateChunk> entry : this.template.getChunks().entrySet()) {
            HywStructureTemplate.ChunkPos chunkPos = entry.getKey();
            HywStructureTemplate.TemplateChunk chunk = entry.getValue();
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        BlockState transformedState;
                        BlockState state = chunk.getBlock(x, y, z);
                        if (state == null || state.m_60795_()) continue;
                        BlockPos relativePos = new BlockPos(chunkPos.x * 16 + x, chunkPos.y * 16 + y, chunkPos.z * 16 + z);
                        BlockPos transformedPos = BuildingTask.transformPosition(relativePos, this.template.getSize(), totalRotation);
                        BlockPos worldPos = offset.m_121955_((Vec3i)transformedPos);
                        boolean isPlaceholder = state.m_60713_((Block)ModBlocks.PLACEHOLDER_BLOCK.get());
                        CompoundTag tileData = null;
                        if (isPlaceholder) {
                            transformedState = Blocks.f_50016_.m_49966_();
                        } else {
                            transformedState = rotationCache.computeIfAbsent(state, s -> BuildingTask.transformBlockState(s, totalRotation));
                            tileData = chunk.getTileData(x, y, z);
                        }
                        this.pendingPlacements.add(new BlockPlacement(worldPos, transformedState, tileData));
                        if (this.minPos == null) {
                            this.minPos = worldPos;
                            this.maxPos = worldPos;
                            continue;
                        }
                        this.minPos = new BlockPos(Math.min(this.minPos.m_123341_(), worldPos.m_123341_()), Math.min(this.minPos.m_123342_(), worldPos.m_123342_()), Math.min(this.minPos.m_123343_(), worldPos.m_123343_()));
                        this.maxPos = new BlockPos(Math.max(this.maxPos.m_123341_(), worldPos.m_123341_()), Math.max(this.maxPos.m_123342_(), worldPos.m_123342_()), Math.max(this.maxPos.m_123343_(), worldPos.m_123343_()));
                    }
                }
            }
        }
        this.sortPendingPlacements();
        this.prepareBurialValidationState();
        this.prepareWaterSurfaceValidationState();
        this.initializeConnectionLayerState();
        this.calculateRequiredChunks();
    }

    private void calculateRequiredChunks() {
        if (this.minPos == null || this.maxPos == null) {
            this.requiredChunksForBuilding = Collections.emptyList();
            return;
        }
        int minChunkX = Math.floorDiv(this.minPos.m_123341_(), 16);
        int maxChunkX = Math.floorDiv(this.maxPos.m_123341_(), 16);
        int minChunkZ = Math.floorDiv(this.minPos.m_123343_(), 16);
        int maxChunkZ = Math.floorDiv(this.maxPos.m_123343_(), 16);
        int capacity = (maxChunkX - minChunkX + 1) * (maxChunkZ - minChunkZ + 1);
        ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>(capacity);
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                chunks.add(new ChunkPos(x, z));
            }
        }
        this.requiredChunksForBuilding = chunks;
    }

    private void sortPendingPlacements() {
        if (this.pendingPlacements == null || this.pendingPlacements.isEmpty()) {
            return;
        }
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (BlockPlacement blockPlacement : this.pendingPlacements) {
            int y = blockPlacement.worldPos.m_123342_();
            if (y < minY) {
                minY = y;
            }
            if (y <= maxY) continue;
            maxY = y;
        }
        List[] buckets = new List[maxY - minY + 1];
        for (BlockPlacement p : this.pendingPlacements) {
            int idx = p.worldPos.m_123342_() - minY;
            ArrayList<BlockPlacement> bucket = buckets[idx];
            if (bucket == null) {
                buckets[idx] = bucket = new ArrayList<BlockPlacement>();
            }
            bucket.add(p);
        }
        ArrayList<BlockPlacement> arrayList = new ArrayList<BlockPlacement>(this.pendingPlacements.size());
        for (List bucket : buckets) {
            if (bucket == null) continue;
            arrayList.addAll(bucket);
        }
        this.pendingPlacements = arrayList;
    }

    private void resetBurialValidationState() {
        this.burialValidationRequired = this.minBurialRate > 1.0E-6 || this.maxBurialRate < 0.999999;
        this.burialValidationReady = !this.burialValidationRequired;
        this.burialValidationFailed = false;
        this.burialCheckPositions = Collections.emptyList();
        this.burialCheckIndex = 0;
        this.burialOccupiedPositions = 0;
    }

    private void prepareWaterSurfaceValidationState() {
        if (!this.templateRequestsWaterSurfaceValidation) {
            this.waterSurfaceCheckPositions = Collections.emptyList();
            this.waterSurfaceCheckIndex = 0;
            this.waterSurfaceValidationReady = true;
            this.waterSurfaceValidationInitialized = true;
            this.waterSurfaceValidationFailed = false;
            return;
        }
        if (this.position == null || this.pendingPlacements == null || this.pendingPlacements.isEmpty()) {
            this.waterSurfaceCheckPositions = Collections.emptyList();
            this.waterSurfaceCheckIndex = 0;
            this.waterSurfaceValidationReady = true;
            this.waterSurfaceValidationInitialized = true;
            this.waterSurfaceValidationFailed = false;
            return;
        }
        int anchorY = this.position.m_123342_();
        ArrayList<BlockPos> anchors = new ArrayList<BlockPos>();
        for (BlockPlacement placement : this.pendingPlacements) {
            if (placement.worldPos.m_123342_() != anchorY) continue;
            anchors.add(placement.worldPos);
        }
        this.waterSurfaceCheckPositions = anchors;
        this.waterSurfaceCheckIndex = 0;
        this.waterSurfaceValidationFailed = false;
        if (anchors.isEmpty()) {
            this.waterSurfaceValidationReady = true;
            this.waterSurfaceValidationInitialized = true;
        } else {
            this.waterSurfaceValidationReady = false;
            this.waterSurfaceValidationInitialized = false;
        }
    }

    private void prepareBurialValidationState() {
        if (!this.burialValidationRequired) {
            this.burialValidationReady = true;
            this.burialCheckPositions = Collections.emptyList();
            this.burialCheckIndex = 0;
            this.burialOccupiedPositions = 0;
            return;
        }
        if (this.pendingPlacements == null || this.pendingPlacements.isEmpty()) {
            this.burialValidationReady = true;
            this.burialCheckPositions = Collections.emptyList();
            this.burialCheckIndex = 0;
            this.burialOccupiedPositions = 0;
            return;
        }
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>(this.pendingPlacements.size());
        for (BlockPlacement placement : this.pendingPlacements) {
            if (placement.isConnectionLayer) continue;
            positions.add(placement.worldPos);
        }
        this.burialCheckPositions = positions;
        this.burialCheckIndex = 0;
        this.burialOccupiedPositions = 0;
        this.burialValidationFailed = false;
        this.burialValidationReady = positions.isEmpty();
    }

    private void initializeConnectionLayerState() {
        this.connectionPlacements = new ArrayList<BlockPlacement>();
        this.connectionColumns = Collections.emptyList();
        this.connectionColumnIndex = 0;
        this.connectionLayerActualPositions = 0;
        this.connectionLayerMaxDepthReached = 0;
        this.connectionLayerFailed = false;
        this.connectionLayerStartTime = -1L;
        this.connectionLayerReady = true;
        if (!this.generateConnectionLayer && !this.terrainCheck) {
            this.connectionLayerReady = true;
            return;
        }
        Long2ObjectOpenHashMap lowestPositionsByXZ = new Long2ObjectOpenHashMap();
        Long2ObjectOpenHashMap lowestBlocksByXZ = new Long2ObjectOpenHashMap();
        int entranceY = this.position.m_123342_();
        for (BlockPlacement placement : this.pendingPlacements) {
            long key;
            BlockPos existing;
            if (placement.worldPos.m_123342_() > entranceY || (existing = (BlockPos)lowestPositionsByXZ.get(key = (long)placement.worldPos.m_123341_() << 32 ^ (long)placement.worldPos.m_123343_() & 0xFFFFFFFFL)) != null && placement.worldPos.m_123342_() >= existing.m_123342_()) continue;
            lowestPositionsByXZ.put(key, (Object)placement.worldPos);
            lowestBlocksByXZ.put(key, (Object)placement.state);
        }
        if (lowestPositionsByXZ.isEmpty()) {
            this.connectionLayerReady = true;
            return;
        }
        this.connectionLayerMaxDepth = this.template != null && this.template.getConnectionLayerDepth() > 0 ? this.template.getConnectionLayerDepth() : 10;
        ArrayList<ConnectionColumn> columns = new ArrayList<ConnectionColumn>(lowestPositionsByXZ.size());
        for (Long2ObjectMap.Entry entry : lowestPositionsByXZ.long2ObjectEntrySet()) {
            BlockState state = (BlockState)lowestBlocksByXZ.get(entry.getLongKey());
            columns.add(new ConnectionColumn((BlockPos)entry.getValue(), state, this.connectionLayerMaxDepth));
        }
        columns.sort(Comparator.comparingInt(column -> column.basePos.m_123342_()));
        this.connectionColumns = columns;
        this.connectionLayerReady = this.connectionColumns.isEmpty();
        if (!this.connectionLayerReady) {
            this.connectionLayerStartTime = System.nanoTime();
        }
    }

    private boolean processConnectionLayer(ServerLevel level) {
        int used;
        int budget;
        if (this.connectionLayerReady || this.connectionLayerFailed) {
            return this.connectionLayerReady;
        }
        if (this.connectionColumns.isEmpty()) {
            this.connectionLayerReady = true;
            return true;
        }
        if (this.fastTrack) {
            long fastTrackBudget = 100000L;
            budget = (int)Math.min(Integer.MAX_VALUE, fastTrackBudget);
        } else {
            budget = 500;
        }
        for (int spent = 0; spent < budget && this.connectionColumnIndex < this.connectionColumns.size(); spent += used) {
            ConnectionColumn column = this.connectionColumns.get(this.connectionColumnIndex);
            used = this.processConnectionColumn(level, column, budget - spent);
            if (!column.done) continue;
            ++this.connectionColumnIndex;
        }
        if (this.connectionColumnIndex >= this.connectionColumns.size()) {
            this.finalizeConnectionLayer();
        }
        return this.connectionLayerReady;
    }

    private int processConnectionColumn(ServerLevel level, ConnectionColumn column, int budget) {
        int used = 0;
        if (column.done) {
            return 0;
        }
        if (!column.initialChecked) {
            column.initialChecked = true;
            BlockPos firstBelow = column.basePos.m_7495_();
            if (firstBelow.m_123342_() < level.m_141937_()) {
                column.done = true;
                return 0;
            }
            BlockState firstBelowState = level.m_8055_(firstBelow);
            if (!this.canReplaceForConnectionLayer(firstBelowState)) {
                column.done = true;
                return 0;
            }
            column.needsConnection = true;
            column.counted = true;
            ++this.connectionLayerActualPositions;
        }
        while (column.needsConnection && column.processedDepth < column.maxDepth && used < budget) {
            int nextDepth = column.processedDepth + 1;
            BlockPos targetPos = column.basePos.m_6625_(nextDepth);
            if (targetPos.m_123342_() < level.m_141937_()) {
                column.done = true;
                break;
            }
            BlockState currentState = level.m_8055_(targetPos);
            if (!this.canReplaceForConnectionLayer(currentState)) {
                column.done = true;
                break;
            }
            if (this.generateConnectionLayer) {
                this.connectionPlacements.add(new BlockPlacement(targetPos, column.blockState, null, true));
            }
            column.processedDepth = nextDepth;
            ++used;
        }
        if (column.processedDepth >= column.maxDepth) {
            BlockPos belowMax = column.basePos.m_6625_(column.maxDepth + 1);
            if (belowMax.m_123342_() >= level.m_141937_()) {
                BlockState belowState = level.m_8055_(belowMax);
                if (this.canReplaceForConnectionLayer(belowState)) {
                    column.reachedMaxDepth = true;
                }
            } else {
                column.reachedMaxDepth = true;
            }
            column.done = true;
        }
        if (column.done && column.needsConnection && column.reachedMaxDepth) {
            ++this.connectionLayerMaxDepthReached;
        }
        if (column.done && !column.needsConnection) {
            column.reachedMaxDepth = false;
        }
        return used;
    }

    private void finalizeConnectionLayer() {
        float ratio;
        if (this.connectionLayerReady || this.connectionLayerFailed) {
            return;
        }
        if (this.terrainCheck && this.connectionLayerActualPositions > 0 && (ratio = (float)this.connectionLayerMaxDepthReached / (float)this.connectionLayerActualPositions) > 0.1f) {
            this.failed = true;
            this.failureReason = "Terrain too uneven - more than 10% of positions reach maximum depth";
            this.logTaskFailed();
            this.connectionLayerFailed = true;
            return;
        }
        if (this.generateConnectionLayer && !this.connectionPlacements.isEmpty()) {
            this.pendingPlacements.addAll(this.connectionPlacements);
            this.sortPendingPlacements();
        }
        this.connectionLayerReady = true;
        this.connectionLayerStartTime = -1L;
    }

    private void initializeWaterSurfaceValidation(ServerLevel level) {
        if (this.waterSurfaceValidationInitialized) {
            return;
        }
        this.waterSurfaceValidationInitialized = true;
        if (this.waterSurfaceCheckPositions.isEmpty()) {
            this.waterSurfaceValidationReady = true;
            return;
        }
        if (this.position == null) {
            this.waterSurfaceValidationReady = true;
            return;
        }
        FluidState fluidState = level.m_6425_(this.position);
        this.waterSurfaceValidationReady = !fluidState.m_205070_(FluidTags.f_13131_);
    }

    private boolean processWaterSurfaceValidation(ServerLevel level) {
        int budget;
        if (this.waterSurfaceValidationReady || this.waterSurfaceValidationFailed) {
            return true;
        }
        if (this.fastTrack) {
            long fastTrackBudget = 100000L;
            budget = (int)Math.min(Integer.MAX_VALUE, fastTrackBudget);
        } else {
            budget = 500;
        }
        for (int processed = 0; processed < budget && this.waterSurfaceCheckIndex < this.waterSurfaceCheckPositions.size(); ++processed) {
            BlockPos checkPos;
            if (level.m_6425_(checkPos = this.waterSurfaceCheckPositions.get(this.waterSurfaceCheckIndex++)).m_205070_(FluidTags.f_13131_)) continue;
            this.waterSurfaceValidationFailed = true;
            this.waterSurfaceValidationReady = true;
            this.failed = true;
            this.failureReason = String.format(Locale.ROOT, "Water surface validation failed at (%d,%d,%d)", checkPos.m_123341_(), checkPos.m_123342_(), checkPos.m_123343_());
            this.logTaskFailed();
            break;
        }
        if (!this.waterSurfaceValidationFailed && this.waterSurfaceCheckIndex >= this.waterSurfaceCheckPositions.size()) {
            this.waterSurfaceValidationReady = true;
        }
        return this.waterSurfaceValidationReady || this.waterSurfaceValidationFailed;
    }

    private boolean processBurialValidation(ServerLevel level) {
        int budget;
        if (this.burialValidationReady || this.burialValidationFailed || !this.burialValidationRequired) {
            return true;
        }
        if (this.fastTrack) {
            long fastTrackBudget = 100000L;
            budget = (int)Math.min(Integer.MAX_VALUE, fastTrackBudget);
        } else {
            budget = 2048;
        }
        for (int processed = 0; processed < budget && this.burialCheckIndex < this.burialCheckPositions.size(); ++processed) {
            BlockPos checkPos;
            if (level.m_8055_(checkPos = this.burialCheckPositions.get(this.burialCheckIndex++)).m_60795_()) continue;
            ++this.burialOccupiedPositions;
        }
        if (this.burialCheckIndex >= this.burialCheckPositions.size()) {
            double total = this.burialCheckPositions.isEmpty() ? 0.0 : (double)this.burialCheckPositions.size();
            double ratio = total <= 0.0 ? 0.0 : (double)this.burialOccupiedPositions / total;
            double clampedRatio = Mth.m_14008_((double)ratio, (double)0.0, (double)1.0);
            if (clampedRatio + 1.0E-6 < this.minBurialRate || clampedRatio - 1.0E-6 > this.maxBurialRate) {
                this.burialValidationFailed = true;
                this.burialValidationReady = true;
                this.failed = true;
                this.failureReason = String.format(Locale.ROOT, "Burial ratio %.2f outside allowed range [%.2f, %.2f]", clampedRatio, this.minBurialRate, this.maxBurialRate);
                this.logTaskFailed();
                this.notifyFailureMessage(level, (Component)Component.m_237110_((String)"message.hundred_years_war.building_burial_invalid", (Object[])new Object[]{(int)Math.round(clampedRatio * 100.0), (int)Math.round(this.minBurialRate * 100.0), (int)Math.round(this.maxBurialRate * 100.0)}));
            } else {
                this.burialValidationReady = true;
            }
        }
        return this.burialValidationReady || this.burialValidationFailed;
    }

    public boolean tick(ServerLevel level, long currentTick) {
        int blocksToPlace;
        if (this.failed) {
            this.logTaskFailed();
            return true;
        }
        if (this.completed) {
            this.logTaskCompleted();
            return true;
        }
        if (this.preparing) {
            return false;
        }
        if (this.prepareCompleted && !this.connectionLayerReady && (this.generateConnectionLayer || this.terrainCheck)) {
            this.initializeConnectionLayerState();
            this.prepareCompleted = false;
        }
        if (this.pendingPlacements == null || this.pendingPlacements.isEmpty()) {
            this.completed = true;
            if (this.startTime == -1L) {
                this.startTime = currentTick;
            }
            this.elapsedTime = currentTick - this.startTime;
            this.logTaskStarted();
            this.logTaskCompleted();
            return true;
        }
        if (this.templateRequestsWaterSurfaceValidation) {
            this.initializeWaterSurfaceValidation(level);
            if (!this.waterSurfaceValidationReady) {
                if (!this.processWaterSurfaceValidation(level)) {
                    return false;
                }
                if (this.waterSurfaceValidationFailed) {
                    return true;
                }
            }
        }
        if ((this.generateConnectionLayer || this.terrainCheck) && !this.connectionLayerReady) {
            if (!this.processConnectionLayer(level)) {
                return false;
            }
            if (this.connectionLayerFailed) {
                return true;
            }
        }
        if (this.burialValidationRequired && !this.burialValidationReady) {
            if (!this.processBurialValidation(level)) {
                return false;
            }
            if (this.burialValidationFailed) {
                return true;
            }
        }
        if (this.startTime == -1L) {
            this.startTime = currentTick;
            this.logTaskStarted();
        }
        this.elapsedTime = currentTick - this.startTime;
        if (this.totalBuildTime == 0L) {
            blocksToPlace = this.pendingPlacements.size();
        } else {
            double progress = Math.min(1.0, (double)this.elapsedTime / (double)this.totalBuildTime);
            int targetIndex = (int)Math.floor((double)this.pendingPlacements.size() * progress);
            blocksToPlace = Math.max(0, targetIndex - this.currentIndex);
            if (this.elapsedTime >= this.totalBuildTime && this.currentIndex < this.pendingPlacements.size()) {
                blocksToPlace = this.pendingPlacements.size() - this.currentIndex;
            }
        }
        if (this.fastTrack && this.currentIndex < this.pendingPlacements.size()) {
            int remaining = this.pendingPlacements.size() - this.currentIndex;
            blocksToPlace = Math.min(remaining, Math.max(blocksToPlace, 10000));
        }
        int placed = 0;
        while (placed < blocksToPlace && this.currentIndex < this.pendingPlacements.size()) {
            block29: {
                BlockPlacement placement = this.pendingPlacements.get(this.currentIndex);
                boolean attemptedPlacement = true;
                try {
                    BlockState currentState;
                    if (placement.isConnectionLayer && !this.canReplaceForConnectionLayer(currentState = level.m_8055_(placement.worldPos))) {
                        attemptedPlacement = false;
                    }
                    if (attemptedPlacement) {
                        if (this.placeBlock(level, placement)) {
                            ++this.placedBlocks;
                        } else {
                            ++this.failedBlocks;
                        }
                        ++placed;
                    }
                }
                catch (Exception e) {
                    BuildingTask.logWarn("Failed to place block at {}: {}", placement.worldPos, e.getMessage());
                    if (!attemptedPlacement) break block29;
                    ++this.failedBlocks;
                    ++placed;
                }
            }
            ++this.currentIndex;
        }
        if (this.currentIndex >= this.pendingPlacements.size()) {
            this.completed = true;
            this.logTaskCompleted();
        }
        return this.completed;
    }

    public void enableFastTrack() {
        if (this.completed || this.failed) {
            return;
        }
        this.fastTrack = true;
    }

    private void logTaskStarted() {
    }

    private void logTaskCompleted() {
    }

    private void logTaskFailed() {
    }

    private boolean canReplaceForConnectionLayer(BlockState state) {
        if (state.m_60795_()) {
            return true;
        }
        FluidState fluidState = state.m_60819_();
        if (!fluidState.m_76178_()) {
            return true;
        }
        if (state.m_247087_()) {
            return true;
        }
        return !state.m_280555_();
    }

    private boolean placeBlock(ServerLevel level, BlockPlacement placement) {
        BlockPos pos = placement.worldPos;
        BlockState desiredState = placement.state;
        BlockState currentState = level.m_8055_(pos);
        if (currentState.equals(desiredState)) {
            this.applyTileData(level, pos, placement);
            return true;
        }
        if (!this.clearTargetPosition(level, pos, currentState)) {
            return false;
        }
        if (!level.m_7731_(pos, desiredState, 3)) {
            return false;
        }
        this.applyTileData(level, pos, placement);
        return true;
    }

    private void applyTileData(ServerLevel level, BlockPos pos, BlockPlacement placement) {
        BlockEntity blockEntity;
        if (placement.tileData != null && this.template != null && this.template.includesBlockData() && (blockEntity = level.m_7702_(pos)) != null) {
            blockEntity.m_142466_(placement.tileData);
        }
    }

    private boolean clearTargetPosition(ServerLevel level, BlockPos pos, BlockState currentState) {
        if (currentState.m_60795_()) {
            return true;
        }
        if (currentState.m_60800_((BlockGetter)level, pos) == -1.0f) {
            return false;
        }
        this.clearDoubleBlockPartner(level, pos, currentState);
        if (level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 35)) {
            return true;
        }
        return level.m_46961_(pos, false);
    }

    private void clearDoubleBlockPartner(ServerLevel level, BlockPos pos, BlockState state) {
        if (!state.m_61138_((Property)BlockStateProperties.f_61401_)) {
            return;
        }
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)BlockStateProperties.f_61401_);
        BlockPos otherPos = half == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos.m_7494_();
        BlockState otherState = level.m_8055_(otherPos);
        if (otherState.m_61138_((Property)BlockStateProperties.f_61401_) && otherState.m_61143_((Property)BlockStateProperties.f_61401_) != half && otherState.m_60713_(state.m_60734_())) {
            level.m_7731_(otherPos, Blocks.f_50016_.m_49966_(), 35);
        }
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("taskId", this.taskId);
        tag.m_128359_("templateId", this.templateId);
        tag.m_128356_("position", this.position.m_121878_());
        tag.m_128405_("rotation", this.rotation);
        tag.m_128350_("currentPlayerYaw", this.currentPlayerYaw);
        tag.m_128356_("totalBuildTime", this.totalBuildTime);
        tag.m_128359_("playerName", this.playerName);
        tag.m_128379_("generateConnectionLayer", this.generateConnectionLayer);
        tag.m_128379_("terrainCheck", this.terrainCheck);
        tag.m_128405_("currentIndex", this.currentIndex);
        tag.m_128356_("startTime", this.startTime);
        tag.m_128356_("elapsedTime", this.elapsedTime);
        tag.m_128379_("completed", this.completed);
        tag.m_128379_("failed", this.failed);
        if (this.failureReason != null) {
            tag.m_128359_("failureReason", this.failureReason);
        }
        tag.m_128405_("placedBlocks", this.placedBlocks);
        tag.m_128405_("failedBlocks", this.failedBlocks);
        if (this.minPos != null) {
            tag.m_128356_("minPos", this.minPos.m_121878_());
        }
        if (this.maxPos != null) {
            tag.m_128356_("maxPos", this.maxPos.m_121878_());
        }
        if (this.registeredBuildingId != null) {
            tag.m_128362_("registeredBuildingId", this.registeredBuildingId);
        }
        tag.m_128379_("fastTrack", this.fastTrack);
        tag.m_128379_("preparing", this.preparing);
        tag.m_128379_("prepareCompleted", this.prepareCompleted);
        return tag;
    }

    private static boolean isTemplateAttributeEnabled(HywStructureTemplate template, String key) {
        if (template == null || key == null) {
            return false;
        }
        Map<String, JsonElement> attributes = template.getCustomAttributes();
        if (attributes == null) {
            return false;
        }
        JsonElement element = attributes.get(key);
        return element != null && element.isJsonPrimitive() && element.getAsJsonPrimitive().isBoolean() && element.getAsBoolean();
    }

    private static double[] resolveBurialConstraints(HywStructureTemplate template) {
        double min = BuildingTask.getTemplateAttributeDouble(template, ATTRIBUTE_MIN_BURIAL_RATE, 0.0);
        double max = BuildingTask.getTemplateAttributeDouble(template, ATTRIBUTE_MAX_BURIAL_RATE, 1.0);
        if ((min = Mth.m_14008_((double)min, (double)0.0, (double)1.0)) > (max = Mth.m_14008_((double)max, (double)0.0, (double)1.0))) {
            double temp = min;
            min = max;
            max = temp;
        }
        return new double[]{min, max};
    }

    private static double getTemplateAttributeDouble(HywStructureTemplate template, String key, double defaultValue) {
        if (template == null || key == null) {
            return defaultValue;
        }
        Map<String, JsonElement> attributes = template.getCustomAttributes();
        if (attributes == null) {
            return defaultValue;
        }
        JsonElement element = attributes.get(key);
        if (element == null || element.isJsonNull()) {
            return defaultValue;
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                return primitive.getAsDouble();
            }
            if (primitive.isString()) {
                try {
                    return Double.parseDouble(primitive.getAsString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return defaultValue;
    }

    private static BlockPos transformPosition(BlockPos pos, BlockPos size, int rotation) {
        BlockPos result = pos;
        BlockPos currentSize = size;
        for (int i = 0; i < rotation / 90; ++i) {
            int newX = result.m_123343_();
            int newZ = currentSize.m_123341_() - 1 - result.m_123341_();
            result = new BlockPos(newX, result.m_123342_(), newZ);
            int temp = currentSize.m_123341_();
            currentSize = new BlockPos(currentSize.m_123343_(), currentSize.m_123342_(), temp);
        }
        return result;
    }

    private static BlockState transformBlockState(BlockState state, int rotation) {
        Rotation rot = switch (rotation) {
            case 90 -> Rotation.COUNTERCLOCKWISE_90;
            case 180 -> Rotation.CLOCKWISE_180;
            case 270 -> Rotation.CLOCKWISE_90;
            default -> Rotation.NONE;
        };
        return state.m_60717_(rot);
    }

    private static float normalizeAngle(float angle) {
        while (angle > 180.0f) {
            angle -= 360.0f;
        }
        while (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    private static int normalizeRotation(int rotation) {
        if ((rotation %= 360) < 0) {
            rotation += 360;
        }
        return rotation;
    }

    private void notifyFailureMessage(ServerLevel level, Component message) {
        if (this.failureMessageSent || level == null || this.isSystemTask() || this.playerName == null || this.playerName.isEmpty()) {
            return;
        }
        ServerPlayer player = level.m_7654_().m_6846_().m_11255_(this.playerName);
        if (player != null) {
            player.m_213846_(message);
        }
        this.failureMessageSent = true;
    }

    public UUID getTaskId() {
        return this.taskId;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public boolean isPreparing() {
        return this.preparing;
    }

    public UUID getRegisteredBuildingId() {
        return this.registeredBuildingId;
    }

    public void setRegisteredBuildingId(UUID registeredBuildingId) {
        this.registeredBuildingId = registeredBuildingId;
    }

    public List<ChunkPos> getRequiredChunks() {
        return this.requiredChunksForBuilding;
    }

    public float getProgress() {
        if (this.pendingPlacements == null || this.pendingPlacements.isEmpty()) {
            return 1.0f;
        }
        return (float)this.currentIndex / (float)this.pendingPlacements.size();
    }

    public long getTotalBuildTimeTicks() {
        return this.totalBuildTime;
    }

    private boolean isSystemTask() {
        return "SYSTEM".equals(this.playerName);
    }

    public String getTemplateName() {
        return this.template != null ? this.template.getName() : this.templateId;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public int getPlacedBlocks() {
        return this.placedBlocks;
    }

    public int getFailedBlocks() {
        return this.failedBlocks;
    }

    public BlockPos getCenterPosition() {
        if (this.minPos != null && this.maxPos != null) {
            return new BlockPos((this.minPos.m_123341_() + this.maxPos.m_123341_()) / 2, (this.minPos.m_123342_() + this.maxPos.m_123342_()) / 2, (this.minPos.m_123343_() + this.maxPos.m_123343_()) / 2);
        }
        return this.position;
    }

    public boolean isSystemGenerated() {
        return "SYSTEM".equals(this.playerName);
    }

    public BlockPos getMinPos() {
        return this.minPos;
    }

    public BlockPos getMaxPos() {
        return this.maxPos;
    }

    private static class BlockPlacement {
        final BlockPos worldPos;
        final BlockState state;
        final CompoundTag tileData;
        final boolean isConnectionLayer;

        BlockPlacement(BlockPos worldPos, BlockState state, CompoundTag tileData) {
            this(worldPos, state, tileData, false);
        }

        BlockPlacement(BlockPos worldPos, BlockState state, CompoundTag tileData, boolean isConnectionLayer) {
            this.worldPos = worldPos;
            this.state = state;
            this.tileData = tileData;
            this.isConnectionLayer = isConnectionLayer;
        }
    }

    private static class ConnectionColumn {
        final BlockPos basePos;
        final BlockState blockState;
        final int maxDepth;
        boolean initialChecked = false;
        boolean needsConnection = false;
        boolean counted = false;
        boolean done = false;
        int processedDepth = 0;
        boolean reachedMaxDepth = false;

        ConnectionColumn(BlockPos basePos, BlockState blockState, int maxDepth) {
            this.basePos = basePos;
            this.blockState = blockState;
            this.maxDepth = maxDepth;
        }
    }
}

