/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.template;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import ydmsama.hundred_years_war.main.template.attribute.TemplateAttributes;

public class HywStructureTemplate {
    private static final int CHUNK_SIZE = 16;
    private final String name;
    private final String category;
    private final String description;
    private final BlockPos size;
    private final BlockPos entrance;
    private final long createdTime;
    private final String author;
    private final float playerYaw;
    private final Map<ChunkPos, TemplateChunk> chunks;
    private final List<EntityData> entities;
    private final Map<String, Integer> blockCount;
    private final int totalBlocks;
    private final boolean includeEntities;
    private final boolean includeBlockData;
    private final boolean hasMirrorVersion;
    private final boolean enableGeneration;
    private final int generationWeight;
    private final int connectionLayerDepth;
    private final int minGenerationHeight;
    private final int maxGenerationHeight;
    private final boolean generateOnSurface;
    private final Map<String, JsonElement> customAttributes;

    private HywStructureTemplate(Builder builder) {
        this.name = builder.name;
        this.category = builder.category;
        this.description = builder.description;
        this.size = builder.size;
        this.entrance = builder.entrance;
        this.createdTime = builder.createdTime;
        this.author = builder.author;
        this.playerYaw = builder.playerYaw;
        this.chunks = builder.chunks;
        this.entities = builder.entities;
        this.blockCount = builder.blockCount;
        this.totalBlocks = builder.totalBlocks;
        this.includeEntities = builder.includeEntities;
        this.includeBlockData = builder.includeBlockData;
        this.hasMirrorVersion = builder.hasMirrorVersion;
        this.enableGeneration = builder.enableGeneration;
        this.generationWeight = builder.generationWeight;
        this.connectionLayerDepth = builder.connectionLayerDepth;
        this.minGenerationHeight = builder.minGenerationHeight;
        this.maxGenerationHeight = builder.maxGenerationHeight;
        this.generateOnSurface = builder.generateOnSurface;
        this.customAttributes = Collections.unmodifiableMap(HywStructureTemplate.cloneAttributes(builder.customAttributes));
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public BlockPos getSize() {
        return this.size;
    }

    public BlockPos getEntrance() {
        return this.entrance;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public String getAuthor() {
        return this.author;
    }

    public float getPlayerYaw() {
        return this.playerYaw;
    }

    public Map<ChunkPos, TemplateChunk> getChunks() {
        return this.chunks;
    }

    public List<EntityData> getEntities() {
        return this.entities;
    }

    public Map<String, Integer> getBlockCount() {
        return this.blockCount;
    }

    public int getTotalBlocks() {
        return this.totalBlocks;
    }

    public boolean includesEntities() {
        return this.includeEntities;
    }

    public boolean includesBlockData() {
        return this.includeBlockData;
    }

    public boolean hasMirrorVersion() {
        return this.hasMirrorVersion;
    }

    public boolean isGenerationEnabled() {
        return this.enableGeneration;
    }

    public int getGenerationWeight() {
        return this.generationWeight;
    }

    public int getConnectionLayerDepth() {
        return this.connectionLayerDepth;
    }

    public int getMinGenerationHeight() {
        return this.minGenerationHeight;
    }

    public int getMaxGenerationHeight() {
        return this.maxGenerationHeight;
    }

    public boolean isGenerateOnSurface() {
        return this.generateOnSurface;
    }

    public Map<String, JsonElement> getCustomAttributes() {
        return this.customAttributes;
    }

    public BlockState getBlockAt(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos.m_123341_() / 16, pos.m_123342_() / 16, pos.m_123343_() / 16);
        TemplateChunk chunk = this.chunks.get(chunkPos);
        if (chunk == null) {
            return null;
        }
        return chunk.getBlock(pos.m_123341_() % 16, pos.m_123342_() % 16, pos.m_123343_() % 16);
    }

    private static Map<String, JsonElement> cloneAttributes(Map<String, JsonElement> source) {
        LinkedHashMap<String, JsonElement> copy = new LinkedHashMap<String, JsonElement>();
        if (source != null) {
            source.forEach((key, value) -> copy.put((String)key, HywStructureTemplate.cloneJsonElement(value)));
        }
        return copy;
    }

    private static JsonElement cloneJsonElement(JsonElement element) {
        if (element == null) {
            return JsonNull.INSTANCE;
        }
        return element.deepCopy();
    }

    public static class Builder {
        private final String name;
        private final BlockPos size;
        private String category = "\u672a\u5206\u7c7b";
        private String description = "";
        private BlockPos entrance = BlockPos.f_121853_;
        private long createdTime = System.currentTimeMillis();
        private String author = "Unknown";
        private float playerYaw = 0.0f;
        private final Map<ChunkPos, TemplateChunk> chunks = new HashMap<ChunkPos, TemplateChunk>();
        private final List<EntityData> entities = new ArrayList<EntityData>();
        private final Map<String, Integer> blockCount = new HashMap<String, Integer>();
        private int totalBlocks = 0;
        private boolean includeEntities = false;
        private boolean includeBlockData = false;
        private boolean hasMirrorVersion = false;
        private boolean enableGeneration = false;
        private int generationWeight = 1;
        private int connectionLayerDepth = 10;
        private int minGenerationHeight = -64;
        private int maxGenerationHeight = 320;
        private boolean generateOnSurface = true;
        private final Map<String, JsonElement> customAttributes = new LinkedHashMap<String, JsonElement>();

        public Builder(String name, BlockPos size) {
            this.name = name;
            this.size = size;
        }

        public Builder setCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setEntrance(BlockPos entrance) {
            this.entrance = entrance;
            return this;
        }

        public Builder setAuthor(String author) {
            this.author = author;
            return this;
        }

        public Builder setCreatedTime(long createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public Builder setPlayerYaw(float yaw) {
            this.playerYaw = yaw;
            return this;
        }

        public Builder setIncludeEntities(boolean include) {
            this.includeEntities = include;
            return this;
        }

        public Builder setIncludeBlockData(boolean include) {
            this.includeBlockData = include;
            return this;
        }

        public Builder setHasMirrorVersion(boolean has) {
            this.hasMirrorVersion = has;
            return this;
        }

        public Builder setEnableGeneration(boolean enable) {
            this.enableGeneration = enable;
            return this;
        }

        public Builder setGenerationWeight(int weight) {
            this.generationWeight = weight;
            return this;
        }

        public Builder setConnectionLayerDepth(int depth) {
            this.connectionLayerDepth = depth;
            return this;
        }

        public Builder setMinGenerationHeight(int height) {
            this.minGenerationHeight = height;
            return this;
        }

        public Builder setMaxGenerationHeight(int height) {
            this.maxGenerationHeight = height;
            return this;
        }

        public Builder setGenerateOnSurface(boolean generateOnSurface) {
            this.generateOnSurface = generateOnSurface;
            return this;
        }

        public Builder putAttribute(String key, JsonElement value) {
            if (key != null) {
                this.customAttributes.put(key, TemplateAttributes.normaliseValue(key, value));
            }
            return this;
        }

        public Builder putAllAttributes(Map<String, JsonElement> attributes) {
            if (attributes != null) {
                attributes.forEach(this::putAttribute);
            }
            return this;
        }

        public Builder addBlock(BlockPos pos, BlockState state, CompoundTag tileEntity) {
            if (state.m_60795_()) {
                return this;
            }
            ChunkPos chunkPos = new ChunkPos(pos.m_123341_() / 16, pos.m_123342_() / 16, pos.m_123343_() / 16);
            TemplateChunk chunk = this.chunks.computeIfAbsent(chunkPos, k -> new TemplateChunk());
            chunk.setBlock(pos.m_123341_() % 16, pos.m_123342_() % 16, pos.m_123343_() % 16, state, (CompoundTag)(this.includeBlockData ? tileEntity : null));
            String blockId = state.m_60734_().m_7705_();
            this.blockCount.merge(blockId, 1, Integer::sum);
            ++this.totalBlocks;
            return this;
        }

        public Builder addEntity(String entityType, BlockPos relativePos, CompoundTag nbt) {
            if (this.includeEntities) {
                this.entities.add(new EntityData(entityType, relativePos, nbt));
            }
            return this;
        }

        public HywStructureTemplate build() {
            return new HywStructureTemplate(this);
        }
    }

    public static class ChunkPos {
        public final int x;
        public final int y;
        public final int z;

        public ChunkPos(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChunkPos chunkPos = (ChunkPos)o;
            return this.x == chunkPos.x && this.y == chunkPos.y && this.z == chunkPos.z;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y, this.z);
        }
    }

    public static class TemplateChunk {
        private final BlockState[][][] blocks = new BlockState[16][16][16];
        private final CompoundTag[][][] tileData = new CompoundTag[16][16][16];
        private int nonAirCount = 0;

        public void setBlock(int x, int y, int z, BlockState state, CompoundTag tileEntity) {
            this.blocks[x][y][z] = state;
            if (tileEntity != null) {
                this.tileData[x][y][z] = tileEntity;
            }
            if (!state.m_60795_()) {
                ++this.nonAirCount;
            }
        }

        public BlockState getBlock(int x, int y, int z) {
            return this.blocks[x][y][z];
        }

        public CompoundTag getTileData(int x, int y, int z) {
            return this.tileData[x][y][z];
        }

        public boolean isEmpty() {
            return this.nonAirCount == 0;
        }
    }

    public static class EntityData {
        public final String entityType;
        public final BlockPos relativePos;
        public final CompoundTag nbt;

        public EntityData(String entityType, BlockPos relativePos, CompoundTag nbt) {
            this.entityType = entityType;
            this.relativePos = relativePos;
            this.nbt = nbt;
        }
    }
}

