/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.template;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ydmsama.hundred_years_war.main.generation.StructureLocationGenerator;
import ydmsama.hundred_years_war.main.template.PlacedBuilding;

public class PlacedBuildingRegistry
extends SavedData {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlacedBuildingRegistry.class);
    private static final String DATA_NAME = "hundred_years_war_placed_buildings";
    private static final String LEGACY_GRID_TAG = "legacyBlockedGrids";
    private static final String LEGACY_SWEEP_DONE_TAG = "legacySweepDone";
    private static final Pattern REGION_FILE_PATTERN = Pattern.compile("r\\.(-?\\d+)\\.(-?\\d+)\\.mca");
    private static final int REGION_FILE_HEADER_BYTES = 4096;
    private static final int GRID_SIZE = StructureLocationGenerator.getGridSize();
    private final Map<UUID, PlacedBuilding> buildings = new ConcurrentHashMap<UUID, PlacedBuilding>();
    private final Map<ChunkPos, Set<UUID>> chunkToBuildingsMap = new ConcurrentHashMap<ChunkPos, Set<UUID>>();
    private final Map<String, Set<UUID>> playerBuildingsMap = new ConcurrentHashMap<String, Set<UUID>>();
    private final LongOpenHashSet legacyBlockedGrids = new LongOpenHashSet();
    private boolean legacySweepDone = false;

    private static void logInfo(String message, Object ... args) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info(message, args);
        }
    }

    private static void logWarn(String message, Object ... args) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.warn(message, args);
        }
    }

    public PlacedBuildingRegistry() {
    }

    public PlacedBuildingRegistry(CompoundTag tag) {
        ListTag buildingsList = tag.m_128437_("buildings", 10);
        for (int i = 0; i < buildingsList.size(); ++i) {
            PlacedBuilding building = new PlacedBuilding(buildingsList.m_128728_(i));
            this.registerBuildingInternal(building);
        }
        if (tag.m_128441_(LEGACY_GRID_TAG)) {
            long[] grids;
            for (long grid : grids = tag.m_128467_(LEGACY_GRID_TAG)) {
                this.legacyBlockedGrids.add(grid);
            }
        }
        this.legacySweepDone = tag.m_128471_(LEGACY_SWEEP_DONE_TAG);
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag buildingsList = new ListTag();
        for (PlacedBuilding building : this.buildings.values()) {
            buildingsList.add((Object)building.save());
        }
        tag.m_128365_("buildings", (Tag)buildingsList);
        if (!this.legacyBlockedGrids.isEmpty()) {
            tag.m_128388_(LEGACY_GRID_TAG, this.legacyBlockedGrids.toLongArray());
        }
        tag.m_128379_(LEGACY_SWEEP_DONE_TAG, this.legacySweepDone);
        return tag;
    }

    public UUID registerBuilding(String templateId, String templateName, BlockPos minPos, BlockPos maxPos, BlockPos entrancePos, String placedBy, long placedTime) {
        UUID buildingId = UUID.randomUUID();
        PlacedBuilding building = new PlacedBuilding(buildingId, templateId, templateName, minPos, maxPos, entrancePos, placedBy, placedTime);
        List<PlacedBuilding> conflicts = this.checkCollisions(minPos, maxPos);
        if (!conflicts.isEmpty()) {
            return null;
        }
        this.registerBuildingInternal(building);
        this.m_77762_();
        return buildingId;
    }

    private void registerBuildingInternal(PlacedBuilding building) {
        this.buildings.put(building.getBuildingId(), building);
        this.playerBuildingsMap.computeIfAbsent(building.getPlacedBy(), k -> new HashSet()).add(building.getBuildingId());
        this.updateChunkMappings(building);
    }

    private void updateChunkMappings(PlacedBuilding building) {
        BlockPos minPos = building.getMinPos();
        BlockPos maxPos = building.getMaxPos();
        int minChunkX = minPos.m_123341_() >> 4;
        int maxChunkX = maxPos.m_123341_() >> 4;
        int minChunkZ = minPos.m_123343_() >> 4;
        int maxChunkZ = maxPos.m_123343_() >> 4;
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
                this.chunkToBuildingsMap.computeIfAbsent(chunkPos, k -> new HashSet()).add(building.getBuildingId());
            }
        }
    }

    public boolean removeBuilding(UUID buildingId) {
        PlacedBuilding building = this.buildings.remove(buildingId);
        if (building != null) {
            Set<UUID> playerBuildings = this.playerBuildingsMap.get(building.getPlacedBy());
            if (playerBuildings != null) {
                playerBuildings.remove(buildingId);
                if (playerBuildings.isEmpty()) {
                    this.playerBuildingsMap.remove(building.getPlacedBy());
                }
            }
            BlockPos minPos = building.getMinPos();
            BlockPos maxPos = building.getMaxPos();
            int minChunkX = minPos.m_123341_() >> 4;
            int maxChunkX = maxPos.m_123341_() >> 4;
            int minChunkZ = minPos.m_123343_() >> 4;
            int maxChunkZ = maxPos.m_123343_() >> 4;
            for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
                for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                    ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
                    Set<UUID> chunkBuildings = this.chunkToBuildingsMap.get(chunkPos);
                    if (chunkBuildings == null) continue;
                    chunkBuildings.remove(buildingId);
                    if (!chunkBuildings.isEmpty()) continue;
                    this.chunkToBuildingsMap.remove(chunkPos);
                }
            }
            this.m_77762_();
            return true;
        }
        return false;
    }

    public List<PlacedBuilding> checkCollisions(BlockPos minPos, BlockPos maxPos) {
        ArrayList<PlacedBuilding> conflicts = new ArrayList<PlacedBuilding>();
        HashSet<UUID> potentialConflicts = new HashSet<UUID>();
        int minChunkX = minPos.m_123341_() >> 4;
        int maxChunkX = maxPos.m_123341_() >> 4;
        int minChunkZ = minPos.m_123343_() >> 4;
        int maxChunkZ = maxPos.m_123343_() >> 4;
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
                Set<UUID> chunkBuildings = this.chunkToBuildingsMap.get(chunkPos);
                if (chunkBuildings == null) continue;
                potentialConflicts.addAll(chunkBuildings);
            }
        }
        for (UUID buildingId : potentialConflicts) {
            PlacedBuilding building = this.buildings.get(buildingId);
            if (building == null || !building.intersects(minPos, maxPos)) continue;
            conflicts.add(building);
        }
        return conflicts;
    }

    public List<PlacedBuilding> getBuildingsInChunk(ChunkPos chunkPos) {
        Set<UUID> buildingIds = this.chunkToBuildingsMap.get(chunkPos);
        if (buildingIds == null || buildingIds.isEmpty()) {
            return Collections.emptyList();
        }
        return buildingIds.stream().map(this.buildings::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<PlacedBuilding> getBuildingsInArea(BlockPos center, int radius) {
        ArrayList<PlacedBuilding> result = new ArrayList<PlacedBuilding>();
        BlockPos minPos = center.m_7918_(-radius, -radius, -radius);
        BlockPos maxPos = center.m_7918_(radius, radius, radius);
        int minChunkX = minPos.m_123341_() >> 4;
        int maxChunkX = maxPos.m_123341_() >> 4;
        int minChunkZ = minPos.m_123343_() >> 4;
        int maxChunkZ = maxPos.m_123343_() >> 4;
        HashSet<UUID> checked = new HashSet<UUID>();
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
                Set<UUID> chunkBuildings = this.chunkToBuildingsMap.get(chunkPos);
                if (chunkBuildings == null) continue;
                for (UUID buildingId : chunkBuildings) {
                    if (checked.contains(buildingId)) continue;
                    checked.add(buildingId);
                    PlacedBuilding building = this.buildings.get(buildingId);
                    if (building == null || !building.intersects(minPos, maxPos)) continue;
                    result.add(building);
                }
            }
        }
        return result;
    }

    public List<PlacedBuilding> getPlayerBuildings(String playerName) {
        Set<UUID> buildingIds = this.playerBuildingsMap.get(playerName);
        if (buildingIds == null || buildingIds.isEmpty()) {
            return Collections.emptyList();
        }
        return buildingIds.stream().map(this.buildings::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public PlacedBuilding getBuilding(UUID buildingId) {
        return this.buildings.get(buildingId);
    }

    public int getBuildingCount() {
        return this.buildings.size();
    }

    public synchronized void ensureLegacySweep(ServerLevel level) {
        if (this.legacySweepDone || level == null) {
            return;
        }
        int added = this.performLegacySweep(level);
        this.legacySweepDone = true;
        if (added > 0) {
            this.m_77762_();
            PlacedBuildingRegistry.logInfo("\u6ce8\u518c\u65e7\u533a\u5757\u5b8c\u6210\uff0c\u8df3\u8fc7 {} \u4e2a\u7f51\u683c", added);
        } else {
            this.m_77762_();
        }
    }

    public boolean isLegacyGridBlocked(long gridKey) {
        return this.legacyBlockedGrids.contains(gridKey);
    }

    public boolean isLegacyGridBlocked(int gridX, int gridZ) {
        return this.isLegacyGridBlocked(ChunkPos.m_45589_((int)gridX, (int)gridZ));
    }

    private int performLegacySweep(ServerLevel level) {
        Path regionDir = level.m_7654_().m_129843_(LevelResource.f_78182_).resolve("region");
        if (!Files.isDirectory(regionDir, new LinkOption[0])) {
            return 0;
        }
        int blocked = 0;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(regionDir, "r.*.mca");){
            for (Path regionFile : stream) {
                Matcher matcher = REGION_FILE_PATTERN.matcher(regionFile.getFileName().toString());
                if (!matcher.matches()) continue;
                int regionX = Integer.parseInt(matcher.group(1));
                int regionZ = Integer.parseInt(matcher.group(2));
                blocked += this.readRegionHeader(regionFile, regionX, regionZ);
            }
        }
        catch (IOException e) {
            LOGGER.warn("\u626b\u63cf\u65e7\u533a\u5757\u5931\u8d25", (Throwable)e);
        }
        return blocked;
    }

    private int readRegionHeader(Path regionFile, int regionX, int regionZ) throws IOException {
        try (FileChannel channel = FileChannel.open(regionFile, StandardOpenOption.READ);){
            ByteBuffer header = ByteBuffer.allocate(4096);
            if (channel.read(header) < 4096) {
                int n = 0;
                return n;
            }
            header.flip();
            int added = 0;
            for (int i = 0; i < 1024 && header.remaining() >= 4; ++i) {
                int localZ;
                int chunkZ;
                int localX;
                int chunkX;
                long gridKey;
                int entry = header.getInt();
                int offset = entry >> 8 & 0xFFFFFF;
                int sectorCount = entry & 0xFF;
                if (offset == 0 || sectorCount == 0 || !this.legacyBlockedGrids.add(gridKey = PlacedBuildingRegistry.chunkToGridKey(chunkX = (regionX << 5) + (localX = i & 0x1F), chunkZ = (regionZ << 5) + (localZ = i >> 5)))) continue;
                ++added;
            }
            int n = added;
            return n;
        }
    }

    private static long chunkToGridKey(int chunkX, int chunkZ) {
        int blockX = chunkX << 4;
        int blockZ = chunkZ << 4;
        int gridX = Math.floorDiv(blockX, GRID_SIZE);
        int gridZ = Math.floorDiv(blockZ, GRID_SIZE);
        return ChunkPos.m_45589_((int)gridX, (int)gridZ);
    }

    public static PlacedBuildingRegistry get(ServerLevel world) {
        DimensionDataStorage storage = world.m_8895_();
        return (PlacedBuildingRegistry)storage.m_164861_(PlacedBuildingRegistry::new, PlacedBuildingRegistry::new, DATA_NAME);
    }

    public static PlacedBuildingRegistry get(MinecraftServer server) {
        return PlacedBuildingRegistry.get(server.m_129783_());
    }
}

