/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.template.attribute;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.util.Locale;
import ydmsama.hundred_years_war.main.template.attribute.TemplateAttributeType;

public class TemplateAttributeDefinition {
    private final String key;
    private final TemplateAttributeType type;
    private final JsonElement defaultValue;
    private final boolean required;
    private final Double minimum;
    private final Double maximum;

    public TemplateAttributeDefinition(String key, TemplateAttributeType type, JsonElement defaultValue, boolean required) {
        this(key, type, defaultValue, required, null, null);
    }

    public TemplateAttributeDefinition(String key, TemplateAttributeType type, JsonElement defaultValue, boolean required, Double minimum, Double maximum) {
        this.key = key;
        this.type = type;
        this.defaultValue = defaultValue == null ? JsonNull.INSTANCE : defaultValue.deepCopy();
        this.required = required;
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public String getKey() {
        return this.key;
    }

    public TemplateAttributeType getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public JsonElement createDefaultValue() {
        return TemplateAttributeDefinition.clone(this.defaultValue);
    }

    public JsonElement normalise(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return this.createDefaultValue();
        }
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case TemplateAttributeType.BOOLEAN -> new JsonPrimitive(Boolean.valueOf(TemplateAttributeDefinition.parseBoolean(element, TemplateAttributeDefinition.asBoolean(this.defaultValue, false))));
            case TemplateAttributeType.INTEGER -> new JsonPrimitive((Number)this.applyNumericBounds(TemplateAttributeDefinition.parseInteger(element, TemplateAttributeDefinition.asInteger(this.defaultValue, 0))));
            case TemplateAttributeType.DOUBLE -> new JsonPrimitive((Number)this.applyFloatingBounds(TemplateAttributeDefinition.parseDouble(element, TemplateAttributeDefinition.asDouble(this.defaultValue, 0.0))));
            case TemplateAttributeType.STRING -> new JsonPrimitive(TemplateAttributeDefinition.parseString(element, TemplateAttributeDefinition.asString(this.defaultValue, "")));
            case TemplateAttributeType.STRING_LIST -> TemplateAttributeDefinition.normaliseStringList(element);
            case TemplateAttributeType.INTEGER_LIST -> TemplateAttributeDefinition.normaliseIntegerList(element);
            case TemplateAttributeType.DOUBLE_LIST -> TemplateAttributeDefinition.normaliseDoubleList(element);
            case TemplateAttributeType.TAGS -> TemplateAttributeDefinition.normaliseTagList(element);
        };
    }

    private int applyNumericBounds(int value) {
        if (this.minimum != null && (double)value < this.minimum) {
            return this.minimum.intValue();
        }
        if (this.maximum != null && (double)value > this.maximum) {
            return this.maximum.intValue();
        }
        return value;
    }

    private double applyFloatingBounds(double value) {
        double adjusted = value;
        if (this.minimum != null && adjusted < this.minimum) {
            adjusted = this.minimum;
        }
        if (this.maximum != null && adjusted > this.maximum) {
            adjusted = this.maximum;
        }
        return adjusted;
    }

    private static JsonElement clone(JsonElement element) {
        if (element == null) {
            return JsonNull.INSTANCE;
        }
        return element.deepCopy();
    }

    private static JsonElement normaliseStringList(JsonElement element) {
        JsonArray array = new JsonArray();
        if (element.isJsonArray()) {
            element.getAsJsonArray().forEach(item -> {
                String value = TemplateAttributeDefinition.parseString(item, "");
                if (!value.isEmpty()) {
                    array.add(value);
                }
            });
        } else {
            String value = TemplateAttributeDefinition.parseString(element, "");
            if (!value.isEmpty()) {
                array.add(value);
            }
        }
        return array;
    }

    private static JsonElement normaliseIntegerList(JsonElement element) {
        JsonArray array = new JsonArray();
        if (element.isJsonArray()) {
            element.getAsJsonArray().forEach(item -> array.add((Number)TemplateAttributeDefinition.parseInteger(item, 0)));
        } else {
            array.add((Number)TemplateAttributeDefinition.parseInteger(element, 0));
        }
        return array;
    }

    private static JsonElement normaliseDoubleList(JsonElement element) {
        JsonArray array = new JsonArray();
        if (element.isJsonArray()) {
            element.getAsJsonArray().forEach(item -> array.add((Number)TemplateAttributeDefinition.parseDouble(item, 0.0)));
        } else {
            array.add((Number)TemplateAttributeDefinition.parseDouble(element, 0.0));
        }
        return array;
    }

    private static JsonElement normaliseTagList(JsonElement element) {
        JsonArray array = new JsonArray();
        if (element.isJsonArray()) {
            element.getAsJsonArray().forEach(item -> {
                String value = TemplateAttributeDefinition.parseString(item, "").toLowerCase(Locale.ROOT);
                if (!value.isEmpty()) {
                    array.add(value);
                }
            });
        } else {
            String value = TemplateAttributeDefinition.parseString(element, "").toLowerCase(Locale.ROOT);
            if (!value.isEmpty()) {
                array.add(value);
            }
        }
        return array;
    }

    private static boolean parseBoolean(JsonElement element, boolean defaultValue) {
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            if (primitive.isNumber()) {
                return primitive.getAsInt() != 0;
            }
            if (primitive.isString()) {
                String raw = primitive.getAsString().trim().toLowerCase(Locale.ROOT);
                if (raw.equals("true") || raw.equals("1") || raw.equals("yes")) {
                    return true;
                }
                if (raw.equals("false") || raw.equals("0") || raw.equals("no")) {
                    return false;
                }
            }
        }
        return defaultValue;
    }

    private static int parseInteger(JsonElement element, int defaultValue) {
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                return primitive.getAsInt();
            }
            if (primitive.isString()) {
                try {
                    return Integer.parseInt(primitive.getAsString().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return defaultValue;
    }

    private static double parseDouble(JsonElement element, double defaultValue) {
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                return primitive.getAsDouble();
            }
            if (primitive.isString()) {
                try {
                    return Double.parseDouble(primitive.getAsString().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return defaultValue;
    }

    private static String parseString(JsonElement element, String defaultValue) {
        if (element == null || element.isJsonNull()) {
            return defaultValue;
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isString()) {
                return primitive.getAsString();
            }
            if (primitive.isBoolean() || primitive.isNumber()) {
                return primitive.getAsString();
            }
        }
        if (element.isJsonObject() || element.isJsonArray()) {
            return element.toString();
        }
        return defaultValue;
    }

    private static boolean asBoolean(JsonElement element, boolean defaultValue) {
        if (element == null || element.isJsonNull()) {
            return defaultValue;
        }
        return TemplateAttributeDefinition.parseBoolean(element, defaultValue);
    }

    private static int asInteger(JsonElement element, int defaultValue) {
        if (element == null || element.isJsonNull()) {
            return defaultValue;
        }
        return TemplateAttributeDefinition.parseInteger(element, defaultValue);
    }

    private static double asDouble(JsonElement element, double defaultValue) {
        if (element == null || element.isJsonNull()) {
            return defaultValue;
        }
        return TemplateAttributeDefinition.parseDouble(element, defaultValue);
    }

    private static String asString(JsonElement element, String defaultValue) {
        if (element == null || element.isJsonNull()) {
            return defaultValue;
        }
        return TemplateAttributeDefinition.parseString(element, defaultValue);
    }
}

