/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.template.attribute;

import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import ydmsama.hundred_years_war.main.template.attribute.TemplateAttributes;

public class TemplateTagDefinition {
    private final String id;
    private final String translationKey;
    private final Set<String> attributeKeys;

    public TemplateTagDefinition(String id, String translationKey, Collection<String> attributeKeys) {
        this.id = id.toLowerCase(Locale.ROOT);
        this.translationKey = translationKey;
        LinkedHashSet<String> backing = new LinkedHashSet<String>();
        if (attributeKeys != null) {
            backing.addAll(attributeKeys);
        }
        this.attributeKeys = Collections.unmodifiableSet(backing);
    }

    public String getId() {
        return this.id;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public Set<String> getAttributeKeys() {
        return this.attributeKeys;
    }

    public Map<String, JsonElement> createAttributeValues() {
        LinkedHashMap<String, JsonElement> values = new LinkedHashMap<String, JsonElement>();
        for (String key : this.attributeKeys) {
            values.put(key, TemplateAttributes.createDefaultValue(key));
        }
        return values;
    }
}

